/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.insight;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.collection.Coll;
import org.rapidoid.job.Jobs;
import org.rapidoid.log.Log;
import org.rapidoid.timeseries.TimeSeries;
import org.rapidoid.u.U;
import org.rapidoid.util.Once;

public class Metrics
extends RapidoidThing
implements Runnable {
    public static final Map<String, TimeSeries> METRICS = Coll.synchronizedMap();
    public static final TimeSeries SYSTEM_CPU = new TimeSeries().title("System CPU");
    public static final TimeSeries PROCESS_CPU = new TimeSeries().title("Process CPU");
    public static final TimeSeries MEM_USED = new TimeSeries().title("Used JVM memory (MB)");
    public static final TimeSeries MEM_TOTAL = new TimeSeries().title("Total JVM memory (MB)");
    public static final TimeSeries NUM_THREADS = new TimeSeries().title("Number of JVM threads");
    public static final TimeSeries NUM_FILE_DESC = new TimeSeries().title("Open files and connections");
    private static volatile OperatingSystemMXBean os;
    private static volatile Method sysCpuM;
    private static volatile Method procCpuM;
    private static volatile Method openFileDescriptorCount;
    private static volatile ThreadMXBean threads;
    private static final Once once;

    public static void bootstrap() {
        if (!once.go()) {
            return;
        }
        Log.info((String)"Bootstraping metrics");
        os = ManagementFactory.getOperatingSystemMXBean();
        sysCpuM = Cls.findMethod(os.getClass(), "getSystemCpuLoad", new Class[0]);
        procCpuM = Cls.findMethod(os.getClass(), "getProcessCpuLoad", new Class[0]);
        openFileDescriptorCount = Cls.findMethod(os.getClass(), "getOpenFileDescriptorCount", new Class[0]);
        threads = ManagementFactory.getThreadMXBean();
        Metrics.register("cpu/system", SYSTEM_CPU);
        Metrics.register("cpu/process", PROCESS_CPU);
        Metrics.register("mem/used", MEM_USED);
        Metrics.register("mem/total", MEM_TOTAL);
        Metrics.register("threads", NUM_THREADS);
        Metrics.register("descriptors", NUM_FILE_DESC);
        Metrics updateMetrics = new Metrics();
        updateMetrics.run();
        Jobs.scheduleAtFixedRate(updateMetrics, 1L, 1L, TimeUnit.SECONDS);
    }

    public static TimeSeries get(String uri) {
        return METRICS.get(uri);
    }

    public static TimeSeries register(String uri, TimeSeries metric) {
        return METRICS.put(uri, metric);
    }

    @Override
    public void run() {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long maxMem = rt.maxMemory();
        long freeMem = rt.freeMemory();
        long usedMem = totalMem - freeMem;
        double megs = 1048576.0;
        MEM_TOTAL.put(U.time(), (double)totalMem / megs);
        MEM_USED.put(U.time(), (double)usedMem / megs);
        if (sysCpuM != null) {
            SYSTEM_CPU.put(U.time(), ((Number)Cls.invoke(sysCpuM, os, new Object[0])).doubleValue());
        }
        if (procCpuM != null) {
            PROCESS_CPU.put(U.time(), ((Number)Cls.invoke(procCpuM, os, new Object[0])).doubleValue());
        }
        if (openFileDescriptorCount != null) {
            NUM_FILE_DESC.put(U.time(), ((Number)Cls.invoke(openFileDescriptorCount, os, new Object[0])).doubleValue());
        }
        NUM_THREADS.put(U.time(), threads.getThreadCount());
    }

    public static Map<String, TimeSeries> all() {
        return METRICS;
    }

    static {
        once = new Once();
    }
}

