/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.cls.Cls;
import org.rapidoid.sql.JDBCConfig;
import org.rapidoid.sql.JdbcClient;
import org.rapidoid.u.U;

public class JDBC
extends RapidoidThing {
    private static volatile JdbcClient DEFAULT;

    public static synchronized void reset() {
        DEFAULT = null;
    }

    public static JdbcClient newApi() {
        return new JdbcClient();
    }

    public static synchronized JdbcClient setup(String url, String driver, String username, String password) {
        DEFAULT = new JdbcClient();
        DEFAULT.url(url);
        DEFAULT.driver(driver);
        DEFAULT.username(username);
        DEFAULT.password(password);
        return DEFAULT;
    }

    public static synchronized JdbcClient defaultApi() {
        if (DEFAULT == null) {
            String url = JDBCConfig.url();
            String driver = JDBCConfig.driver();
            String username = JDBCConfig.username();
            String password = JDBCConfig.password();
            DEFAULT = JDBC.setup(url, driver, username, password);
        }
        return DEFAULT;
    }

    public static JdbcClient username(String username) {
        return JDBC.defaultApi().username(username);
    }

    public static JdbcClient password(String password) {
        return JDBC.defaultApi().password(password);
    }

    public static JdbcClient driver(String driver) {
        return JDBC.defaultApi().driver(driver);
    }

    public static JdbcClient url(String url) {
        return JDBC.defaultApi().url(url);
    }

    public static JdbcClient mysql(String host, int port, String databaseName) {
        return JDBC.defaultApi().mysql(host, port, databaseName);
    }

    public static JdbcClient h2(String databaseName) {
        return JDBC.defaultApi().h2(databaseName);
    }

    public static JdbcClient hsql(String databaseName) {
        return JDBC.defaultApi().hsql(databaseName);
    }

    public static void execute(String sql, Object ... args) {
        JDBC.defaultApi().execute(sql, args);
    }

    public static void tryToExecute(String sql, Object ... args) {
        JDBC.defaultApi().tryToExecute(sql, args);
    }

    public static <T> List<Map<String, Object>> query(String sql, Object ... args) {
        return JDBC.defaultApi().query(sql, args);
    }

    public static Connection getConnection() {
        return JDBC.defaultApi().getConnection();
    }

    public static void release(Connection connection) {
        JDBC.defaultApi().release(connection);
    }

    public static PreparedStatement prepare(Connection conn, String sql, Object ... args) {
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            JDBC.bind(stmt, args);
            return stmt;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot create prepared statement!", e);
        }
    }

    public static void bind(PreparedStatement stmt, Object ... args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            stmt.setObject(i + 1, args[i]);
        }
    }

    public static <T> List<T> rows(Class<T> resultType, ResultSet rs) throws SQLException {
        List rows = U.list();
        ResultSetMetaData meta = rs.getMetaData();
        int columnsN = meta.getColumnCount();
        Prop[] props = new Prop[columnsN];
        for (int i = 0; i < props.length; ++i) {
            String name = meta.getColumnLabel(i + 1);
            props[i] = Beany.property(resultType, name, true);
        }
        while (rs.next()) {
            T row = Cls.newInstance(resultType);
            for (int i = 0; i < columnsN; ++i) {
                Object value = rs.getObject(i + 1);
                props[i].set(row, value);
            }
            rows.add(row);
        }
        return rows;
    }

    public static List<Map<String, Object>> rows(ResultSet rs) throws SQLException {
        List rows = U.list();
        while (rs.next()) {
            rows.add(JDBC.row(rs));
        }
        return rows;
    }

    public static Map<String, Object> row(ResultSet rs) throws SQLException {
        Map row = U.map();
        ResultSetMetaData meta = rs.getMetaData();
        int columnsNumber = meta.getColumnCount();
        for (int i = 1; i <= columnsNumber; ++i) {
            String name = meta.getColumnLabel(i);
            Object value = rs.getObject(i);
            row.put(name, value);
        }
        return row;
    }
}

