/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.config;

import java.util.List;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.ConfigOption;
import org.rapidoid.u.U;

public class ConfigOptions
extends RapidoidThing {
    public static final Set<String> SERVICE_NAMES = U.set();
    public static final List<ConfigOption> ALL = ConfigOptions.configOptions();
    public static final List<ConfigOption> SERVICES = ConfigOptions.serviceOptions();
    public static final List<ConfigOption> COMMANDS = ConfigOptions.commandOptions();

    private static List<ConfigOption> configOptions() {
        List opts = U.list();
        opts.add(ConfigOptions.opt("config", "configuration filename prefix", "config"));
        opts.add(ConfigOptions.opt("dev", "run in DEV mode", "auto-detected"));
        opts.add(ConfigOptions.opt("production", "run in PRODUCTION mode", "auto-detected"));
        opts.add(ConfigOptions.opt("test", "run in TEST mode", "auto-detected"));
        opts.add(ConfigOptions.opt("secret=<SECRET>", "configure secret key for cryptography", "random"));
        opts.add(ConfigOptions.opt("profiles=<P1,P2...>", "comma-separated list of application profiles (e.g. mysql,prod)", "the 'default' profile"));
        opts.add(ConfigOptions.opt("on.port=<P>", "the default App server will listen at port P", 8888));
        opts.add(ConfigOptions.opt("on.address=<ADDR>", "the default App server will listen at address ADDR", "0.0.0.0"));
        opts.add(ConfigOptions.opt("admin.port=<P>", "the Admin server will listen at port P", "same as on.port"));
        opts.add(ConfigOptions.opt("admin.address=<ADDR>", "the Admin server will listen at address ADDR", "on.address"));
        opts.add(ConfigOptions.opt("app.services=<S1,S2...>", "comma-separated list of services to bootstrap on the App server", "none"));
        opts.add(ConfigOptions.opt("admin.services=<S1,S2...>", "comma-separated list of services to bootstrap on the Admin server", "none"));
        return opts;
    }

    private static List<ConfigOption> serviceOptions() {
        List opts = U.list();
        opts.add(ConfigOptions.srvOpt("center", "Admin Center"));
        opts.add(ConfigOptions.srvOpt("ping", "Simple ping"));
        opts.add(ConfigOptions.srvOpt("status", "Application and system status"));
        opts.add(ConfigOptions.srvOpt("overview", "General overview"));
        opts.add(ConfigOptions.srvOpt("application", "Application management"));
        opts.add(ConfigOptions.srvOpt("lifecycle", "Lifecycle management"));
        opts.add(ConfigOptions.srvOpt("processes", "Process management"));
        opts.add(ConfigOptions.srvOpt("manageables", "Manageable objects"));
        opts.add(ConfigOptions.srvOpt("jmx", "JMX overview"));
        opts.add(ConfigOptions.srvOpt("metrics", "Metrics"));
        opts.add(ConfigOptions.srvOpt("deploy", "Application deployment"));
        opts.add(ConfigOptions.srvOpt("auth", "Authentication"));
        opts.add(ConfigOptions.srvOpt("oauth", "OAuth authentication"));
        opts.add(ConfigOptions.srvOpt("entities", "JPA entities management"));
        opts.add(ConfigOptions.srvOpt("welcome", "Welcome page"));
        opts.add(ConfigOptions.srvOpt("discovery", "Peer discovery (transient state)"));
        opts.add(ConfigOptions.srvOpt("echo", "Echo of the request (for debugging)"));
        return opts;
    }

    private static List<ConfigOption> commandOptions() {
        List opts = U.list();
        opts.add(ConfigOptions.cmd("password", "Generate salted password hash"));
        opts.add(ConfigOptions.cmd("mvn", "Run embedded Maven"));
        return opts;
    }

    private static ConfigOption opt(String name, String desc, Object def) {
        return new ConfigOption(name, desc, def);
    }

    private static ConfigOption srvOpt(String name, String desc) {
        SERVICE_NAMES.add(name);
        return new ConfigOption(name, desc, null);
    }

    private static ConfigOption cmd(String name, String desc) {
        return new ConfigOption(name, desc, null);
    }
}

