/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.datamodel.impl;

import java.util.Iterator;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.datamodel.PageableData;

public class PagingIterator<T>
extends RapidoidThing
implements Iterator<T> {
    private final PageableData<T> data;
    private List<T> page;
    private int offset;
    private int pageLength;
    private int index;

    public PagingIterator(PageableData<T> data) {
        this(data, 100);
    }

    public PagingIterator(PageableData<T> data, int pageLength) {
        this.data = data;
        this.pageLength = pageLength;
    }

    @Override
    public boolean hasNext() {
        if (this.page == null || this.index >= this.page.size()) {
            this.page = this.data.getPage(this.offset, this.pageLength);
            this.offset += this.page.size();
            this.index = 0;
        }
        return this.index < this.page.size();
    }

    @Override
    public T next() {
        return this.page.get(this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

