/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.insight;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.concurrent.Callable;
import org.rapidoid.RapidoidThing;
import org.rapidoid.insight.Metrics;

public class JMXMetrics
extends RapidoidThing {
    public static void bootstrap() {
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof OperatingSystemMXBean) {
            final OperatingSystemMXBean os = (OperatingSystemMXBean)osBean;
            Metrics.measure("Total memory (MB)", (Callable<? extends Number>)new Callable<Double>(){

                @Override
                public Double call() throws Exception {
                    return (double)os.getCommittedVirtualMemorySize() / 1024.0 / 1024.0;
                }
            });
        }
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        for (final GarbageCollectorMXBean gc : gcs) {
            Metrics.measure(gc.getName() + " - GC count", (Callable<? extends Number>)new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return gc.getCollectionCount();
                }
            });
            Metrics.measure(gc.getName() + " - GC time", (Callable<? extends Number>)new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return gc.getCollectionTime();
                }
            });
        }
        final MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        Metrics.measure("Heap memory used (MB)", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                return (double)mem.getHeapMemoryUsage().getUsed() / 1024.0 / 1024.0;
            }
        });
        Metrics.measure("Non-heap memory used (MB)", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                return (double)mem.getNonHeapMemoryUsage().getUsed() / 1024.0 / 1024.0;
            }
        });
        Metrics.measure("Heap memory committed (MB)", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                return (double)mem.getHeapMemoryUsage().getCommitted() / 1024.0 / 1024.0;
            }
        });
        Metrics.measure("Non-heap memory committed (MB)", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                return (double)mem.getNonHeapMemoryUsage().getCommitted() / 1024.0 / 1024.0;
            }
        });
        Metrics.measure("Heap memory max (MB)", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                return (double)mem.getHeapMemoryUsage().getMax() / 1024.0 / 1024.0;
            }
        });
        Metrics.measure("Non-heap memory max (MB)", (Callable<? extends Number>)new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                return (double)mem.getNonHeapMemoryUsage().getMax() / 1024.0 / 1024.0;
            }
        });
        JMXMetrics.memDetails();
    }

    public static void memDetails() {
        List<MemoryPoolMXBean> mems = ManagementFactory.getMemoryPoolMXBeans();
        for (final MemoryPoolMXBean mx : mems) {
            Metrics.measure(mx.getName() + " (MB)", (Callable<? extends Number>)new Callable<Double>(){

                @Override
                public Double call() throws Exception {
                    return (double)mx.getUsage().getUsed() / 1024.0 / 1024.0;
                }
            });
        }
    }
}

