/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.job;

import java.util.concurrent.CancellationException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.job.Jobs;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class ContextPreservingJobWrapper
extends RapidoidThing
implements Runnable {
    private final Runnable job;
    private final Ctx ctx;
    private volatile boolean done;

    public ContextPreservingJobWrapper(Runnable job, Ctx ctx) {
        this.job = job;
        this.ctx = ctx;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block17: {
            U.must((!Ctxs.hasContext() ? 1 : 0) != 0, (String)"Detected context leak!");
            try {
                if (this.ctx != null) {
                    Ctxs.attach(this.ctx);
                } else {
                    Ctxs.open("job");
                    Log.debug((String)"Opening new context");
                }
            }
            catch (CancellationException e) {
                Log.warn((String)"Job context initialization was canceled!");
                this.done = true;
                return;
            }
            catch (Throwable e) {
                Jobs.errorCounter().incrementAndGet();
                Log.error((String)"Job context initialization failed!", (Throwable)e);
                throw U.rte((String)"Job context initialization failed!", (Throwable)e);
            }
            this.job.run();
            break block17;
            catch (CancellationException e) {
                Log.warn((String)"Job execution was canceled!");
                this.done = true;
                return;
            }
            catch (Throwable e) {
                Jobs.errorCounter().incrementAndGet();
                Log.error((String)"Job execution failed!", (Throwable)e);
                throw U.rte((String)"Job execution failed!", (Throwable)e);
            }
            {
                finally {
                    Ctxs.close();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                this.done = true;
            }
        }
    }

    public boolean isDone() {
        return this.done;
    }
}

