/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import org.rapidoid.RapidoidThing;
import org.rapidoid.util.SimpleList;

public class SimpleHashTable<T>
extends RapidoidThing {
    protected static final int DEFAULT_BUCKET_SIZE = 5;
    public final SimpleList<T>[] buckets;

    public SimpleHashTable(int width) {
        this(width, 5);
    }

    public SimpleHashTable(int width, int initialBucketSize) {
        this.buckets = new SimpleList[width];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = this.newList(initialBucketSize);
        }
    }

    protected SimpleList<T> newList(int initialBucketSize) {
        return new SimpleList(initialBucketSize);
    }

    public void put(long key, T value) {
        this.bucket(key).add(value);
    }

    public SimpleList<T> bucket(long key) {
        int index = this.index(key);
        return this.getBucket(index);
    }

    protected SimpleList<T> getBucket(int index) {
        SimpleList<T> list;
        while ((list = this.buckets[index]) == null) {
        }
        return list;
    }

    public int index(long key) {
        return (int)(Math.abs(key) % (long)this.buckets.length);
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.clearBucket(i);
        }
    }

    protected void clearBucket(int index) {
        this.getBucket(index).clear();
    }

    public int bucketCount() {
        return this.buckets.length;
    }
}

