/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.compile.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.rapidoid.util.U;

public class EcjCompilationUnit
implements ICompilationUnit {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+([\\w\\.]+?)\\s*;");
    private static final Pattern PUBLIC_CLASS_PATTERN = Pattern.compile("public\\s+class\\s+(\\w+?)\\b");
    private static final char[][] DEFAULT_PACKAGE = new char[0][];
    private final String packageName;
    private final String className;
    private final String source;

    public EcjCompilationUnit(String packageName, String className, String source) {
        this.packageName = packageName;
        this.className = className;
        this.source = source;
    }

    public EcjCompilationUnit(String source) {
        this.packageName = EcjCompilationUnit.inferPackageName(source);
        this.className = EcjCompilationUnit.inferClassName(source);
        this.source = source;
    }

    public char[] getFileName() {
        return (this.className + ".java").toCharArray();
    }

    public char[] getContents() {
        return this.source.toCharArray();
    }

    public char[] getMainTypeName() {
        return this.className.toCharArray();
    }

    public char[][] getPackageName() {
        return !this.packageName.isEmpty() ? EcjCompilationUnit.toCharArrays(this.packageName.split("\\.")) : DEFAULT_PACKAGE;
    }

    public boolean ignoreOptionalProblems() {
        return false;
    }

    private static String inferClassName(String src) {
        Matcher m = PUBLIC_CLASS_PATTERN.matcher(src);
        if (m.find()) {
            return m.group(1);
        }
        throw U.rte((String)"Couldn't find/infer the public class name from the source!");
    }

    private static String inferPackageName(String src) {
        Matcher m = PACKAGE_PATTERN.matcher(src);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    private static char[][] toCharArrays(String[] arr) {
        char[][] charArr = new char[arr.length][];
        for (int i = 0; i < arr.length; ++i) {
            charArr[i] = arr[i].toCharArray();
        }
        return charArr;
    }
}

