/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.db.impl.inmem;

import java.io.Serializable;
import java.util.Collection;
import org.rapidoid.db.Database;
import org.rapidoid.db.impl.DbRelChangesTracker;
import org.rapidoid.db.impl.DbRelsCommons;
import org.rapidoid.inmem.EntityLinks;
import org.rapidoid.util.U;

public class DbEntityLinks
implements EntityLinks,
Serializable {
    private static final long serialVersionUID = 2212521452392734563L;
    private final Database db;
    private final DbRelsCommons<?> rel;
    private final DbRelChangesTracker tracker;

    public DbEntityLinks(Database db, DbRelsCommons<?> rel, DbRelChangesTracker tracker) {
        this.db = db;
        this.rel = rel;
        this.tracker = tracker;
    }

    public String relationName() {
        return this.rel.getName();
    }

    public long fromId() {
        Object holder = this.rel.getHolder();
        U.notNull((Object)holder, (String)"holder", (Object[])new Object[0]);
        return this.db.getIdOf(holder);
    }

    public Collection<Long> addedRelIds() {
        return this.tracker.getAddedRelations();
    }

    public Collection<Long> removedRelIds() {
        return this.tracker.getRemovedRelations();
    }

    public Collection<Long> allRelIds() {
        return this.rel.getIdsView();
    }

    public void addRelTo(long id) {
        this.rel.addIdWithoutTracking(id);
    }

    public void removeRelTo(long id) {
        this.rel.removeIdWithoutTracking(id);
    }
}

