/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.db.impl.inmem;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.activity.NamedActivity;
import org.rapidoid.beany.Beany;
import org.rapidoid.db.Database;
import org.rapidoid.db.DbColumn;
import org.rapidoid.db.DbList;
import org.rapidoid.db.DbRef;
import org.rapidoid.db.DbSchema;
import org.rapidoid.db.DbSet;
import org.rapidoid.db.impl.DbColumnImpl;
import org.rapidoid.db.impl.DbSchemaImpl;
import org.rapidoid.db.impl.inmem.DbEntityConstructor;
import org.rapidoid.db.impl.inmem.InMemDbList;
import org.rapidoid.db.impl.inmem.InMemDbRef;
import org.rapidoid.db.impl.inmem.InMemDbSet;
import org.rapidoid.db.impl.inmem.JacksonEntitySerializer;
import org.rapidoid.inmem.EntityConstructor;
import org.rapidoid.inmem.EntitySerializer;
import org.rapidoid.inmem.InMem;
import org.rapidoid.lambda.Callback;
import org.rapidoid.lambda.Operation;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.util.U;

public class DbImpl
extends NamedActivity<Database>
implements Database,
Serializable {
    private static final long serialVersionUID = 8806801474242822143L;
    private static final Set<Class<?>> REL_CLASSES = U.set((Object[])new Class[]{DbList.class, DbSet.class, DbRef.class});
    private final DbEntityConstructor constructor = new DbEntityConstructor(this);
    private final InMem inmem;
    private final DbSchema schema;

    public DbImpl(String name, String filename) {
        super(name);
        this.inmem = new InMem(filename, (EntitySerializer)new JacksonEntitySerializer(this), (EntityConstructor)this.constructor, REL_CLASSES, null);
        this.schema = new DbSchemaImpl();
    }

    public DbImpl(String name, InMem inmem, DbSchema schema) {
        super(name);
        this.inmem = inmem;
        this.schema = schema;
    }

    public void initAndLoad() {
        this.inmem.initAndLoad();
    }

    public long insert(Object record) {
        return this.inmem.insert(record);
    }

    public void delete(long id) {
        this.inmem.delete(id);
    }

    public void delete(Object record) {
        this.inmem.delete(record);
    }

    public <E> E get(long id) {
        return (E)this.inmem.get(id);
    }

    public <E> E getIfExists(long id) {
        return (E)this.inmem.getIfExists(id);
    }

    public <E> E get(long id, Class<E> clazz) {
        return (E)this.inmem.get(id, clazz);
    }

    public <E> void refresh(E record) {
        this.inmem.refresh(record);
    }

    public void update(long id, Object record) {
        this.inmem.update(id, record);
    }

    public void update(Object record) {
        this.inmem.update(record);
    }

    public long persist(Object record) {
        return this.inmem.persist(record);
    }

    public long persistedIdOf(Object record) {
        return this.inmem.persistedIdOf(record);
    }

    public <T> T readColumn(long id, String column) {
        return (T)this.inmem.readColumn(id, column);
    }

    public <E> List<E> getAll(Class<E> clazz) {
        return this.inmem.getAll(clazz);
    }

    public <E> List<E> getAll(long ... ids) {
        return this.inmem.getAll(ids);
    }

    public <E> List<E> getAll(Collection<Long> ids) {
        return this.inmem.getAll(ids);
    }

    public <E> List<E> find(Predicate<E> match) {
        return this.inmem.find(match);
    }

    public <E> List<E> find(Iterable<Long> ids) {
        return this.inmem.find(ids);
    }

    public <E> List<E> find(Class<E> clazz, Predicate<E> match, Comparator<E> orderBy) {
        return this.inmem.find(clazz, match, orderBy);
    }

    public <E> List<E> find(String searchPhrase) {
        return this.inmem.find(searchPhrase);
    }

    public <E> List<E> find(Class<E> clazz, String query, Object ... args) {
        return this.inmem.find(clazz, query, args);
    }

    public <E> void each(Operation<E> lambda) {
        this.inmem.each(lambda);
    }

    public void transaction(Runnable transaction, boolean readOnly) {
        this.inmem.transaction(transaction, readOnly);
    }

    public void transaction(Runnable transaction, boolean readOnly, Callback<Void> callback) {
        this.inmem.transaction(transaction, readOnly, callback);
    }

    public void saveTo(OutputStream output) {
        this.inmem.saveTo(output);
    }

    public void load(InputStream in) {
        this.inmem.loadFrom(in);
    }

    public Database start() {
        this.inmem.start();
        return this;
    }

    public Database halt() {
        this.inmem.halt();
        return this;
    }

    public Database shutdown() {
        this.inmem.shutdown();
        return this;
    }

    public boolean isActive() {
        return this.inmem.isActive();
    }

    public void destroy() {
        this.inmem.destroy();
    }

    public long size() {
        return this.inmem.size();
    }

    public void clear() {
        this.inmem.clear();
    }

    public String toString() {
        return "DB:" + this.name + "(" + this.inmem + ")";
    }

    public long getIdOf(Object record) {
        return (Long)U.or((Object)Beany.getIdIfExists((Object)record), (Object)-1L);
    }

    public long getVersionOf(long id) {
        return this.inmem.getVersionOf(id);
    }

    public <E> DbColumn<E> column(Map<String, Object> map, String name, Class<E> type) {
        return new DbColumnImpl(map, name, type);
    }

    public <E> DbList<E> list(Object holder, String relation) {
        return new InMemDbList(this, holder, relation);
    }

    public <E> DbSet<E> set(Object holder, String relation) {
        return new InMemDbSet(this, holder, relation);
    }

    public <E> DbRef<E> ref(Object holder, String relation) {
        return new InMemDbRef(this, holder, relation);
    }

    public DbSchema schema() {
        return this.schema;
    }

    public Database as(String username) {
        return new DbImpl(this.name, this.inmem.as(username), this.schema);
    }

    public Database sudo() {
        return new DbImpl(this.name, this.inmem.sudo(), this.schema);
    }
}

