/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ThreadFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.rapidoid.RapidoidThing;
import org.rapidoid.activity.RapidoidThreadFactory;
import org.rapidoid.commons.Err;
import org.rapidoid.commons.Str;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Callbacks;
import org.rapidoid.concurrent.Future;
import org.rapidoid.concurrent.Promise;
import org.rapidoid.concurrent.Promises;
import org.rapidoid.http.HttpClient;
import org.rapidoid.http.HttpException;
import org.rapidoid.http.HttpReq;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.io.IO;
import org.rapidoid.io.Upload;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class HttpClientUtil
extends RapidoidThing {
    private static final RedirectStrategy NO_REDIRECTS = new RedirectStrategy(){

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return null;
        }
    };

    static CloseableHttpAsyncClient client(HttpClient client) {
        DefaultConnectionReuseStrategy reuseStrategy = client.reuseConnections() ? new DefaultConnectionReuseStrategy() : new NoConnectionReuseStrategy();
        HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setThreadFactory((ThreadFactory)new RapidoidThreadFactory("http-client")).disableConnectionState().disableAuthCaching().setMaxConnPerRoute(client.maxConnPerRoute()).setMaxConnTotal(client.maxConnTotal()).setConnectionReuseStrategy((ConnectionReuseStrategy)reuseStrategy).setRedirectStrategy((RedirectStrategy)(client.followRedirects() ? new DefaultRedirectStrategy() : NO_REDIRECTS));
        if (!U.isEmpty(client.cookies())) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            for (Map.Entry<String, String> e : client.cookies().entrySet()) {
                BasicClientCookie cookie = new BasicClientCookie(e.getKey(), e.getValue());
                String host = client.host();
                U.notNull((Object)host, (String)"HTTP client host", (Object[])new Object[0]);
                cookie.setDomain(HttpClientUtil.getDomain(host));
                cookie.setPath("/");
                cookieStore.addCookie((Cookie)cookie);
            }
            builder = builder.setDefaultCookieStore((CookieStore)cookieStore);
        }
        if (client.userAgent() != null) {
            builder = builder.setUserAgent(client.userAgent());
        }
        if (!client.keepCookies() && U.isEmpty(client.cookies())) {
            builder = builder.disableCookieManagement();
        }
        return builder.build();
    }

    private static String getDomain(String host) {
        String url = host;
        url = Str.triml((String)url, (String)"http://");
        url = Str.triml((String)url, (String)"https://");
        return url.split("(/|:)")[0];
    }

    static HttpRequestBase createRequest(HttpReq config) {
        Map headers = U.safe(config.headers());
        String url = config.url();
        HttpRequestBase req = HttpClientUtil.createReq(config, url);
        for (Map.Entry e : headers.entrySet()) {
            req.addHeader((String)e.getKey(), (String)e.getValue());
        }
        if (config.verb() == HttpVerb.POST || config.verb() == HttpVerb.PUT || config.verb() == HttpVerb.PATCH) {
            HttpEntityEnclosingRequestBase entityEnclosingReq = (HttpEntityEnclosingRequestBase)req;
            entityEnclosingReq.setEntity((HttpEntity)(config.body() != null ? HttpClientUtil.byteBody(config) : HttpClientUtil.paramsBody(config.data(), config.files())));
        }
        req.setConfig(HttpClientUtil.reqConfig(config));
        return req;
    }

    private static RequestConfig reqConfig(HttpReq config) {
        return RequestConfig.custom().setSocketTimeout(config.socketTimeout()).setConnectTimeout(config.connectTimeout()).setConnectionRequestTimeout(config.connectionRequestTimeout()).build();
    }

    private static NByteArrayEntity paramsBody(Map<String, Object> data, Map<String, List<Upload>> files) {
        data = U.safe(data);
        files = U.safe(files);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        for (Map.Entry entry : files.entrySet()) {
            for (Upload file : (List)entry.getValue()) {
                builder = builder.addBinaryBody((String)entry.getKey(), file.content(), ContentType.DEFAULT_BINARY, file.filename());
            }
        }
        for (Map.Entry entry : data.entrySet()) {
            String name = (String)entry.getKey();
            String value = String.valueOf(entry.getValue());
            builder = builder.addTextBody(name, value, ContentType.DEFAULT_TEXT);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            builder.build().writeTo((OutputStream)stream);
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
        byte[] bytes = stream.toByteArray();
        return new NByteArrayEntity(bytes, ContentType.MULTIPART_FORM_DATA);
    }

    private static NByteArrayEntity byteBody(HttpReq config) {
        NByteArrayEntity entity = new NByteArrayEntity(config.body());
        if (config.contentType() != null) {
            entity.setContentType(config.contentType());
        }
        return entity;
    }

    private static HttpRequestBase createReq(HttpReq config, String url) {
        HttpGet req;
        switch (config.verb()) {
            case GET: {
                req = new HttpGet(url);
                break;
            }
            case POST: {
                req = new HttpPost(url);
                break;
            }
            case PUT: {
                req = new HttpPut(url);
                break;
            }
            case DELETE: {
                req = new HttpDelete(url);
                break;
            }
            case PATCH: {
                req = new HttpPatch(url);
                break;
            }
            case OPTIONS: {
                req = new HttpOptions(url);
                break;
            }
            case HEAD: {
                req = new HttpHead(url);
                break;
            }
            case TRACE: {
                req = new HttpTrace(url);
                break;
            }
            default: {
                throw Err.notExpected();
            }
        }
        return req;
    }

    static Future<byte[]> request(HttpReq config, CloseableHttpAsyncClient client, Callback<byte[]> callback, boolean close) {
        HttpRequestBase req = HttpClientUtil.createRequest(config);
        Log.debug((String)"Starting HTTP request", (String)"request", (Object)req.getRequestLine());
        Promise promise = Promises.create();
        FutureCallback<HttpResponse> cb = HttpClientUtil.callback(client, callback, (Callback<byte[]>)promise, config.raw(), close);
        client.execute((HttpUriRequest)req, cb);
        return promise;
    }

    private static <T> FutureCallback<HttpResponse> callback(final CloseableHttpAsyncClient client, final Callback<byte[]> callback, final Callback<byte[]> promise, final boolean fullResponse, final boolean close) {
        return new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                byte[] bytes;
                int statusCode = response.getStatusLine().getStatusCode();
                if (!fullResponse && statusCode != 200) {
                    Callbacks.error((Callback)callback, (Throwable)new HttpException(statusCode));
                    Callbacks.error((Callback)promise, (Throwable)new HttpException(statusCode));
                    if (close) {
                        HttpClientUtil.close(client);
                    }
                    return;
                }
                if (response.getEntity() != null) {
                    try {
                        if (fullResponse) {
                            bytes = HttpClientUtil.responseToBytes(response);
                        }
                        InputStream resp = response.getEntity().getContent();
                        bytes = IO.loadBytes((InputStream)resp);
                        U.must((bytes != null ? 1 : 0) != 0, (String)"Couldn't read the HTTP response!");
                    }
                    catch (Exception e) {
                        Callbacks.error((Callback)callback, (Throwable)e);
                        Callbacks.error((Callback)promise, (Throwable)e);
                        if (close) {
                            HttpClientUtil.close(client);
                        }
                        return;
                    }
                } else {
                    bytes = new byte[]{};
                }
                Callbacks.success((Callback)callback, (Object)bytes);
                Callbacks.success((Callback)promise, (Object)bytes);
                if (close) {
                    HttpClientUtil.close(client);
                }
            }

            public void failed(Exception e) {
                Callbacks.error((Callback)callback, (Throwable)e);
                Callbacks.error((Callback)promise, (Throwable)e);
                if (close) {
                    HttpClientUtil.close(client);
                }
            }

            public void cancelled() {
                Callbacks.error((Callback)callback, (Throwable)new CancellationException());
                Callbacks.error((Callback)promise, (Throwable)new CancellationException());
                if (close) {
                    HttpClientUtil.close(client);
                }
            }
        };
    }

    static byte[] responseToBytes(HttpResponse response) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter printer = new PrintWriter(baos);
        printer.print(response.getStatusLine() + "");
        printer.print("\n");
        for (Header hdr : response.getAllHeaders()) {
            printer.print(hdr.getName());
            printer.print(": ");
            printer.print(hdr.getValue());
            printer.print("\n");
        }
        printer.print("\n");
        printer.flush();
        try {
            response.getEntity().writeTo((OutputStream)baos);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
        return baos.toByteArray();
    }

    static void close(CloseableHttpAsyncClient client) {
        try {
            Log.debug((String)"Closing HTTP client", (String)"client", (Object)client);
            client.close();
        }
        catch (IOException e) {
            throw U.rte((Throwable)e);
        }
    }
}

