/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Err;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Future;
import org.rapidoid.config.Config;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.http.DynamicRESTClient;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.http.RESTClient;
import org.rapidoid.lambda.Dynamic;
import org.rapidoid.util.Msc;

public class REST
extends RapidoidThing {
    public static final RESTClient DEFAULT_CLIENT;

    public static <T> Future<T> get(String uri, Class<T> resultType, Callback<T> callback) {
        return DEFAULT_CLIENT.get(uri, resultType, callback);
    }

    public static <T> T get(String uri, Class<T> resultType) {
        return DEFAULT_CLIENT.get(uri, resultType);
    }

    public static <T> Future<T> post(String uri, Class<T> resultType, Callback<T> callback) {
        return DEFAULT_CLIENT.post(uri, resultType, callback);
    }

    public static <T> T post(String uri, Class<T> resultType) {
        return DEFAULT_CLIENT.post(uri, resultType);
    }

    public static <T> Future<T> put(String uri, Class<T> resultType, Callback<T> callback) {
        return DEFAULT_CLIENT.put(uri, resultType, callback);
    }

    public static <T> T put(String uri, Class<T> resultType) {
        return DEFAULT_CLIENT.put(uri, resultType);
    }

    public static <T> Future<T> delete(String uri, Class<T> resultType, Callback<T> callback) {
        return DEFAULT_CLIENT.delete(uri, resultType, callback);
    }

    public static <T> T delete(String uri, Class<T> resultType) {
        return DEFAULT_CLIENT.delete(uri, resultType);
    }

    public static <T> Future<T> patch(String uri, Class<T> resultType, Callback<T> callback) {
        return DEFAULT_CLIENT.patch(uri, resultType, callback);
    }

    public static <T> T patch(String uri, Class<T> resultType) {
        return DEFAULT_CLIENT.patch(uri, resultType);
    }

    public static <T> Future<T> options(String uri, Class<T> resultType, Callback<T> callback) {
        return DEFAULT_CLIENT.options(uri, resultType, callback);
    }

    public static <T> T options(String uri, Class<T> resultType) {
        return DEFAULT_CLIENT.options(uri, resultType);
    }

    public static <T> Future<T> head(String uri, Class<T> resultType, Callback<T> callback) {
        return DEFAULT_CLIENT.head(uri, resultType, callback);
    }

    public static <T> T head(String uri, Class<T> resultType) {
        return DEFAULT_CLIENT.head(uri, resultType);
    }

    public static <T> Future<T> trace(String uri, Class<T> resultType, Callback<T> callback) {
        return DEFAULT_CLIENT.trace(uri, resultType, callback);
    }

    public static <T> T trace(String uri, Class<T> resultType) {
        return DEFAULT_CLIENT.trace(uri, resultType);
    }

    public static <T> T call(String verb, String uri, Class<T> resultType) {
        switch (HttpVerb.from((String)verb)) {
            case GET: {
                return REST.get(uri, resultType);
            }
            case POST: {
                return REST.post(uri, resultType);
            }
            case PUT: {
                return REST.put(uri, resultType);
            }
            case DELETE: {
                return REST.delete(uri, resultType);
            }
            case PATCH: {
                return REST.patch(uri, resultType);
            }
            case OPTIONS: {
                return REST.options(uri, resultType);
            }
            case HEAD: {
                return REST.head(uri, resultType);
            }
            case TRACE: {
                return REST.trace(uri, resultType);
            }
        }
        throw Err.notExpected();
    }

    public static <T> Future<T> call(String verb, String uri, Class<T> resultType, Callback<T> callback) {
        switch (HttpVerb.from((String)verb)) {
            case GET: {
                return REST.get(uri, resultType, callback);
            }
            case POST: {
                return REST.post(uri, resultType, callback);
            }
            case PUT: {
                return REST.put(uri, resultType, callback);
            }
            case DELETE: {
                return REST.delete(uri, resultType, callback);
            }
            case PATCH: {
                return REST.patch(uri, resultType, callback);
            }
            case OPTIONS: {
                return REST.options(uri, resultType, callback);
            }
            case HEAD: {
                return REST.head(uri, resultType, callback);
            }
            case TRACE: {
                return REST.trace(uri, resultType, callback);
            }
        }
        throw Err.notExpected();
    }

    public static <T> T client(Class<T> clientInterface) {
        return (T)Msc.dynamic(clientInterface, (Dynamic)new DynamicRESTClient(clientInterface));
    }

    public static <T> T client(Class<T> clientInterface, Config config) {
        return (T)Msc.dynamic(clientInterface, (Dynamic)new DynamicRESTClient(clientInterface, config));
    }

    static {
        RapidoidInitializer.initialize();
        DEFAULT_CLIENT = new RESTClient();
    }
}

