package org.rapidoid.http;

import org.rapidoid.annotation.Authors;
import org.rapidoid.annotation.Since;

/*
 * #%L
 * rapidoid-http
 * %%
 * Copyright (C) 2014 - 2015 Nikolche Mihajlovski
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

@Authors("Nikolche Mihajlovski")
@Since("2.0.0")
public class HttpHeader {

	public static final HttpHeader SET_COOKIE = new HttpHeader("Set-Cookie");

	public static final HttpHeader CONTENT_TYPE = new HttpHeader("Content-Type");

	public static final HttpHeader CONTENT_DISPOSITION = new HttpHeader("Content-Disposition");

	public static final HttpHeader CACHE_CONTROL = new HttpHeader("Cache-Control");

	public static final HttpHeader LOCATION = new HttpHeader("Location");

	private final byte[] bytes;

	public HttpHeader(String name) {
		this.bytes = name.getBytes();
	}

	public byte[] getBytes() {
		return bytes;
	}

}
