/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.rapidoid.annotation.TransactionMode;
import org.rapidoid.config.Conf;
import org.rapidoid.data.BinaryMultiData;
import org.rapidoid.data.Data;
import org.rapidoid.data.KeyValueRanges;
import org.rapidoid.data.MultiData;
import org.rapidoid.data.Range;
import org.rapidoid.data.Ranges;
import org.rapidoid.http.HTMLSnippets;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeBody;
import org.rapidoid.http.HttpExchangeHeaders;
import org.rapidoid.http.HttpHeader;
import org.rapidoid.http.HttpInterception;
import org.rapidoid.http.HttpNotFoundException;
import org.rapidoid.http.HttpOutputStream;
import org.rapidoid.http.HttpParser;
import org.rapidoid.http.HttpResponse;
import org.rapidoid.http.HttpResponses;
import org.rapidoid.http.HttpSession;
import org.rapidoid.http.HttpSuccessException;
import org.rapidoid.http.LowLevelHttpExchange;
import org.rapidoid.http.Router;
import org.rapidoid.inject.IoC;
import org.rapidoid.log.Log;
import org.rapidoid.mime.MediaType;
import org.rapidoid.net.impl.ConnState;
import org.rapidoid.net.impl.DefaultExchange;
import org.rapidoid.security.Secure;
import org.rapidoid.util.Cls;
import org.rapidoid.util.Constants;
import org.rapidoid.util.IO;
import org.rapidoid.util.Rnd;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;
import org.rapidoid.util.UserInfo;
import org.rapidoid.wrap.BoolWrap;

public class HttpExchangeImpl
extends DefaultExchange<HttpExchange, HttpExchangeBody>
implements LowLevelHttpExchange,
HttpInterception,
Constants {
    public static final String SESSION_COOKIE = "JSESSIONID";
    public static final String SESSION_PAGE_STACK = "_page_stack_";
    private static final HttpParser PARSER = (HttpParser)IoC.singleton(HttpParser.class);
    private static final byte[] HEADER_SEP = ": ".getBytes();
    private static final Pattern STATIC_RESOURCE_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\.\\-/]+$");
    final Range uri = new Range();
    final Range verb = new Range();
    final Range path = new Range();
    final Range query = new Range();
    final Range protocol = new Range();
    final Ranges headers = new Ranges(50);
    private final KeyValueRanges params = new KeyValueRanges(50);
    private final KeyValueRanges headersKV = new KeyValueRanges(50);
    private final KeyValueRanges cookies = new KeyValueRanges(50);
    private final KeyValueRanges data = new KeyValueRanges(50);
    private final KeyValueRanges files = new KeyValueRanges(50);
    final Range body = new Range();
    final BoolWrap isGet = new BoolWrap();
    final BoolWrap isKeepAlive = new BoolWrap();
    private TransactionMode txMode = null;
    private boolean parsedParams;
    private boolean parsedHeaders;
    private boolean parsedBody;
    private int bodyPos;
    private boolean writesBody;
    private boolean hasContentType;
    private int startingPos;
    private HttpResponses responses;
    private HttpSession session;
    private Router router;
    private Map<Object, Object> extras;
    private Map<String, String> vars;
    final Range multipartBoundary = new Range();
    private final Range subpathRange = new Range();
    private final Data _body;
    private final Data _uri;
    private final Data _verb;
    private final Data _path;
    private final Data _subpath;
    private final Data _query;
    private final Data _protocol;
    private final MultiData _params;
    private final MultiData _headers;
    private final MultiData _cookies;
    private final MultiData _data;
    private final BinaryMultiData _files;
    private int responseCode;
    private String redirectUrl;
    private String sessionId;
    private Throwable error;
    private boolean complete;
    private boolean lowLevelProcessing;
    private ClassLoader classLoader;

    public HttpExchangeImpl() {
        this.reset();
        this._body = this.data(this.body);
        this._uri = this.data(this.uri);
        this._verb = this.data(this.verb);
        this._path = this.decodedData(this.path);
        this._subpath = this.decodedData(this.subpathRange);
        this._query = this.decodedData(this.query);
        this._protocol = this.data(this.protocol);
        this._params = this.multiData(this.params);
        this._headers = this.multiData(this.headersKV);
        this._cookies = this.multiData(this.cookies);
        this._data = this.multiData(this.data);
        this._files = this.binaryMultiData(this.files);
    }

    public synchronized void reset() {
        super.reset();
        this.isGet.value = false;
        this.isKeepAlive.value = false;
        this.txMode = null;
        this.extras = null;
        this.verb.reset();
        this.uri.reset();
        this.path.reset();
        this.query.reset();
        this.protocol.reset();
        this.body.reset();
        this.multipartBoundary.reset();
        this.params.reset();
        this.headersKV.reset();
        this.headers.reset();
        this.cookies.reset();
        this.data.reset();
        this.files.reset();
        this.vars = null;
        this.parsedParams = false;
        this.parsedHeaders = false;
        this.parsedBody = false;
        this.sessionId = null;
        this.session = null;
        this.router = null;
        this.resetResponse();
    }

    private void resetResponse() {
        this.writesBody = false;
        this.bodyPos = -1;
        this.hasContentType = false;
        this.responses = null;
        this.responseCode = -1;
        this.redirectUrl = null;
        this.error = null;
        this.complete = false;
        this.lowLevelProcessing = false;
    }

    public void log(String msg) {
        this.conn.log(msg);
    }

    @Override
    public synchronized MultiData params_() {
        if (!this.parsedParams) {
            if (!this.query.isEmpty()) {
                PARSER.parseParams(this.input(), this.params, this.query_().range());
            }
            this.parsedParams = true;
        }
        return this._params;
    }

    @Override
    public synchronized MultiData headers_() {
        if (!this.parsedHeaders) {
            if (!this.headers.isEmpty()) {
                PARSER.parseHeadersIntoKV(this.input(), this.headers, this.headersKV, this.cookies, this.helper());
            }
            this.parsedHeaders = true;
        }
        return this._headers;
    }

    @Override
    public synchronized MultiData cookies_() {
        if (!this.parsedHeaders) {
            if (!this.headers.isEmpty()) {
                PARSER.parseHeadersIntoKV(this.input(), this.headers, this.headersKV, this.cookies, this.helper());
            }
            this.parsedHeaders = true;
        }
        return this._cookies;
    }

    @Override
    public synchronized MultiData data_() {
        if (!this.parsedBody) {
            PARSER.parseBody(this.input(), this.headersKV, this.body, this.data, this.files, this.helper());
            this.parsedBody = true;
        }
        return this._data;
    }

    @Override
    public synchronized BinaryMultiData files_() {
        if (!this.parsedBody) {
            PARSER.parseBody(this.input(), this.headersKV, this.body, this.data, this.files, this.helper());
            this.parsedBody = true;
        }
        return this._files;
    }

    @Override
    public synchronized Data subpath_() {
        return this._subpath;
    }

    @Override
    public synchronized Data body_() {
        return this._body;
    }

    @Override
    public synchronized Data uri_() {
        return this._uri;
    }

    @Override
    public synchronized Data verb_() {
        return this._verb;
    }

    @Override
    public synchronized Data path_() {
        return this._path;
    }

    @Override
    public synchronized Data protocol_() {
        return this._protocol;
    }

    @Override
    public synchronized Data query_() {
        return this._query;
    }

    public synchronized void setSubpath(int start, int end) {
        this.subpathRange.setInterval(start, end);
    }

    public synchronized HttpExchangeImpl done() {
        if (this.isAsync()) {
            this.completeResponse();
            this.conn.done();
        }
        return this;
    }

    public synchronized HttpExchangeBody send() {
        this.conn.send();
        return this;
    }

    public synchronized String toString() {
        return "HttpExchange [uri=" + this.uri() + ", verb=" + this.verb() + ", path=" + this.path() + ", subpath=" + this.subpath() + ", query=" + this.query() + ", protocol=" + this.protocol() + ", body=" + this.body() + ", headers=" + this.headers() + ", params=" + this.params() + ", cookies=" + this.cookies() + ", data=" + this.data() + ", files=" + this.files() + "]";
    }

    public synchronized String verb() {
        return this.verb_().get();
    }

    public synchronized String uri() {
        return this.uri_().get();
    }

    public synchronized String path() {
        return this.path_().get();
    }

    public synchronized String subpath() {
        return this.subpath_().get();
    }

    public synchronized String query() {
        return this.query_().get();
    }

    public synchronized String protocol() {
        return this.protocol_().get();
    }

    public synchronized String body() {
        return this.body_().get();
    }

    public synchronized Map<String, String> params() {
        return this.params_().get();
    }

    public synchronized String param(String name) {
        return (String)U.notNull((Object)this.params_().get(name), (String)"PARAM[%s]", (Object[])new Object[]{name});
    }

    public synchronized String param(String name, String defaultValue) {
        return (String)U.or((Object)this.params_().get(name), (Object)defaultValue);
    }

    public synchronized Map<String, String> headers() {
        return this.headers_().get();
    }

    public synchronized String header(String name) {
        return (String)U.notNull((Object)this.headers_().get(name), (String)"HEADERS[%s]", (Object[])new Object[]{name});
    }

    public synchronized String header(String name, String defaultValue) {
        return (String)U.or((Object)this.headers_().get(name), (Object)defaultValue);
    }

    public synchronized Map<String, String> cookies() {
        return this.cookies_().get();
    }

    public synchronized String cookie(String name) {
        return (String)U.notNull((Object)this.cookies_().get(name), (String)"COOKIES[%s]", (Object[])new Object[]{name});
    }

    public synchronized String cookie(String name, String defaultValue) {
        return (String)U.or((Object)this.cookies_().get(name), (Object)defaultValue);
    }

    public synchronized Map<String, String> data() {
        return this.data_().get();
    }

    public synchronized String data(String name) {
        return (String)U.notNull((Object)this.data_().get(name), (String)"DATA[%s]", (Object[])new Object[]{name});
    }

    public synchronized String data(String name, String defaultValue) {
        return (String)U.or((Object)this.data_().get(name), (Object)defaultValue);
    }

    public synchronized Map<String, byte[]> files() {
        return this.files_().get();
    }

    public synchronized byte[] file(String name) {
        return (byte[])U.notNull((Object)this.files_().get(name), (String)"FILE[%s]", (Object[])new Object[]{name});
    }

    public synchronized byte[] file(String name, byte[] defaultValue) {
        return (byte[])U.or((Object)this.files_().get(name), (Object)defaultValue);
    }

    public synchronized Map<String, String> vars() {
        if (this.vars == null) {
            this.vars = U.map();
            this.vars.putAll(this.params());
            this.vars.putAll(this.data());
        }
        return this.vars;
    }

    public synchronized String var(String name) {
        return (String)U.notNull((Object)this.vars().get(name), (String)"FILE[%s]", (Object[])new Object[]{name});
    }

    public synchronized String var(String name, String defaultValue) {
        return (String)U.or((Object)this.vars().get(name), (Object)defaultValue);
    }

    @Override
    public synchronized Data host_() {
        return this.headers_().get_("host");
    }

    public synchronized String host() {
        return this.headers_().get("host");
    }

    public synchronized HttpExchange addHeader(byte[] name, byte[] value) {
        if (this.responseCode <= 0) {
            this.responseCode(200);
        }
        super.write(name);
        super.write(HEADER_SEP);
        super.write(value);
        super.write(CR_LF);
        return this;
    }

    private HttpExchangeHeaders responseCode(int responseCode) {
        if (this.responseCode > 0) {
            assert (this.startingPos >= 0);
            this.output().deleteAfter(this.startingPos);
        }
        this.responseCode = responseCode;
        this.startingPos = this.output().size();
        this.output().append(this.getResp(responseCode).bytes());
        this.hasContentType = false;
        this.writesBody = false;
        this.bodyPos = -1;
        return this;
    }

    public synchronized void completeResponse() {
        if (this.complete) {
            return;
        }
        if (!this.lowLevelProcessing) {
            U.must((this.responseCode >= 100 ? 1 : 0) != 0);
            this.write(new byte[0]);
            U.must((this.bodyPos >= 0 ? 1 : 0) != 0);
            long responseSize = this.output().size() - this.bodyPos;
            U.must((responseSize <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Response too big!");
            int pos = this.startingPos + this.getResp((int)this.responseCode).contentLengthPos + 10;
            this.output().putNumAsText(pos, responseSize, false);
            this.closeIf(!this.isKeepAlive.value);
        }
        this.complete = true;
    }

    private HttpResponse getResp(int code) {
        HttpResponse resp = this.responses.get(code, this.isKeepAlive.value);
        assert (resp != null);
        return resp;
    }

    public synchronized HttpExchange addHeader(HttpHeader name, String value) {
        this.addHeader(name.getBytes(), value.getBytes());
        return this;
    }

    public synchronized HttpExchange setCookie(String name, String value, String ... extras) {
        String cookie = name + "=" + value;
        if (extras.length > 0) {
            cookie = cookie + "; " + U.join((String)"; ", (Object[])extras);
        }
        this.addHeader(HttpHeader.SET_COOKIE, cookie);
        return this;
    }

    public synchronized HttpExchange setContentType(MediaType MediaType2) {
        U.must((!this.hasContentType ? 1 : 0) != 0, (String)"Content type was already set!");
        this.addHeader(HttpHeader.CONTENT_TYPE.getBytes(), MediaType2.getBytes());
        this.hasContentType = true;
        return this;
    }

    public synchronized HttpExchange plain() {
        return this.setContentType(MediaType.PLAIN_TEXT_UTF_8);
    }

    public synchronized HttpExchange html() {
        return this.setContentType(MediaType.HTML_UTF_8);
    }

    public synchronized HttpExchange json() {
        return this.setContentType(MediaType.JSON_UTF_8);
    }

    public synchronized HttpExchange binary() {
        return this.setContentType(MediaType.BINARY);
    }

    public synchronized HttpExchange download(String filename) {
        this.addHeader(HttpHeader.CONTENT_DISPOSITION, "attachment; filename=\"" + filename + "\"");
        this.addHeader(HttpHeader.CACHE_CONTROL, "private");
        return this.binary();
    }

    public synchronized void ensureHeadersComplete() {
        if (!this.writesBody) {
            if (!this.hasContentType) {
                this.html();
            }
            this.writesBody = true;
            this.write(CR_LF);
            this.bodyPos = this.output().size();
        }
    }

    public synchronized HttpExchangeBody write(String s) {
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.write(s);
    }

    public synchronized HttpExchangeBody writeln(String s) {
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.writeln(s);
    }

    public synchronized HttpExchangeBody write(byte[] bytes) {
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.write(bytes);
    }

    public synchronized HttpExchangeBody write(byte[] bytes, int offset, int length) {
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.write(bytes, offset, length);
    }

    public synchronized HttpExchangeBody write(ByteBuffer buf) {
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.write(buf);
    }

    public synchronized HttpExchangeBody write(File file) {
        if (!this.hasContentType()) {
            this.download(file.getName());
        }
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.write(file);
    }

    public synchronized HttpExchangeBody writeJSON(Object value) {
        if (!this.hasContentType()) {
            this.json();
        }
        this.ensureHeadersComplete();
        return (HttpExchangeBody)super.writeJSON(value);
    }

    public synchronized boolean isInitial() {
        return this.conn.isInitial();
    }

    public synchronized ConnState state() {
        return this.conn.state();
    }

    public synchronized boolean hasContentType() {
        return this.hasContentType;
    }

    public synchronized HttpExchangeBody sendFile(File file) {
        U.must((boolean)file.exists());
        this.setContentType(MediaType.getByFileName((String)file.getAbsolutePath()));
        this.write(file);
        return this;
    }

    public synchronized HttpExchangeBody sendFile(MediaType mediaType, byte[] bytes) {
        this.setContentType(mediaType);
        this.write(bytes);
        return this;
    }

    public synchronized HttpSuccessException redirect(String url) {
        this.responseCode(303);
        this.addHeader(HttpHeader.LOCATION, url);
        this.redirectUrl = url;
        this.ensureHeadersComplete();
        throw this.error();
    }

    public synchronized String redirectUrl() {
        return this.redirectUrl;
    }

    public synchronized HttpExchangeHeaders response(int httpResponseCode) {
        return this.response(httpResponseCode, null, null);
    }

    public synchronized HttpExchangeHeaders response(int httpResponseCode, String response) {
        return this.response(httpResponseCode, response, null);
    }

    public synchronized HttpExchangeHeaders response(int httpResponseCode, String response, Throwable err) {
        this.responseCode(httpResponseCode);
        this.ensureHeadersComplete();
        if (Conf.production()) {
            if (response != null) {
                this.write(response);
            }
        } else {
            String title = (String)U.or((Object)response, (Object)"Internal server error!");
            if (err != null) {
                if (Conf.dev()) {
                    HTMLSnippets.writeErrorPage(this, title, err);
                } else {
                    HTMLSnippets.writeFullPage(this, title, "");
                }
            } else {
                HTMLSnippets.writeFullPage(this, title, "");
            }
        }
        return this;
    }

    public synchronized HttpExchangeHeaders startResponse(int httpResponseCode) {
        return this.responseCode(httpResponseCode);
    }

    public synchronized String constructUrl(String path) {
        return (Conf.is((String)"https") ? "https://" : "http://") + this.host() + path;
    }

    public synchronized String sessionId() {
        if (this.sessionId == null) {
            this.sessionId = this.cookie(SESSION_COOKIE, null);
            if (this.sessionId != null && !this.session.exists(this.sessionId)) {
                this.sessionId = null;
            }
            if (this.sessionId == null) {
                this.sessionId = Rnd.rndStr((int)50);
                this.setCookie(SESSION_COOKIE, this.sessionId, "path=/");
                this.session.openSession(this.sessionId);
            }
        }
        return this.sessionId;
    }

    public synchronized Map<String, Object> session() {
        return this.session.getSession(this.sessionId());
    }

    public Map<String, Object> getSessionById(String sessionId) {
        return this.session.getSession(sessionId);
    }

    public synchronized void sessionSet(String name, Object value) {
        if (value != null) {
            this.session.setAttribute(this.sessionId(), name, value);
        } else {
            this.session.deleteAttribute(this.sessionId(), name);
        }
    }

    public synchronized <T> T session(String name, T defaultValue) {
        return (T)U.or((Object)this.session.getAttribute(this.sessionId(), name), defaultValue);
    }

    public synchronized <T> T session(String name) {
        Object value = this.session.getAttribute(this.sessionId(), name);
        U.notNull((Object)value, (String)("session[" + name + "]"), (Object[])new Object[0]);
        return (T)value;
    }

    public synchronized <T> T sessionGetOrCreate(String name, Class<T> valueClass, Object ... constructorArgs) {
        Object value = this.session.getAttribute(this.sessionId(), name);
        if (value == null) {
            value = Cls.newInstance(valueClass, (Object[])constructorArgs);
            this.session.setAttribute(this.sessionId(), name, value);
        }
        return (T)value;
    }

    public synchronized void closeSession() {
        this.session.closeSession(this.sessionId());
        this.sessionId = null;
    }

    public synchronized void clearSession(String sessionId) {
        this.session.clearSession(sessionId);
    }

    public synchronized boolean hasSession() {
        return this.hasSession(this.cookie(SESSION_COOKIE, null));
    }

    public synchronized boolean hasSession(String sessionId) {
        return !U.isEmpty((String)sessionId) && this.session.exists(sessionId);
    }

    public synchronized HttpNotFoundException notFound() {
        this.response(404, "Error: page not found!");
        throw HttpNotFoundException.get();
    }

    public synchronized UserInfo user() {
        return this.hasSession() ? (UserInfo)this.session(UserInfo.class.getCanonicalName(), null) : null;
    }

    public synchronized boolean isGetReq() {
        return this.isGet.value;
    }

    public synchronized boolean isPostReq() {
        return !this.isGet.value && this.verb().equals("POST");
    }

    public synchronized byte[] sessionSerialize() {
        return UTILS.serialize((Object)this.session);
    }

    public synchronized void sessionDeserialize(byte[] bytes) {
        this.session = (HttpSession)UTILS.deserialize((byte[])bytes);
    }

    public synchronized OutputStream outputStream() {
        return new HttpOutputStream(this);
    }

    private synchronized boolean detectedDevMode() {
        if (Conf.production()) {
            return false;
        }
        String host = this.host();
        return host == null || host.equals("localhost") || host.equals("127.0.0.1") || host.startsWith("localhost:") || host.startsWith("127.0.0.1:");
    }

    public synchronized int responseCode() {
        return this.responseCode;
    }

    @Override
    public synchronized void run() {
        this.router.dispatch(this);
    }

    @Override
    public synchronized HttpExchange exchange() {
        return this;
    }

    @Override
    public synchronized boolean hasError() {
        return this.error != null;
    }

    @Override
    public synchronized Throwable getError() {
        return this.error;
    }

    public synchronized String pathSegment(int segmentIndex) {
        return this.path().substring(1).split("/")[segmentIndex];
    }

    public synchronized HttpExchangeHeaders accessDeniedIf(boolean accessDeniedCondition) {
        if (accessDeniedCondition) {
            throw new SecurityException("Access denied!");
        }
        return this;
    }

    public synchronized HttpExchangeHeaders errorResponse(Throwable err) {
        Throwable cause = UTILS.rootCause((Throwable)err);
        if (cause instanceof HttpSuccessException) {
            return this;
        }
        if (cause instanceof HttpNotFoundException) {
            throw this.notFound();
        }
        if (cause instanceof SecurityException) {
            return this.response(500, "Access Denied!", cause);
        }
        return this.response(500, "Internal server error!", cause);
    }

    public synchronized HttpExchangeHeaders authorize(Class<?> clazz) {
        return this.accessDeniedIf(!Secure.canAccessClass((String)Secure.username(), clazz));
    }

    public synchronized boolean serveStatic() {
        if (this.isGetReq()) {
            byte[] bytes;
            String filename = this.path().substring(1);
            if (filename.isEmpty()) {
                filename = "index.html";
            }
            if (!filename.contains("..") && STATIC_RESOURCE_PATTERN.matcher(filename).matches() && (bytes = IO.loadResource((String)("public/" + filename), (boolean)true)) != null) {
                this.startResponse(200);
                this.sendFile(MediaType.getByFileName((String)filename), bytes);
                return true;
            }
        }
        return false;
    }

    public synchronized HttpSuccessException goBack(int steps) {
        String dest = "/";
        List stack = this.session(SESSION_PAGE_STACK, null);
        if (stack != null) {
            if (!stack.isEmpty()) {
                dest = (String)stack.get(stack.size() - 1);
            }
            for (int i = 0; i < steps; ++i) {
                if (stack.isEmpty()) continue;
                stack.remove(stack.size() - 1);
                if (stack.isEmpty()) continue;
                dest = (String)stack.remove(stack.size() - 1);
            }
        }
        throw this.redirect(dest);
    }

    public synchronized HttpExchangeBody addToPageStack() {
        List stack = this.sessionGetOrCreate(SESSION_PAGE_STACK, ArrayList.class, new Object[0]);
        String last = !stack.isEmpty() ? (String)stack.get(stack.size() - 1) : null;
        String current = this.uri();
        if (!U.eq((Object)current, (Object)last)) {
            stack.add(current);
            if (stack.size() > 7) {
                stack.remove(0);
            }
        }
        return this;
    }

    public synchronized void init(HttpResponses responses, HttpSession session, Router router) {
        this.responses = responses;
        this.session = session;
        this.router = router;
        if (Conf.option((String)"mode", null) == null) {
            Conf.configure((String)"mode", (String)(this.detectedDevMode() ? "dev" : "production"));
            Log.info((String)"Auto-detected dev/production mode", (String)"mode", (Object)Conf.option((String)"mode"));
        }
    }

    public HttpSuccessException error() {
        return HttpSuccessException.get();
    }

    public synchronized <T> T extra(Object key) {
        return (T)this._extras().get(key);
    }

    public synchronized void extra(Object key, Object value) {
        this._extras().put(key, value);
    }

    private synchronized Map<Object, Object> _extras() {
        if (this.extras == null) {
            this.extras = U.map();
        }
        return this.extras;
    }

    @Override
    public synchronized void lowLevelProcessing() {
        this.lowLevelProcessing = true;
    }

    public synchronized boolean isLowLevelProcessing() {
        return this.lowLevelProcessing;
    }

    public boolean isClosing() {
        return this.conn.isClosing();
    }

    public boolean isClosed() {
        return this.conn.isClosed();
    }

    public void waitUntilClosing() {
        this.conn.waitUntilClosing();
    }

    public String realAddress() {
        return this.header("X-Forwarded-For", this.address());
    }

    public synchronized TransactionMode getTransactionMode() {
        return this.txMode;
    }

    public synchronized void setTransactionMode(TransactionMode txMode) {
        this.txMode = txMode;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public synchronized ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

