/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.io.File;
import java.nio.ByteBuffer;
import org.rapidoid.http.HTTPInterceptor;
import org.rapidoid.http.HttpExchange;
import org.rapidoid.http.HttpExchangeImpl;
import org.rapidoid.http.HttpNotFoundException;
import org.rapidoid.http.HttpParser;
import org.rapidoid.http.HttpResponses;
import org.rapidoid.http.HttpSession;
import org.rapidoid.http.HttpSuccessException;
import org.rapidoid.http.HttpUpgradeHandler;
import org.rapidoid.http.HttpUpgrades;
import org.rapidoid.http.Router;
import org.rapidoid.inject.IoC;
import org.rapidoid.log.Log;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.impl.ExchangeProtocol;
import org.rapidoid.net.impl.RapidoidConnection;
import org.rapidoid.util.AppCtx;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;
import org.rapidoid.util.Usage;
import org.rapidoid.util.UserInfo;

public class HttpProtocol
extends ExchangeProtocol<HttpExchangeImpl> {
    private final HttpParser parser = (HttpParser)IoC.singleton(HttpParser.class);
    private final Router router;
    private final HttpResponses responses;
    private final HttpUpgrades upgrades = new HttpUpgrades();
    private HttpSession session;
    private HTTPInterceptor interceptor;

    public HttpProtocol(Router router) {
        super(HttpExchangeImpl.class);
        this.router = router;
        this.responses = new HttpResponses(true, true);
    }

    protected void process(Channel ctx, HttpExchangeImpl x) {
        U.notNull((Object)this.responses, (String)"responses", (Object[])new Object[0]);
        U.notNull((Object)this.session, (String)"session", (Object[])new Object[0]);
        U.notNull((Object)this.router, (String)"router", (Object[])new Object[0]);
        if (ctx.isInitial()) {
            return;
        }
        Usage.touchLastAppUsedOn();
        this.parser.parse(x.input(), x.isGet, x.isKeepAlive, x.body, x.verb, x.uri, x.path, x.query, x.protocol, x.headers, x.helper());
        String upgrade = x.header("Upgrade", null);
        if (!U.isEmpty((String)upgrade)) {
            this.processUpgrade(ctx, x, upgrade);
            return;
        }
        U.rteIf((x.verb.isEmpty() || x.uri.isEmpty() ? 1 : 0) != 0, (String)"Invalid HTTP request!");
        U.rteIf((x.isGet.value && !x.body.isEmpty() ? 1 : 0) != 0, (String)"Body is NOT allowed in HTTP GET requests!");
        this.processRequest(x);
    }

    private void processUpgrade(Channel ctx, HttpExchangeImpl x, String upgrade) {
        Log.debug((String)"Starting HTTP protocol upgrade", (String)"upgrade", (Object)upgrade);
        HttpUpgradeHandler upgradeHandler = this.upgrades.getUpgrade(upgrade);
        Protocol upgradeTo = this.upgrades.getProtocol(upgrade);
        U.must((upgradeHandler != null && upgradeTo != null ? 1 : 0) != 0, (String)"Upgrade not supported: %s", (Object)upgrade);
        upgradeHandler.doUpgrade(x);
        RapidoidConnection conn = (RapidoidConnection)ctx;
        conn.setProtocol(upgradeTo);
        conn.setInitial(true);
        upgradeTo.process(ctx);
        conn.setInitial(false);
    }

    private void processRequest(HttpExchangeImpl x) {
        x.init(this.responses, this.session, this.router);
        AppCtx.setUser((UserInfo)x.user());
        try {
            try {
                if (this.interceptor != null) {
                    this.interceptor.intercept(x);
                } else {
                    x.run();
                }
            }
            catch (Throwable e) {
                HttpProtocol.handleError(x, e);
            }
            if (x.hasError()) {
                HttpProtocol.handleError(x, x.getError());
            } else if (!x.isAsync()) {
                x.completeResponse();
            }
        }
        finally {
            AppCtx.delUser();
            if (x.hasSession()) {
                this.session.saveSession(x.sessionId());
            }
        }
    }

    public static void handleError(HttpExchangeImpl x, Throwable e) {
        Throwable cause = UTILS.rootCause((Throwable)e);
        if (cause instanceof HttpSuccessException || cause instanceof HttpNotFoundException) {
            x.completeResponse();
        } else if (cause instanceof ThreadDeath) {
            Log.error((String)"Thread death, probably timeout!", (String)"request", (Object)x, (String)"error", (Object)cause);
            x.response(500, "Request timeout!", null);
        } else {
            Log.error((String)"Internal server error!", (String)"request", (Object)x, (String)"error", (Object)cause);
            x.errorResponse(e);
            x.completeResponse();
        }
    }

    public static void processResponse(HttpExchange xch, Object res) {
        HttpExchangeImpl x = (HttpExchangeImpl)xch;
        if (x.isLowLevelProcessing()) {
            return;
        }
        if (res != null) {
            if (res instanceof byte[]) {
                if (!x.hasContentType()) {
                    x.binary();
                }
                x.write((byte[])res);
            } else if (res instanceof String) {
                if (!x.hasContentType()) {
                    x.json();
                }
                x.write((String)res);
            } else if (res instanceof ByteBuffer) {
                if (!x.hasContentType()) {
                    x.binary();
                }
                x.write((ByteBuffer)res);
            } else if (res instanceof File) {
                File file = (File)res;
                x.sendFile(file);
            } else if (res.getClass().getSimpleName().endsWith("Page")) {
                x.html().write(res.toString());
            } else if (!(res instanceof HttpExchangeImpl)) {
                if (!x.hasContentType()) {
                    x.json();
                }
                x.writeJSON(res);
            }
        } else {
            if (!x.hasContentType()) {
                x.html();
            }
            throw x.notFound();
        }
    }

    public Router getRouter() {
        return this.router;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void setInterceptor(HTTPInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public HTTPInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void addUpgrade(String upgradeName, HttpUpgradeHandler upgrade, Protocol protocol) {
        this.upgrades.add(upgradeName, upgrade, protocol);
    }
}

