/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.util.List;
import org.rapidoid.http.HttpResponse;
import org.rapidoid.util.U;

public class HttpResponses {
    private static final String[] RESPONSE_CODES = new String[]{"100 Continue", "101 Switching Protocols", "200 OK", "201 Created", "202 Accepted", "203 Non-Authoritative Information", "204 No Content", "205 Reset Content", "206 Partial Content", "300 Multiple Choices", "301 Moved Permanently", "302 Found", "303 See Other", "304 Not Modified", "305 Use Proxy", "307 Temporary Redirect", "400 Bad Request", "401 Unauthorized", "402 Payment Required", "403 Forbidden", "404 Not Found", "405 Method Not Allowed", "406 Not Acceptable", "407 Proxy Authentication Required", "408 Request Timeout", "409 Conflict", "410 Gone", "411 Length Required", "412 Precondition Failed", "413 Request Entity Too Large", "414 Request-URI Too Long", "415 Unsupported Media Type", "416 Requested Range Not Satisfiable", "417 Expectation Failed", "500 Internal Server Error", "501 Not Implemented", "502 Bad Gateway", "503 Service Unavailable", "504 Gateway Timeout", "505 HTTP Version Not Supported"};
    private static final String[] CONNS = new String[]{"close", "keep-alive"};
    private HttpResponse[][] responses = new HttpResponse[600][];

    public HttpResponses(boolean withServerHeader, boolean withDateHeader) {
        for (String respCode : RESPONSE_CODES) {
            this.init(respCode, withServerHeader, withDateHeader);
        }
    }

    private void init(String responseCode, boolean withServerHeader, boolean withDateHeader) {
        int code = U.num((String)responseCode.split(" ")[0]);
        this.responses[code] = new HttpResponse[2];
        for (int conn = 0; conn < 2; ++conn) {
            this.responses[code][conn] = this.newResponse(responseCode, withServerHeader, withDateHeader, conn);
        }
    }

    private HttpResponse newResponse(String responseCode, boolean withServerHeader, boolean withDateHeader, int conn) {
        List lines = U.list((Object[])new String[]{"HTTP/1.1 " + responseCode});
        if (withServerHeader) {
            lines.add("Server: Rapidoid");
        }
        if (withDateHeader) {
            lines.add("Date: x                              ");
        }
        lines.add("Content-Length:          0");
        lines.add("Connection: " + CONNS[conn]);
        String cnt = U.join((String)"\r\n", (Iterable)lines) + "\r\n";
        return new HttpResponse(cnt);
    }

    public HttpResponse get(int code, boolean keepAlive) {
        if (this.responses[code] != null) {
            return this.responses[code][keepAlive ? 1 : 0];
        }
        throw U.rte((String)("Invalid HTTP response code: " + code));
    }
}

