/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import org.rapidoid.buffer.Buf;
import org.rapidoid.bytes.Bytes;
import org.rapidoid.bytes.BytesUtil;
import org.rapidoid.data.Range;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchangeImpl;
import org.rapidoid.http.HttpProtocol;
import org.rapidoid.http.Router;
import org.rapidoid.log.Log;
import org.rapidoid.util.SimpleHashTable;
import org.rapidoid.util.SimpleList;
import org.rapidoid.util.U;

public class HttpRouter
implements Router {
    private final SimpleHashTable<Route> routes = new SimpleHashTable(10000);
    private Handler genericHandler;

    @Override
    public void generic(Handler handler) {
        this.genericHandler = handler;
    }

    @Override
    public void route(String action, String url, Handler handler) {
        if (!action.matches("[A-Z_][A-Z0-9_]*")) {
            throw new IllegalArgumentException("Only uppercase letters, digits and underscore are allowed! Invalid action: " + action);
        }
        if (!url.matches("[a-zA-Z0-9_/\\.\\-\\~]*")) {
            throw new IllegalArgumentException("Invalid url: " + url);
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        Log.info((String)"Registering handler", (String)"action", (Object)action, (String)"url", (Object)url);
        this.addRoute(action, url, handler);
    }

    private void addRoute(String action, String path, Handler handler) {
        assert (action.length() >= 1);
        assert (path.length() >= 1);
        Route route = new Route();
        route.handler = handler;
        route.action = action.getBytes();
        route.path = path.getBytes();
        long hash = this.hash(action, path);
        this.routes.put(hash, (Object)route);
    }

    private long hash(String action, String path) {
        int hash = action.charAt(0) * 17 + action.length() * 19 + path.charAt(0);
        return hash;
    }

    private long hash(Buf buf, Range action, Range path) {
        int hash = buf.get(action.start) * 17 + action.length * 19 + buf.get(path.start);
        return hash;
    }

    @Override
    public void dispatch(HttpExchangeImpl x) {
        Buf buf = x.input();
        Range action = x.verb_().range();
        Range path = x.path_().range();
        if (x.isGetReq() && BytesUtil.find((Bytes)buf.bytes(), (int)(path.start + 1), (int)path.limit(), (byte)46, (boolean)true) >= 0 && x.serveStatic()) {
            return;
        }
        long hash = this.hash(buf, action, path);
        SimpleList candidates = this.routes.get(hash);
        if (candidates != null) {
            for (int i = 0; i < candidates.size(); ++i) {
                Route route = (Route)candidates.get(i);
                if (!BytesUtil.matches((Bytes)buf.bytes(), (Range)action, (byte[])route.action, (boolean)true) || !BytesUtil.startsWith((Bytes)buf.bytes(), (Range)path, (byte[])route.path, (boolean)true)) continue;
                int pos = path.start + route.path.length;
                if (path.limit() != pos && buf.get(pos) != 47) continue;
                x.setSubpath(pos, path.limit());
                this.handle(route.handler, x);
                return;
            }
        }
        if (this.genericHandler != null) {
            x.setSubpath(path.start, path.limit());
            this.handle(this.genericHandler, x);
            return;
        }
        throw x.notFound();
    }

    private void handle(Handler handler, HttpExchangeImpl x) {
        Object res;
        try {
            res = handler.handle(x);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
        HttpProtocol.processResponse(x, res);
    }

    private class Route {
        Handler handler;
        byte[] action;
        byte[] path;

        private Route() {
        }

        public String toString() {
            return new String(this.action) + ":" + new String(this.path);
        }
    }
}

