/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.ioc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.rapidoid.RapidoidThing;
import org.rapidoid.annotation.Autocreate;
import org.rapidoid.annotation.Wired;
import org.rapidoid.cls.Cls;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Deep;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.ioc.BeanProvider;
import org.rapidoid.ioc.ClassMetadata;
import org.rapidoid.ioc.IoCContext;
import org.rapidoid.ioc.IoCContextChanges;
import org.rapidoid.ioc.IoCContextWrapper;
import org.rapidoid.ioc.IoCState;
import org.rapidoid.ioc.OptionalJPAUtil;
import org.rapidoid.lambda.Lmbd;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class IoCContextImpl
extends RapidoidThing
implements IoCContext {
    private volatile String name;
    private volatile IoCState state = new IoCState();
    private volatile BeanProvider beanProvider;
    private volatile IoCContextWrapper wrapper;
    private final Map<Class<?>, ClassMetadata> metadata = Coll.autoExpandingMap((Mapper)new Mapper<Class<?>, ClassMetadata>(){

        public ClassMetadata map(Class<?> clazz) throws Exception {
            return new ClassMetadata(clazz);
        }
    });

    IoCContextImpl() {
    }

    @Override
    public IoCContext name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public synchronized void reset() {
        if (!this.state.isEmpty()) {
            Log.info((String)"Resetting IoC context", (String)"context", (Object)this);
        } else {
            Log.debug((String)"Resetting IoC context", (String)"context", (Object)this);
        }
        this.state.reset();
        this.metadata.clear();
        this.beanProvider = null;
    }

    private ClassMetadata meta(Class<?> type) {
        return this.metadata.get(type);
    }

    @Override
    public synchronized void manage(Object ... classesOrInstances) {
        List autoCreate = U.list();
        for (Object classOrInstance : classesOrInstances) {
            boolean isClass = this.isClass(classOrInstance);
            Class clazz = Cls.toClass((Object)classOrInstance);
            if (!Msc.matchingProfile((Class)clazz)) continue;
            for (Class interfacee : Cls.getImplementedInterfaces((Class)clazz)) {
                this.addProvider(interfacee, classOrInstance);
            }
            if (isClass) {
                Log.debug((String)"configuring managed class", (String)"class", (Object)classOrInstance);
                this.state.providedClasses.add(clazz);
                if (clazz.isInterface() || clazz.isEnum() || clazz.isAnnotation() || clazz.getAnnotation(Autocreate.class) == null) continue;
                autoCreate.add(clazz);
                continue;
            }
            Object instance = classOrInstance;
            Log.debug((String)"configuring provided instance", (String)"instance", (Object)instance);
            this.addProvider(clazz, instance);
            this.state.providedInstances.add(instance);
            this.state.instances.add(instance);
        }
        for (Class clazz : autoCreate) {
            this.singleton(clazz);
        }
    }

    private void addProvider(Class<?> type, Object provider) {
        this.state.providersByType.get(type).add(provider);
    }

    @Override
    public synchronized <T> T singleton(Class<T> type) {
        Log.debug((String)"Singleton", (String)"type", type);
        return this.provideIoCInstanceOf(null, type, null, null, false);
    }

    @Override
    public synchronized <T> T autowire(T target) {
        Log.debug((String)"Autowire", (String)"target", target);
        this.autowire(target, null, null, null);
        return target;
    }

    @Override
    public synchronized <T> T autowire(T target, Mapper<String, Object> session, Mapper<String, Object> bindings) {
        Log.debug((String)"Autowire", (String)"target", target);
        this.autowire(target, null, session, bindings);
        return target;
    }

    @Override
    public synchronized <T> T inject(T target) {
        Log.debug((String)"Inject", (String)"target", target);
        return this.register(target, null);
    }

    @Override
    public synchronized <T> T inject(T target, Map<String, Object> properties) {
        Log.debug((String)"Inject", (String)"target", target, (String)"properties", properties);
        return this.register(target, properties);
    }

    private <T> T provideSessionValue(Object target, Class<T> type, String name, Mapper<String, Object> session) {
        U.notNull(session, (String)"session", (Object[])new Object[0]);
        Object value = Lmbd.eval(session, (Object)name);
        return (T)(value != null ? Cls.convert((Object)value, type) : null);
    }

    private <T> T provideBindValue(Object target, Class<T> type, String name, Mapper<String, Object> bindings) {
        U.notNull(bindings, (String)"bindings", (Object[])new Object[0]);
        Object value = Lmbd.eval(bindings, (Object)name);
        return (T)(value != null ? Cls.convert((Object)value, type) : null);
    }

    private <T> T provideIoCInstanceOf(Object target, Class<T> type, String name, Map<String, Object> properties, boolean optional) {
        Object instance = this.provideSpecialInstance(type, name);
        if (instance == null && name != null) {
            instance = this.provideInstanceByName(target, type, name, properties);
        }
        if (instance == null) {
            instance = this.provideInstanceByType(type, properties);
        }
        BeanProvider provider = this.beanProvider;
        if (instance == null && provider != null) {
            instance = provider.getBean(type, name);
        }
        if (instance == null && Cls.isAppBeanType(type)) {
            instance = this.provideNewInstanceOf(type, properties);
        }
        if (!optional && instance == null) {
            if (name != null) {
                throw U.rte((String)"Didn't find a value for type '%s' and name '%s'!", (Object[])new Object[]{type, name});
            }
            throw U.rte((String)"Didn't find a value for type '%s'!", (Object[])new Object[]{type});
        }
        return (T)(Cls.isAppBean((Object)instance) ? this.register(instance, properties) : null);
    }

    private <T> T provideNewInstanceOf(Class<T> type, Map<String, Object> properties) {
        if (!type.isInterface() && !type.isEnum() && !type.isAnnotation() && Msc.matchingProfile(type)) {
            return (T)this.register(Cls.newInstance(type, properties), properties);
        }
        return null;
    }

    private <T> T provideInstanceByType(Class<T> type, Map<String, Object> properties) {
        Set<Object> providers = this.state.providersByType.get(type);
        Object provider = null;
        for (Object candidate : providers) {
            if (provider == null) {
                provider = candidate;
                continue;
            }
            if (this.isClass(provider) && !this.isClass(candidate)) {
                provider = candidate;
                continue;
            }
            if (!this.isClass(provider) && this.isClass(candidate)) continue;
            throw U.rte((String)"Found more than 1 candidates for type '%s': %s", (Object[])new Object[]{type, providers});
        }
        if (provider != null) {
            return this.provideFrom(provider, properties);
        }
        return null;
    }

    private <T> T provideFrom(Object provider, Map<String, Object> properties) {
        Object instance = this.isClass(provider) ? this.provideNewInstanceOf((Class)provider, properties) : provider;
        return (T)instance;
    }

    private boolean isClass(Object obj) {
        return obj instanceof Class;
    }

    private Object provideSpecialInstance(Class<?> type, String name) {
        String cls = type.getName();
        if (type.equals(IoCContext.class)) {
            return U.or((Object)this.wrapper, (Object)this);
        }
        if (cls.equals("javax.persistence.EntityManager") && Msc.hasRapidoidJPA()) {
            return OptionalJPAUtil.getSharedContextAwareEntityManagerProxy();
        }
        if (cls.equals("javax.persistence.EntityManagerFactory") && Msc.hasRapidoidJPA()) {
            return OptionalJPAUtil.getSharedEntityManagerFactoryProxy();
        }
        return null;
    }

    private <T> T provideInstanceByName(Object target, Class<T> type, String name, Map<String, Object> properties) {
        T instance = this.getInjectableByName(target, type, name, properties, false);
        if (target != null) {
            instance = this.getInjectableByName(target, type, name, properties, true);
        }
        if (instance == null) {
            instance = this.getInjectableByName(target, type, name, properties, true);
        }
        return instance;
    }

    private <T> T getInjectableByName(Object target, Class<T> type, String name, Map<String, Object> properties, boolean useConfig) {
        Object instance;
        Object object = instance = properties != null ? properties.get(name) : null;
        if (instance == null && target != null && useConfig) {
            Config config = Conf.section(target.getClass());
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                instance = config.is(name);
            } else {
                String opt = (String)config.entry(name).str().getOrNull();
                if (opt != null) {
                    instance = Cls.convert((String)opt, type);
                }
            }
        }
        return (T)instance;
    }

    private void autowire(Object target, Map<String, Object> properties, Mapper<String, Object> session, Mapper<String, Object> locals) {
        Log.debug((String)"Autowiring", (String)"target", (Object)target, (String)"session", session, (String)"bindings", locals);
        for (Field field : this.meta(target.getClass()).injectableFields) {
            boolean optional = this.isInjectOptional(field);
            Object value = this.provideIoCInstanceOf(target, field.getType(), field.getName(), properties, optional);
            Log.debug((String)"Injecting field value", (String)"target", (Object)target, (String)"field", (Object)field.getName(), (String)"value", value);
            if (optional && value == null) continue;
            Cls.setFieldValue((Object)target, (String)field.getName(), value);
        }
    }

    private boolean isInjectOptional(Field field) {
        Wired wired = field.getAnnotation(Wired.class);
        return wired != null && wired.optional();
    }

    private <T> void invokePostConstruct(T target) {
        List methods = Cls.getMethodsAnnotated(target.getClass(), PostConstruct.class);
        for (Method method : methods) {
            Cls.invoke((Method)method, target, (Object[])new Object[0]);
        }
    }

    private <T> T register(T target, Map<String, Object> properties) {
        U.must((boolean)Cls.isAppBean(target), (String)"Not a bean: %s", target);
        if (!this.isManaged(target)) {
            this.add(target);
            this.autowire(target, properties, null, null);
            this.invokePostConstruct(target);
        }
        return target;
    }

    private boolean isManaged(Object instance) {
        return this.state.instances.contains(instance);
    }

    private void add(Object instance) {
        Class<?> clazz = instance.getClass();
        for (Class interfacee : Cls.getImplementedInterfaces(clazz)) {
            this.addProvider(interfacee, instance);
        }
        this.addProvider(clazz, instance);
        this.state.instances.add(instance);
    }

    @Override
    public synchronized boolean remove(Object bean) {
        boolean removed;
        boolean removedProvided = this.state.providedInstances.remove(bean);
        boolean removedInstance = this.state.instances.remove(bean);
        boolean bl = removed = removedProvided || removedInstance;
        if (removed) {
            Class<?> clazz = bean.getClass();
            this.state.providedClasses.remove(clazz);
            this.metadata.remove(clazz);
            for (Map.Entry<Class<?>, Set<Object>> e : this.state.providersByType.entrySet()) {
                Iterator<Object> it = e.getValue().iterator();
                while (it.hasNext()) {
                    Object provider = it.next();
                    if (!Cls.instanceOf((Object)provider, (Class[])new Class[]{bean.getClass()})) continue;
                    it.remove();
                }
            }
        }
        return removed;
    }

    @Override
    public <K, V> Map<K, V> autoExpandingInjectingMap(final Class<V> clazz) {
        return Coll.autoExpandingMap((Mapper)new Mapper<K, V>(){

            public V map(K src) throws Exception {
                return IoCContextImpl.this.inject(Cls.newInstance((Class)clazz));
            }
        });
    }

    @Override
    public synchronized Object findInstanceOf(String className) {
        for (Object object : this.state.providedInstances) {
            if (!object.getClass().getName().equals(className)) continue;
            return object;
        }
        for (Map.Entry entry : this.state.providersByType.entrySet()) {
            for (Object provider : (Set)entry.getValue()) {
                if (!provider.getClass().getName().equals(className)) continue;
                return provider;
            }
        }
        return null;
    }

    @Override
    public synchronized IoCContextChanges reload(List<Class<?>> modified, List<String> deleted) {
        ClassLoader classLoader = !U.isEmpty(modified) ? ((Class)U.last(modified)).getClassLoader() : null;
        List loadedInstances = U.list();
        List removedInstances = U.list();
        for (String string : deleted) {
            Object bean = this.findInstanceOf(string);
            if (bean != null) {
                this.remove(bean);
                removedInstances.add(bean);
                continue;
            }
            Log.warn((String)"Couldn't find the target class to deregister!", (String)"class", (Object)string, (String)"context", (Object)this);
        }
        if (classLoader != null) {
            List toRefresh = U.list(this.state.instances);
            toRefresh.removeAll(this.state.providedInstances);
            for (Object oldBean : toRefresh) {
                Class<?> cls;
                String className = oldBean.getClass().getName();
                this.remove(oldBean);
                try {
                    cls = classLoader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    Log.error((String)"Couldn't find the class to reload!", (String)"class", (Object)className);
                    continue;
                }
                Object newBean = this.singleton(cls);
                removedInstances.add(oldBean);
                loadedInstances.add(newBean);
            }
        }
        for (Class clazz : modified) {
            Object newBean = this.singleton(clazz);
            loadedInstances.add(newBean);
        }
        return new IoCContextChanges(loadedInstances, removedInstances);
    }

    @Override
    public synchronized Map<String, Object> info() {
        return this.state.info();
    }

    public synchronized IoCState backup() {
        return this.state.copy();
    }

    public synchronized void rollback(IoCState backup) {
        this.state = backup;
    }

    @Override
    public void beanProvider(BeanProvider beanProvider) {
        this.beanProvider = beanProvider;
    }

    public String toString() {
        return Deep.copyOf(this.state.instances, (Mapper)Msc.TRANSFORM_TO_SIMPLE_CLASS_NAME).toString();
    }

    void wrapper(IoCContextWrapper wrapper) {
        this.wrapper = wrapper;
    }
}

