/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render;

import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.render.RenderCtx;
import org.rapidoid.render.TemplateRenderer;
import org.rapidoid.render.TemplateToCode;
import org.rapidoid.render.XNode;
import org.rapidoid.u.U;

public class TemplateCompiler
extends RapidoidThing {
    public static final AtomicInteger ID_GEN = new AtomicInteger();

    public static TemplateRenderer compile(XNode node) {
        try {
            String source = TemplateToCode.generate(node);
            return TemplateCompiler.tryToCompile(source);
        }
        catch (NotFoundException e) {
            throw U.rte((Throwable)e);
        }
        catch (CannotCompileException e) {
            throw U.rte((Throwable)e);
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    private static TemplateRenderer tryToCompile(String source) throws NotFoundException, CannotCompileException, InstantiationException, IllegalAccessException {
        ClassPool cp = ClassPool.getDefault();
        CtClass sup = cp.get(Object.class.getCanonicalName());
        CtClass cls = cp.makeClass("RapidoidTemplate" + ID_GEN.incrementAndGet(), sup);
        cls.addInterface(cp.get(TemplateRenderer.class.getCanonicalName()));
        cls.addConstructor(CtNewConstructor.defaultConstructor((CtClass)cls));
        CtClass[] params = new CtClass[]{cp.get(RenderCtx.class.getCanonicalName())};
        CtClass clsVoid = cp.get(Void.TYPE.getCanonicalName());
        cls.addMethod(CtNewMethod.make((int)1, (CtClass)clsVoid, (String)"render", (CtClass[])params, (CtClass[])new CtClass[0], (String)source, (CtClass)cls));
        return (TemplateRenderer)cls.toClass().newInstance();
    }
}

