/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Str;
import org.rapidoid.render.RapidoidTemplate;
import org.rapidoid.render.RenderCtx;
import org.rapidoid.render.TemplateFactory;
import org.rapidoid.render.retriever.GenericValueRetriever;
import org.rapidoid.render.retriever.ValueRetriever;
import org.rapidoid.u.U;
import org.rapidoid.util.StreamUtils;

public class RenderCtxImpl
extends RapidoidThing
implements RenderCtx {
    private final List<Object> model = U.list();
    private volatile OutputStream out;
    private volatile String ext;
    private volatile TemplateFactory factory;
    private volatile boolean busy;

    @Override
    public void printAscii(String s) throws IOException {
        StreamUtils.writeAscii((OutputStream)this.out, (String)s);
    }

    @Override
    public void printUTF8(String s) throws IOException {
        StreamUtils.writeUTF8((OutputStream)this.out, (String)s);
    }

    @Override
    public void printValue(Object value, boolean escape) throws IOException {
        if (!escape) {
            this.printUTF8(this.str(value));
            return;
        }
        if (value instanceof String) {
            String s = (String)value;
            StreamUtils.writeUTF8HtmlEscaped((OutputStream)this.out, (String)s);
            return;
        }
        if (value instanceof Number) {
            if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
                long n = ((Number)value).longValue();
                StreamUtils.putNumAsText((OutputStream)this.out, (long)n);
                return;
            }
            this.printAscii(value.toString());
            return;
        }
        if (value == null) {
            this.printAscii("null");
            return;
        }
        StreamUtils.writeUTF8HtmlEscaped((OutputStream)this.out, (String)this.str(value));
    }

    private String str(Object value) {
        if (value instanceof byte[]) {
            return Str.toWebSafeBinary((byte[])((byte[])value));
        }
        return U.str((Object)value);
    }

    @Override
    public List iter(ValueRetriever retriever) {
        Object val = retriever.retrieve(this.model);
        if (val instanceof List) {
            return (List)val;
        }
        if (val instanceof Object[]) {
            return U.list((Object[])((Object[])val));
        }
        if (val instanceof Iterable) {
            return U.list((Iterable)((Iterable)val));
        }
        return val != null && !Boolean.FALSE.equals(val) ? U.list((Object[])new Object[]{val}) : Collections.emptyList();
    }

    @Override
    public void val(ValueRetriever retriever, boolean escape) throws IOException {
        this.valOr(retriever, "N/A", escape);
    }

    @Override
    public void valOr(ValueRetriever retriever, String or, boolean escape) throws IOException {
        Object val = retriever.retrieve(this.model);
        val = U.or((Object)val, (Object)or);
        this.printValue(val, escape);
    }

    @Override
    public void push(int index, Object v) {
        if (v != null && !Boolean.TRUE.equals(v)) {
            this.model.add(v);
        }
    }

    @Override
    public void pop(int index, Object v) {
        if (v != null && !Boolean.TRUE.equals(v)) {
            Object del = this.model.remove(this.model.size() - 1);
            U.must((del == v ? 1 : 0) != 0);
        }
    }

    @Override
    public void call(String name) {
        RapidoidTemplate template = (RapidoidTemplate)this.factory.load(name + this.ext);
        template.renderInContext(this);
    }

    @Override
    public boolean cond(String name) {
        Object val = this.get(name);
        return !(val == null || Boolean.FALSE.equals(val) || "".equals(val) || Coll.isCollection((Object)val) && U.isEmpty((Collection)((Collection)val)) || Coll.isMap((Object)val) && U.isEmpty((Map)((Map)val)));
    }

    private Object get(String name) {
        return GenericValueRetriever.propOf(name, this.model);
    }

    public RenderCtxImpl out(OutputStream out) {
        this.out = out;
        return this;
    }

    public RenderCtxImpl multiModel(List<Object> model) {
        Coll.assign(this.model, model);
        return this;
    }

    public RenderCtxImpl model(Object model) {
        this.model.clear();
        this.model.add(model);
        return this;
    }

    public RenderCtxImpl factory(TemplateFactory factory) {
        this.factory = factory;
        return this;
    }

    private String calcFileExt(String filename) {
        if (U.notEmpty((String)filename)) {
            String fileExt = Str.cutFromFirst((String)filename, (String)".");
            return fileExt != null ? "." + fileExt : "";
        }
        return "";
    }

    public RenderCtxImpl filename(String filename) {
        this.ext = this.calcFileExt(filename);
        return this;
    }

    public void reset() {
        this.model.clear();
        this.busy = false;
    }

    public boolean busy() {
        return this.busy;
    }

    public void claim() {
        this.busy = true;
    }
}

