/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jdbc;

import java.sql.Connection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.config.ConfigUtil;
import org.rapidoid.jdbc.JdbcClient;
import org.rapidoid.jdbc.JdbcWorker;
import org.rapidoid.lambda.Operation;
import org.rapidoid.log.Log;

public class JdbcWorkers
extends RapidoidThing {
    private static final int DEFAULT_CAPACITY = 1000000;
    private final BlockingQueue<Operation<Connection>> queue;
    private final JdbcWorker[] workers;

    public JdbcWorkers(JdbcClient jdbc) {
        this(jdbc, new ArrayBlockingQueue<Operation<Connection>>(1000000));
    }

    public JdbcWorkers(JdbcClient jdbc, BlockingQueue<Operation<Connection>> queue) {
        this.queue = queue;
        int workersN = (Integer)Conf.JDBC.entry("workers").or((Object)ConfigUtil.cpus());
        long batchTimeMs = ((Integer)Conf.JDBC.entry("batchTimeMs").or((Object)5000)).intValue();
        this.workers = new JdbcWorker[workersN];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new JdbcWorker(jdbc, queue, batchTimeMs);
            this.workers[i].start();
        }
        Log.info((String)"Started JDBC workers", (String)"workers", (Object)workersN, (String)"batchTimeMs", (Object)batchTimeMs);
    }

    public void execute(Operation<Connection> operation) {
        try {
            this.queue.put(operation);
        }
        catch (InterruptedException e) {
            throw new CancellationException();
        }
    }
}

