package org.rapidoidx.demo.http;

/*
 * #%L
 * rapidoid-x-demo
 * %%
 * Copyright (C) 2014 - 2015 Nikolche Mihajlovski
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.util.concurrent.atomic.AtomicLong;

import org.rapidoid.annotation.Authors;
import org.rapidoid.annotation.Since;
import org.rapidoid.config.Conf;
import org.rapidoid.http.HTTP;
import org.rapidoid.http.HTTPServer;
import org.rapidoid.http.Handler;
import org.rapidoid.http.HttpExchange;

@Authors("Nikolche Mihajlovski")
@Since("3.0.0")
public class HttpDemo {

	public static void main(String[] args) {
		Conf.args(args);

		final AtomicLong n = new AtomicLong();

		HTTPServer server = HTTP.server().build();

		server.get("/hi", new Handler() {
			@Override
			public Object handle(HttpExchange x) {
				return "[" + n.incrementAndGet() + "] Hi: " + x.uri();
			}
		});

		server.start();
	}

}
