/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoidx.http.client;

import java.util.Map;
import org.rapidoid.util.U;
import org.rapidoid.util.UTILS;
import org.rapidoidx.buffer.Buf;
import org.rapidoidx.data.Range;
import org.rapidoidx.data.Ranges;
import org.rapidoidx.http.client.HttpClientCallback;
import org.rapidoidx.net.abstracts.Channel;
import org.rapidoidx.net.impl.FiniteStateProtocol;

public class HttpClientProtocol
extends FiniteStateProtocol {
    private final String request;
    private final HttpClientCallback callback;

    public HttpClientProtocol(String request, HttpClientCallback callback) {
        super(2);
        this.request = request;
        this.callback = callback;
    }

    protected int state0(Channel ctx) {
        ctx.log("sending request");
        ctx.write(this.request.getBytes());
        return 1;
    }

    protected int state1(Channel ctx) {
        ctx.log("receiving response");
        Ranges head = ctx.helper().ranges1.reset();
        Ranges body = ctx.helper().ranges2.reset();
        Buf in = ctx.input();
        in.scanLnLn(head);
        Map headers = head.toMap(in.bytes(), 1, head.count - 1, "\\s*\\:\\s*");
        Map headersLow = UTILS.lowercase((Map)headers);
        if ("chunked".equals(headersLow.get("transfer-encoding"))) {
            ctx.log("got chunked encoding");
            this.parseChunkedBody(in, body);
            this.callback.onResult(in, head, body);
        } else if (headersLow.containsKey("content-length")) {
            ctx.log("got content length");
            int clength = Integer.parseInt((String)headersLow.get("content-length"));
            this.parseBodyByContentLength(in, body, clength);
            this.callback.onResult(in, head, body);
        } else {
            ctx.log("read until closed");
            this.readBodyUntilClosed(ctx, body);
            this.callback.onResult(in, head, body);
        }
        ctx.log("done");
        ctx.close();
        return -1;
    }

    private void parseChunkedBody(Buf in, Ranges chunks) {
        int count;
        do {
            String cnt;
            if ((count = Integer.parseInt(cnt = in.readLn(), 16)) <= 0) continue;
            Range chunk = chunks.ranges[chunks.add()];
            in.scanN(count, chunk);
            String line = in.readLn();
            U.must((boolean)line.isEmpty());
        } while (count > 0);
    }

    private void parseBodyByContentLength(Buf in, Ranges body, int clength) {
        body.add();
        in.scanN(clength, body.ranges[0]);
    }

    private void readBodyUntilClosed(Channel ctx, Ranges body) {
        ctx.waitUntilClosing();
        body.add();
        Buf in = ctx.input();
        in.scanN(in.remaining(), body.ranges[0]);
    }
}

