/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardViewer;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.SpriteFactory;
import org.refcodes.checkerboard.ViewportOffsetChangedEventImpl;
import org.refcodes.component.InitializeException;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.GridMode;
import org.refcodes.graphical.Offset;
import org.refcodes.graphical.Position;
import org.refcodes.graphical.ViewportDimension;
import org.refcodes.graphical.ViewportDimensionImpl;
import org.refcodes.graphical.ViewportOffset;
import org.refcodes.observer.SubscribeEvent;
import org.refcodes.observer.UnsubscribeEvent;

public abstract class AbstractCheckerboardViewer<P extends Player<P, S>, S, IMG, SF extends SpriteFactory<IMG, S, ?>, CBV extends CheckerboardViewer<P, S, CBV>>
implements CheckerboardViewer<P, S, CBV> {
    private int _viewportWidth = -1;
    private int _viewportHeight = -1;
    private int _viewportOffsetX = 0;
    private int _viewportOffsetY = 0;
    private ViewportDimension.ViewportDimensionPropertyBuilderBuilder _minViewportDimension = new ViewportDimensionImpl.ViewportDimensionPropertyBuilderImpl(-1, -1);
    private Checkerboard<P, S> _checkerboard;

    @Override
    public CBV withInitialize() throws InitializeException {
        this.initialize();
        return (CBV)this;
    }

    @Override
    public CBV withViewportOffsetY(int aPosY) {
        this.setViewportOffsetY(aPosY);
        return (CBV)this;
    }

    @Override
    public CBV withViewportHeight(int aGridHeight) {
        this.setViewportHeight(aGridHeight);
        return (CBV)this;
    }

    @Override
    public CBV withViewportWidth(int aGridWidth) {
        this.setViewportWidth(aGridWidth);
        return (CBV)this;
    }

    @Override
    public CBV withViewportDimension(int aWidth, int aHeight) {
        this.setViewportDimension(aWidth, aHeight);
        return (CBV)this;
    }

    @Override
    public CBV withViewportDimension(ViewportDimension aGridDimension) {
        this.setViewportDimension(aGridDimension);
        return (CBV)this;
    }

    @Override
    public CBV withViewportDimension(Dimension aDimension) {
        this.setViewportDimension(aDimension);
        return (CBV)this;
    }

    @Override
    public CBV withViewportOffset(int aPosX, int aPosY) {
        this.setViewportOffset(aPosX, aPosY);
        return (CBV)this;
    }

    @Override
    public CBV withViewportOffset(Position aOffset) {
        this.setViewportOffset(aOffset);
        return (CBV)this;
    }

    @Override
    public CBV withViewportOffset(ViewportOffset aOffset) {
        this.setViewportOffset(aOffset);
        return (CBV)this;
    }

    @Override
    public CBV withViewportOffset(Offset aOffset) {
        this.setViewportOffset(aOffset);
        return (CBV)this;
    }

    @Override
    public CBV withViewportOffsetX(int aPosX) {
        this.setViewportOffsetX(aPosX);
        return (CBV)this;
    }

    @Override
    public CBV withMinViewportDimension(ViewportDimension aDimension) {
        this.setMinViewportDimension(aDimension);
        return (CBV)this;
    }

    @Override
    public CBV withMinViewportDimension(int aWidth, int aHeight) {
        this.setMinViewportDimension(aWidth, aHeight);
        return (CBV)this;
    }

    @Override
    public void setViewportDimension(int aWidth, int aHeight) {
        if (this._minViewportDimension.getViewportWidth() != -1 && aWidth < this._minViewportDimension.getViewportWidth()) {
            throw new IllegalArgumentException("The provided grid width <" + aWidth + "> is less than the min grid width (<" + this._minViewportDimension.getViewportWidth() + ">).");
        }
        if (this._minViewportDimension.getViewportHeight() != -1 && aHeight < this._minViewportDimension.getViewportHeight()) {
            throw new IllegalArgumentException("The provided grid height <" + aHeight + "> is less than the min grid height (<" + this._minViewportDimension.getViewportHeight() + ">).");
        }
        this._viewportWidth = aWidth;
        this._viewportHeight = aHeight;
    }

    @Override
    public void setViewportDimension(ViewportDimension aGridDimension) {
        this.setViewportDimension(aGridDimension.getViewportWidth(), aGridDimension.getViewportHeight());
    }

    @Override
    public void setViewportDimension(Dimension aDimension) {
        this.setViewportDimension(aDimension.getWidth(), aDimension.getHeight());
    }

    @Override
    public void setViewportWidth(int aGridWidth) {
        this.setViewportDimension(aGridWidth, this._viewportHeight);
    }

    @Override
    public void setViewportHeight(int aGridHeight) {
        this.setViewportDimension(this._viewportWidth, aGridHeight);
    }

    @Override
    public int getViewportWidth() {
        return this._viewportWidth;
    }

    @Override
    public int getViewportHeight() {
        return this._viewportHeight;
    }

    @Override
    public void setViewportOffset(int aPosX, int aPosY) {
        if (aPosX != this._viewportOffsetX || aPosY != this._viewportOffsetY) {
            ViewportOffsetChangedEventImpl theEvent = new ViewportOffsetChangedEventImpl(aPosX, aPosY, this._viewportOffsetX, this._viewportOffsetY, this);
            this._viewportOffsetX = aPosX;
            this._viewportOffsetY = aPosY;
            this.onViewportOffsetChangedEvent(theEvent);
        }
    }

    @Override
    public void setViewportOffset(Position aOffset) {
        this.setViewportOffset(aOffset.getPositionX(), aOffset.getPositionY());
    }

    @Override
    public void setViewportOffset(ViewportOffset aOffset) {
        this.setViewportOffset(aOffset.getViewportOffsetX(), aOffset.getViewportOffsetY());
    }

    @Override
    public void setViewportOffset(Offset aOffset) {
        this.setViewportOffset(aOffset.getOffsetX(), aOffset.getOffsetY());
    }

    @Override
    public void setViewportOffsetX(int aPosX) {
        this.setViewportOffset(aPosX, this._viewportOffsetY);
    }

    @Override
    public int getViewportOffsetX() {
        return this._viewportOffsetX;
    }

    @Override
    public int getViewportOffsetY() {
        return this._viewportOffsetY;
    }

    @Override
    public void setViewportOffsetY(int aPosY) {
        this.setViewportOffset(this._viewportOffsetX, aPosY);
    }

    @Override
    public void setMinViewportDimension(ViewportDimension aDimension) {
        this._minViewportDimension.setViewportDimension(aDimension);
    }

    @Override
    public ViewportDimension getMinViewportDimension() {
        return this._minViewportDimension;
    }

    @Override
    public void setMinViewportDimension(int aWidth, int aHeight) {
        this._minViewportDimension.setViewportDimension(aWidth, aHeight);
    }

    @Override
    public GridMode getGridMode() {
        return this.getCheckerboard().getGridMode();
    }

    @Override
    public int getGridWidth() {
        return this.getCheckerboard().getGridWidth();
    }

    @Override
    public int getGridHeight() {
        return this.getCheckerboard().getGridHeight();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void onSubscribe(SubscribeEvent<Checkerboard<P, S>> aSubscribeEvent) {
        this._checkerboard = (Checkerboard)aSubscribeEvent.getSource();
    }

    @Override
    public void onUnsubscribe(UnsubscribeEvent<Checkerboard<P, S>> aUnsubscribeEvent) {
    }

    protected Checkerboard<P, S> getCheckerboard() {
        if (this._checkerboard == null) {
            throw new IllegalStateException("Register your checkerboard viewer to a checkerboard via \"Checkerboard#subscribeObserver( yourCheckerboardViewer)\". The viewer's \"#onSubscribe( ... )} method will be invoked, retrieving (from the event) and setting the checkerboard object to be returnd by this \"getCheckerboard()\" method.");
        }
        return this._checkerboard;
    }
}

