/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.Configurable;
import org.refcodes.component.ConfigurableLifeCycleComponent;
import org.refcodes.component.ConfigureException;
import org.refcodes.component.LifeCycleStatus;
import org.refcodes.component.PauseException;
import org.refcodes.component.ResumeException;
import org.refcodes.component.StartException;
import org.refcodes.component.StopException;

public class ConfigurableLifeCycleAutomatonImpl<CTX>
implements ConfigurableLifeCycleComponent.ConfigurableLifeCycleAutomaton<CTX> {
    private LifeCycleStatus _lifeCycleStatus = LifeCycleStatus.NONE;
    private ConfigurableLifeCycleComponent<CTX> _configurableLifeCycleComponent = null;

    public ConfigurableLifeCycleAutomatonImpl() {
    }

    public ConfigurableLifeCycleAutomatonImpl(ConfigurableLifeCycleComponent<CTX> aLifeConfigurableCycleComponent) {
        this._configurableLifeCycleComponent = aLifeConfigurableCycleComponent;
    }

    @Override
    public synchronized LifeCycleStatus getLifeCycleStatus() {
        return this._lifeCycleStatus;
    }

    @Override
    public synchronized void initialize(CTX aContext) throws ConfigureException {
        if (!this.isInitalizable(aContext)) {
            throw new ConfigureException(aContext, "Cannot initialize (configure) as the component is in status <" + (Object)((Object)this._lifeCycleStatus) + "> which is not the appropriate status for initializing (configuring).");
        }
        if (this._configurableLifeCycleComponent != null) {
            this._configurableLifeCycleComponent.initialize(aContext);
        }
        this._lifeCycleStatus = LifeCycleStatus.INITIALIZED;
    }

    @Override
    public synchronized boolean isInitalizable(CTX aContext) {
        boolean isConfigurable;
        boolean bl = isConfigurable = this._lifeCycleStatus == LifeCycleStatus.NONE || this.isDestroyed();
        if (isConfigurable && this._configurableLifeCycleComponent != null && this._configurableLifeCycleComponent instanceof Configurable.ConfigureAutomaton) {
            Configurable.ConfigureAutomaton theConfigureAutomaton = (Configurable.ConfigureAutomaton)((Object)this._configurableLifeCycleComponent);
            return theConfigureAutomaton.isInitalizable(aContext);
        }
        return isConfigurable;
    }

    @Override
    public synchronized boolean isInitialized() {
        return this._lifeCycleStatus == LifeCycleStatus.INITIALIZED;
    }

    @Override
    public synchronized boolean isStartable() {
        return this.isInitialized() || this.isStopped();
    }

    @Override
    public synchronized void start() throws StartException {
        if (!this.isStartable()) {
            throw new StartException("Cannot start as the component is in status <" + (Object)((Object)this._lifeCycleStatus) + "> which is not the appropriate status for starting.");
        }
        if (this._configurableLifeCycleComponent != null) {
            this._configurableLifeCycleComponent.start();
        }
        this._lifeCycleStatus = LifeCycleStatus.STARTED;
    }

    @Override
    public synchronized boolean isRunning() {
        return this._lifeCycleStatus == LifeCycleStatus.STARTED;
    }

    @Override
    public synchronized boolean isPausable() {
        return this.isRunning();
    }

    @Override
    public synchronized void pause() throws PauseException {
        if (!this.isPausable()) {
            throw new PauseException("Cannot pause as the component is in status <" + (Object)((Object)this._lifeCycleStatus) + "> which is not the appropriate status for pausing.");
        }
        if (this._configurableLifeCycleComponent != null) {
            this._configurableLifeCycleComponent.pause();
        }
        this._lifeCycleStatus = LifeCycleStatus.PAUSED;
    }

    @Override
    public synchronized boolean isPaused() {
        return this._lifeCycleStatus == LifeCycleStatus.PAUSED;
    }

    @Override
    public synchronized boolean isResumable() {
        return this.isPaused();
    }

    @Override
    public synchronized void resume() throws ResumeException {
        if (!this.isResumable()) {
            throw new ResumeException("Cannot resume as the component is in status <" + (Object)((Object)this._lifeCycleStatus) + "> which is not the appropriate status for resuming.");
        }
        if (this._configurableLifeCycleComponent != null) {
            this._configurableLifeCycleComponent.resume();
        }
        this._lifeCycleStatus = LifeCycleStatus.STARTED;
    }

    @Override
    public synchronized boolean isStoppable() {
        return this.isRunning() || this.isPaused();
    }

    @Override
    public synchronized void stop() throws StopException {
        if (!this.isStoppable()) {
            throw new StopException("Cannot stop as the component is in status <" + (Object)((Object)this._lifeCycleStatus) + "> which is not the appropriate status for stopping.");
        }
        if (this._configurableLifeCycleComponent != null) {
            this._configurableLifeCycleComponent.stop();
        }
        this._lifeCycleStatus = LifeCycleStatus.STOPPED;
    }

    @Override
    public synchronized boolean isStopped() {
        return this._lifeCycleStatus == LifeCycleStatus.STOPPED;
    }

    @Override
    public synchronized boolean isDestroyable() {
        return this.isStopped();
    }

    @Override
    public synchronized void destroy() {
        if (!this.isDestroyable()) {
            return;
        }
        if (this._configurableLifeCycleComponent != null) {
            this._configurableLifeCycleComponent.destroy();
        }
        this._lifeCycleStatus = LifeCycleStatus.DESTROYED;
    }

    @Override
    public synchronized boolean isDestroyed() {
        return this._lifeCycleStatus == LifeCycleStatus.DESTROYED;
    }

    protected ConfigurableLifeCycleComponent<CTX> getLifeCycleComponent() {
        return this._configurableLifeCycleComponent;
    }
}

