/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.OpenException;
import org.refcodes.component.OpenedAccessor;
import org.refcodes.exception.HiddenException;

public interface ConnectionOpenable<CON> {
    public void open(CON var1) throws OpenException;

    default public void openUnchecked(CON aConnection) {
        try {
            this.open(aConnection);
        }
        catch (OpenException e) {
            throw new HiddenException(e);
        }
    }

    public static interface ConnectionOpenAutomaton<CON>
    extends ConnectionOpenable<CON>,
    OpenedAccessor {
        public boolean isOpenable(CON var1);
    }

    public static interface ConnectionOpenBuilder<CON, B extends ConnectionOpenBuilder<CON, B>> {
        public B withOpen(CON var1) throws OpenException;

        default public B withOpenUnchecked(CON aConnection) {
            try {
                return this.withOpen(aConnection);
            }
            catch (OpenException e) {
                throw new HiddenException(e);
            }
        }
    }
}

