/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.OpenException;
import org.refcodes.component.OpenedAccessor;
import org.refcodes.exception.HiddenException;

public interface Openable {
    public void open() throws OpenException;

    default public void openUnchecked() {
        try {
            this.open();
        }
        catch (OpenException e) {
            throw new HiddenException(e);
        }
    }

    public static interface OpenAutomaton
    extends Openable,
    OpenedAccessor {
        public boolean isOpenable();
    }

    public static interface OpenBuilder<B extends OpenBuilder<B>> {
        public B withOpen() throws OpenException;

        default public B withOpenUnchecked() {
            try {
                return this.withOpen();
            }
            catch (OpenException e) {
                throw new HiddenException(e);
            }
        }
    }
}

