/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.PauseException;
import org.refcodes.exception.HiddenException;

public interface Pausable {
    public void pause() throws PauseException;

    default public void pauseUnchecked() {
        try {
            this.pause();
        }
        catch (PauseException e) {
            throw new HiddenException(e);
        }
    }

    public static interface UncheckedPausable
    extends Pausable {
        @Override
        public void pause();
    }

    public static interface PauseBuilder<B extends PauseBuilder<B>> {
        public B withPause() throws PauseException;

        default public B pauseUnchecked() {
            try {
                return this.withPause();
            }
            catch (PauseException e) {
                throw new HiddenException(e);
            }
        }
    }

    public static interface PauseAutomaton
    extends Pausable {
        public boolean isPausable();

        public boolean isPaused();
    }
}

