/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import org.refcodes.graphical.GraphicalUtility;
import org.refcodes.graphical.RgbPixel;

public class RgbPixelImpl
implements RgbPixel {
    private int _alphaPortion = 0;
    private int _redPortion = 0;
    private int _greenPortion = 0;
    private int _bluePortion = 0;

    public RgbPixelImpl() {
    }

    public RgbPixelImpl(int aAlphaPortion, int aRedPortion, int aGreenPortion, int aBluePortion) {
        this._alphaPortion = aAlphaPortion;
        this._redPortion = aRedPortion;
        this._greenPortion = aGreenPortion;
        this._bluePortion = aBluePortion;
    }

    public RgbPixelImpl(int aRgbValue) {
        this.setRgbValue(aRgbValue);
    }

    @Override
    public int getAlphaPortion() {
        return this._alphaPortion;
    }

    @Override
    public int getRedPortion() {
        return this._redPortion;
    }

    @Override
    public int getGreenPortion() {
        return this._greenPortion;
    }

    @Override
    public int getBluePortion() {
        return this._bluePortion;
    }

    @Override
    public int toRgbValue() {
        return GraphicalUtility.toRgb(this._alphaPortion, this._redPortion, this._greenPortion, this._bluePortion);
    }

    @Override
    public void setRgbValue(int aRgbValue) {
        this._alphaPortion = GraphicalUtility.toAlpha(aRgbValue);
        this._redPortion = GraphicalUtility.toRed(aRgbValue);
        this._greenPortion = GraphicalUtility.toGreen(aRgbValue);
        this._bluePortion = GraphicalUtility.toBlue(aRgbValue);
    }

    @Override
    public void setAlphaPortion(int aAlphaPortion) {
        this._alphaPortion = aAlphaPortion;
    }

    @Override
    public void setRedPortion(int aRedPortion) {
        this._redPortion = aRedPortion;
    }

    @Override
    public void setGreenPortion(int aGreenPortion) {
        this._greenPortion = aGreenPortion;
    }

    @Override
    public void setBluePortion(int aBluePortion) {
        this._bluePortion = aBluePortion;
    }
}

