/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.text.ParseException;
import org.refcodes.tabular.AbstractColumn;

public class MethodNameColumnImpl
extends AbstractColumn<String>
implements Cloneable {
    private static final String METHOD_SUFFIX = "()";

    public MethodNameColumnImpl(String aKey) {
        super(aKey, String.class);
    }

    @Override
    public synchronized String[] toStorageStrings(String aValue) {
        if (!aValue.endsWith(METHOD_SUFFIX)) {
            return new String[]{aValue + METHOD_SUFFIX};
        }
        return new String[]{aValue};
    }

    @Override
    public synchronized String fromStorageStrings(String[] aStringValues) throws ParseException {
        if (aStringValues == null || aStringValues.length == 0) {
            return null;
        }
        if (aStringValues.length == 1) {
            String theStringValue = aStringValues[0];
            if (!theStringValue.endsWith(METHOD_SUFFIX)) {
                return theStringValue;
            }
            return theStringValue.substring(0, theStringValue.length() - METHOD_SUFFIX.length());
        }
        throw new IllegalArgumentException("The type <" + this.getType().getName() + "> is not an array type though the number of elements in the provided string array is <" + aStringValues.length + "> whereas only one element is being expected.");
    }

    @Override
    public String toPrintable(String aValue) {
        return super.toPrintable(aValue) + METHOD_SUFFIX;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

