/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.console;

import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.EnvironmentProperty;
import org.refcodes.data.Field;
import org.refcodes.data.SystemProperty;
import org.refcodes.logger.ColumnLayout;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.LoggerField;
import org.refcodes.logger.UnexpectedLogRuntimeException;
import org.refcodes.logger.alt.console.ConsoleLogger;
import org.refcodes.logger.alt.console.ConsoleLoggerHeaderImpl;
import org.refcodes.logger.alt.console.FormattedLoggerImpl;
import org.refcodes.runtime.OperatingSystem;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.FormattedColumn;
import org.refcodes.tabular.FormattedHeader;
import org.refcodes.tabular.Record;
import org.refcodes.textual.MoreTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableBuilderImpl;
import org.refcodes.textual.TableStyle;

public class ConsoleLoggerImpl
extends FormattedLoggerImpl<Object>
implements ConsoleLogger {
    private LogPriority _lastPriority;
    private int _exceptionIndex;
    private FormattedColumn<Exception> _errorColumn;
    protected TableBuilder _errorBuilder;
    protected TableBuilder _standardBuilder;
    protected FormattedHeader<Object> _standardHeader;
    private TableLayout _lastLayout = TableLayout.NONE;
    private ColumnLayout _columnLayout;
    private boolean _isPrintSeparator = false;

    public ConsoleLoggerImpl() {
        this(ConsoleLoggerImpl.toLoggerLayout(null));
    }

    public ConsoleLoggerImpl(ColumnLayout aLoggerLayout) {
        super(new ConsoleLoggerHeaderImpl(ConsoleLoggerImpl.toLoggerLayout(aLoggerLayout)));
        this.init(ConsoleLoggerImpl.toLoggerLayout(aLoggerLayout));
    }

    @Override
    public ColumnLayout getColumnLayout() {
        return this._columnLayout;
    }

    @Override
    public void setColumnLayout(ColumnLayout aColumnLayout) {
        ColumnLayout theColumnLayout;
        if (ConsoleLoggerImpl.toLoggerLayout() == null && (theColumnLayout = ConsoleLoggerImpl.toLoggerLayout(aColumnLayout)) != this._columnLayout) {
            this._columnLayout = theColumnLayout;
            this._errorColumn = null;
            this._header = new ConsoleLoggerHeaderImpl(this._columnLayout);
            this.init();
        }
    }

    @Override
    public synchronized void log(Record<? extends Object> aRecord) throws IllegalRecordRuntimeException, UnexpectedLogRuntimeException {
        try {
            LogPriority thePriority = (LogPriority)((Object)LoggerField.LOG_PRIORITY.getColumn().get(aRecord));
            Exception theException = null;
            if (aRecord.size() > this._exceptionIndex) {
                theException = (Exception)aRecord.get(Field.LOG_EXCEPTION.getName());
            }
            if (thePriority == null || thePriority.getPriority() > LogPriority.DISCARD.getPriority()) {
                if (this._lastPriority != thePriority || this._columnLayout == ColumnLayout.ANALYST || thePriority.getPriority() >= LogPriority.WARN.getPriority() || this._isPrintSeparator) {
                    this._isPrintSeparator = false;
                    if (this._lastLayout == TableLayout.EXCEPTION) {
                        if (theException != null) {
                            this._standardBuilder.printRowEnd(this._errorBuilder);
                        } else if (thePriority.getPriority() >= LogPriority.WARN.getPriority()) {
                            this._standardBuilder.printRowEnd(this._errorBuilder);
                        } else {
                            this._tableBuilder.printRowEnd(this._errorBuilder);
                        }
                    } else if (this._lastLayout != TableLayout.NONE) {
                        this._tableBuilder.printRowBegin();
                    }
                }
                if (thePriority.getPriority() >= LogPriority.WARN.getPriority()) {
                    this.log(aRecord, this._standardHeader, this._standardBuilder);
                } else {
                    super.log(aRecord);
                }
                if (theException != null) {
                    this.printException(theException);
                    this._lastLayout = TableLayout.EXCEPTION;
                } else {
                    this._lastLayout = TableLayout.MESSAGE;
                }
            } else if (theException != null) {
                System.err.println(theException.getMessage());
                theException.printStackTrace();
            }
            this._lastPriority = thePriority;
        }
        catch (ClassCastException | ColumnMismatchException e) {
            throw new IllegalRecordRuntimeException(aRecord, (Throwable)e);
        }
    }

    protected void printException(Exception theException) {
        String theText = this._errorColumn.toPrintable(theException);
        theText = theText.replaceAll("\t", "--> ");
        this._errorBuilder.printRowEnd(this._standardBuilder);
        this._errorBuilder.printRowContinue(theText);
        this._errorBuilder.withPrintStream(this._errStream);
    }

    @Override
    public void printSeparator() {
        this._isPrintSeparator = true;
    }

    protected static ColumnLayout toLoggerLayout(ColumnLayout aLoggerLayout) {
        if (aLoggerLayout != null && (aLoggerLayout != ColumnLayout.SUPERUSER || SystemUtility.toConsoleWidth() >= ConsoleDimension.NORM_WIDTH.getValue())) {
            return aLoggerLayout;
        }
        ColumnLayout theLoggerLayout = ConsoleLoggerImpl.toLoggerLayout();
        if (theLoggerLayout == null) {
            theLoggerLayout = ColumnLayout.SUPERUSER;
        }
        if (theLoggerLayout == ColumnLayout.SUPERUSER && SystemUtility.toConsoleWidth() < ConsoleDimension.NORM_WIDTH.getValue()) {
            return ColumnLayout.GRANDPA;
        }
        return theLoggerLayout;
    }

    protected static ColumnLayout toLoggerLayout() {
        ColumnLayout theLoggerLayout = null;
        String theResult = SystemUtility.toPropertyValue(SystemProperty.LOGGER_LAYOUT, EnvironmentProperty.LOGGER_LAYOUT);
        if (theResult != null) {
            try {
                theLoggerLayout = ColumnLayout.toColumnLayout(theResult);
                if (theLoggerLayout == null) {
                    theLoggerLayout = ColumnLayout.SUPERUSER;
                }
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return theLoggerLayout;
    }

    protected static TableStyle toLoggerStyle() {
        String theResult = SystemUtility.toPropertyValue(SystemProperty.LOGGER_STYLE, EnvironmentProperty.LOGGER_STYLE);
        if (theResult != null) {
            try {
                TableStyle theTableStyle = TableStyle.toTableStyle(theResult);
                if (theTableStyle != null) {
                    return theTableStyle;
                }
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS ? TableStyle.ASCII : TableStyle.SINGLE;
    }

    @Override
    protected void init() {
        this._tableStyle = ConsoleLoggerImpl.toLoggerStyle();
        if (this._errorColumn == null) {
            this._exceptionIndex = this._header.indexOf(Field.LOG_EXCEPTION.getName());
            this._errorColumn = (FormattedColumn)this._header.delete(Field.LOG_EXCEPTION.getName());
        }
        this._errorBuilder = new TableBuilderImpl(this._rowWidth).addColumn().withColumnFormatMetrics(this._errorColumn).withPrintStream(this._errStream).withTableStyle(this._tableStyle).withLeftBorder(this._hasLeftBorder).withRightBorder(this._hasRightBorder);
        this._errorBuilder.withLineBreak(SystemUtility.toLineBreak(this._rowWidth));
        if (this._columnLayout != null) {
            this.init(this._columnLayout);
        }
        super.init();
    }

    private void init(ColumnLayout aColumnLayout) {
        this._columnLayout = aColumnLayout;
        this._standardHeader = this.toVerboseHeader();
        this._standardBuilder = this.toPreConfiguredTableBuilder(this._standardHeader, FormattedLoggerImpl.OutputPrintStream.ERROR);
    }

    private FormattedHeader<Object> toVerboseHeader() {
        ConsoleLoggerHeaderImpl theVerboseHeader = new ConsoleLoggerHeaderImpl(this._columnLayout);
        FormattedColumn theMessageColumn = (FormattedColumn)this._header.get(Field.LOG_MESSAGE.getName());
        theMessageColumn.setMoreTextMode(MoreTextMode.NONE);
        theVerboseHeader.delete(Field.LOG_EXCEPTION.getName());
        return theVerboseHeader;
    }

    private static enum TableLayout {
        NONE,
        MESSAGE,
        EXCEPTION;

    }
}

