/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.refcodes.data.Encoding;
import org.refcodes.data.Literals;
import org.refcodes.exception.HiddenException;

public final class NumericalUtility {
    private static final int BYTE_MASK = 255;
    private static final int BYTES_PER_INT = 4;
    private static final int BYTES_PER_LONG = 8;
    private static final long BITS_PER_BYTE = 8L;

    private NumericalUtility() {
    }

    public static byte[] toBytes(long aLong) {
        byte[] theBytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            theBytes[7 - i] = (byte)(aLong >>> (int)((long)i * 8L));
        }
        return theBytes;
    }

    public static byte[] toBytes(int aInteger) {
        byte[] theBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            theBytes[3 - i] = (byte)(aInteger >>> (int)((long)i * 8L));
        }
        return theBytes;
    }

    public static long toLong(byte[] aBytes) throws IllegalArgumentException {
        return NumericalUtility.toLong(aBytes, 0);
    }

    public static long toLong(byte[] aBytes, int aOffset) throws IllegalArgumentException {
        long theWord = 0L;
        for (int i = 0; i < 8 && i + aOffset < aBytes.length; ++i) {
            theWord <<= 8;
            if (i >= aBytes.length) continue;
            theWord |= (long)aBytes[i + aOffset] & 0xFFL;
        }
        return theWord;
    }

    public static int toInteger(byte[] aBytes) throws IllegalArgumentException {
        return NumericalUtility.toInteger(aBytes, 0);
    }

    public static int toInteger(byte[] aBytes, int aOffset) throws IllegalArgumentException {
        int theWord = 0;
        for (int i = 0; i < 4 && i + aOffset < aBytes.length; ++i) {
            theWord <<= 8;
            if (i >= aBytes.length) continue;
            theWord |= aBytes[i + aOffset] & 0xFF;
        }
        return theWord;
    }

    public static short[] toShorts(byte[] aBytes) {
        short[] theShorts = new short[aBytes.length];
        for (int i = 0; i < aBytes.length; ++i) {
            theShorts[i] = aBytes[i];
        }
        return theShorts;
    }

    public static byte[] toBytes(Double aDouble) {
        byte[] theBytes = new byte[8];
        long theLong = Double.doubleToLongBits(aDouble);
        for (int i = 0; i < 8; ++i) {
            theBytes[i] = (byte)(theLong >> (7 - i) * 8 & 0xFFL);
        }
        return theBytes;
    }

    public static long toLong(String aString) {
        byte[] theBytes;
        try {
            theBytes = aString.getBytes(Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException e) {
            theBytes = aString.getBytes();
        }
        long theValue = 0L;
        for (int i = 0; i < theBytes.length; ++i) {
            theValue = (theValue << 8) + (long)(theBytes[i] & 0xFF);
        }
        return theValue;
    }

    public static double toDouble(String aString) {
        long theLong = NumericalUtility.toLong(aString);
        double theDouble = theLong >= 0L ? (double)theLong / 9.223372036854776E18 : 1.0 - (double)theLong / -9.223372036854776E18;
        return theDouble;
    }

    public static double[] toDoubles(String aString, int aCount) {
        if (aCount <= 0) {
            throw new IllegalArgumentException("The provided count <" + aCount + "> must be greatet than one!");
        }
        double[] theResult = new double[aCount];
        String[] theStrings = new String[aCount];
        int step = aString.length() / aCount;
        if (step == 0) {
            step = 1;
        }
        for (int i = 0; i < aCount; ++i) {
            theStrings[i] = "";
            int index = step * i;
            for (int j = 0; j < aString.length(); ++j) {
                if (index >= aString.length()) {
                    index = 0;
                }
                theStrings[i] = theStrings[i] + aString.charAt(index);
                ++index;
            }
            theResult[i] = NumericalUtility.toDouble(theStrings[i]);
        }
        return theResult;
    }

    public static int toHashCode(Object ... aObjects) {
        int thePrime = 31;
        int theResult = 1;
        for (Object eObject : aObjects) {
            theResult = 31 * theResult + (eObject == null ? 0 : eObject.hashCode());
        }
        return theResult;
    }

    public static long toUnsignedLong(int aSignedIntValue) {
        if (aSignedIntValue >= 0) {
            return aSignedIntValue;
        }
        long theSignedValue = aSignedIntValue;
        return theSignedValue & 0xFFFFFFFFL;
    }

    public static boolean toBoolean(String aValue) throws IllegalArgumentException {
        for (String eTrue : Literals.TRUE.getNames()) {
            if (!eTrue.equalsIgnoreCase(aValue)) continue;
            return true;
        }
        for (String eFalse : Literals.FALSE.getNames()) {
            if (!eFalse.equalsIgnoreCase(aValue)) continue;
            return false;
        }
        throw new IllegalArgumentException("Unable to determine neither <true> nor <false> for the provided string \"" + aValue + "\".");
    }

    public static String toMd5Hash(String aText) {
        try {
            byte[] theBytes = aText.getBytes();
            MessageDigest theMessageDigest = MessageDigest.getInstance(Encoding.MD5.getCode());
            theMessageDigest.update(theBytes, 0, theBytes.length);
            String theHash = new BigInteger(1, theMessageDigest.digest()).toString(32);
            return theHash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new HiddenException("Unexpected NoSuchAlgorithmException.", e);
        }
    }

    public static double toScaled(double aValue, double aMin, double aMax) {
        if (aValue < 0.0 || aValue > 1.0) {
            throw new IllegalArgumentException("The provided value <" + aValue + "> must be between 0 and 1!");
        }
        double theRange = aMax - aMin;
        double theScaled = aValue * theRange;
        double theShifted = theScaled + aMin;
        return theShifted;
    }

    public static int sum(int ... aSummands) {
        int theSum = 0;
        for (int eSummand : aSummands) {
            theSum += eSummand;
        }
        return theSum;
    }
}

