/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.observer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.VetoException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.mixin.Disposable;
import org.refcodes.observer.Observable;

public abstract class AbstractObservable<O, EV>
implements Observable<O>,
Disposable {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private List<O> _observers = new ArrayList<O>();
    private int _threadPriority = 5;
    private ExecutorService _executorService;
    private boolean _isDisposed = false;

    public AbstractObservable() {
        this(null);
    }

    public AbstractObservable(ExecutorService aExecutorService) {
        this._executorService = aExecutorService == null ? ControlFlowUtility.createDaemonExecutorService() : ControlFlowUtility.toManagedExecutorService(aExecutorService);
    }

    protected boolean fireEvent(EV aEvent, ExecutionStrategy aExecutionStrategy) throws VetoException {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        if (!this._observers.isEmpty()) {
            switch (aExecutionStrategy) {
                case PARALLEL: {
                    this.fireParallelEvent(aEvent);
                    return true;
                }
                case JOIN: {
                    return this.fireJoinEvent(aEvent);
                }
                case SEQUENTIAL: {
                    return this.fireSequentialEvent(aEvent);
                }
            }
        }
        return true;
    }

    @Override
    public boolean hasObserverSubscription(O aObserver) {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        return this._observers.contains(aObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subscribeObserver(O aObserver) {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        if (!this._observers.contains(aObserver)) {
            AbstractObservable abstractObservable = this;
            synchronized (abstractObservable) {
                if (!this._observers.contains(aObserver)) {
                    return this._observers.add(aObserver);
                }
            }
        }
        return false;
    }

    @Override
    public boolean unsubscribeObserver(O aObserver) {
        ControlFlowUtility.throwIllegalStateException(this._isDisposed);
        return this._observers.remove(aObserver);
    }

    protected abstract boolean fireEvent(EV var1, O var2, ExecutionStrategy var3) throws VetoException;

    protected void doHandleEventListenerException(Exception aException, O aObserver, EV aEvent, ExecutionStrategy aExecutionStrategy) {
        LOGGER.warn("Caught an unexpected exception while invoking event observer instances with strategy \"" + (Object)((Object)aExecutionStrategy) + "\" with message: " + ExceptionUtility.toMessage(aException), aException);
    }

    protected int size() {
        return this._observers.size();
    }

    protected boolean isEmpty() {
        return this._observers.isEmpty();
    }

    protected void clear() {
        this._observers.clear();
    }

    public int getThreadPriority() {
        return this._threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this._threadPriority = threadPriority;
    }

    @Override
    public void dispose() {
        ControlFlowUtility.shutdownGracefully(this._executorService);
        this._executorService = null;
        this.clear();
        this._isDisposed = true;
    }

    private boolean fireSequentialEvent(EV aEvent) throws VetoException {
        if (!this._observers.isEmpty()) {
            for (O eEventListener : this._observers) {
                try {
                    if (this.fireEvent(aEvent, eEventListener, ExecutionStrategy.SEQUENTIAL)) continue;
                    return false;
                }
                catch (Exception e) {
                    if (e instanceof VetoException) {
                        throw (VetoException)e;
                    }
                    if (e instanceof VetoException.VetoRuntimeException) {
                        throw (VetoException.VetoRuntimeException)e;
                    }
                    this.doHandleEventListenerException(e, eEventListener, aEvent, ExecutionStrategy.SEQUENTIAL);
                }
            }
        }
        return true;
    }

    private void fireParallelEvent(final EV aEvent) {
        if (!this._observers.isEmpty()) {
            for (final O eEventListener : this._observers) {
                Runnable eRunnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractObservable.this.fireEvent(aEvent, eEventListener, ExecutionStrategy.PARALLEL);
                        }
                        catch (Exception e) {
                            AbstractObservable.this.doHandleEventListenerException(e, eEventListener, aEvent, ExecutionStrategy.PARALLEL);
                        }
                    }
                };
                this._executorService.execute(eRunnable);
            }
        }
    }

    private boolean fireJoinEvent(final EV aEvent) throws VetoException {
        boolean theResult = true;
        if (!this._observers.isEmpty()) {
            ArrayList<Future<Boolean>> theFutures = new ArrayList<Future<Boolean>>();
            for (final O eEventListener : this._observers) {
                Callable<Boolean> eCallable = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        try {
                            return AbstractObservable.this.fireEvent(aEvent, eEventListener, ExecutionStrategy.JOIN);
                        }
                        catch (Exception e) {
                            AbstractObservable.this.doHandleEventListenerException(e, eEventListener, aEvent, ExecutionStrategy.JOIN);
                            throw e;
                        }
                    }
                };
                theFutures.add(this._executorService.submit(eCallable));
            }
            VetoException theVetoException = null;
            for (Future future : theFutures) {
                try {
                    if (((Boolean)future.get()).booleanValue()) continue;
                    theResult = false;
                }
                catch (Exception e) {
                    if (e instanceof VetoException) {
                        theVetoException = (VetoException)e;
                        continue;
                    }
                    LOGGER.warn("Caught an unexpected exception while invoking and joining event observer instances.", e);
                }
            }
            if (theVetoException != null) {
                throw theVetoException;
            }
        }
        return theResult;
    }
}

