/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.data.CharSet;
import org.refcodes.data.Delimiter;
import org.refcodes.runtime.PropertyBuilder;

public class PropertyBuilderImpl
implements PropertyBuilder {
    private String _key = null;

    @Override
    public String getKey() {
        return this._key;
    }

    @Override
    public void setKey(String aKey) {
        this._key = aKey;
    }

    @Override
    public PropertyBuilder withKey(String aKey) {
        this.setKey(aKey);
        return this;
    }

    @Override
    public String toPath(String aKey) {
        if (aKey == null || aKey.length() == 0) {
            return aKey;
        }
        String theKey = PropertyBuilderImpl.toNormalized(aKey, Delimiter.PATH.getChar());
        return theKey != null ? Delimiter.PATH.getChar() + theKey.toLowerCase() : theKey;
    }

    @Override
    public String toSystemProperty(String aKey) {
        if (aKey == null || aKey.length() == 0) {
            return aKey;
        }
        String theKey = PropertyBuilderImpl.toNormalized(aKey, Delimiter.NAMESPACE.getChar());
        return theKey != null ? theKey.toLowerCase() : theKey;
    }

    @Override
    public String toEnvironmentVariable(String aKey) {
        if (aKey == null || aKey.length() == 0) {
            return aKey;
        }
        String theKey = PropertyBuilderImpl.toNormalized(aKey, Delimiter.SNAKE_CASE.getChar());
        return theKey != null ? theKey.toUpperCase() : theKey;
    }

    @Override
    public String getSystemProperty(String aKey) {
        String theKey = this.toSystemProperty(aKey);
        return System.getProperty(theKey != null ? theKey : aKey);
    }

    @Override
    public String getEnvironmentVariable(String aKey) {
        String theKey = this.toEnvironmentVariable(aKey);
        return System.getenv(theKey != null ? theKey : aKey);
    }

    protected static String toNormalized(String aText, char aSeparator) {
        if (aText == null || aText.length() == 0) {
            return null;
        }
        String theRegexSeparator = CharSet.REGEX_SPECIAL_CHARS.hasChar(aSeparator) ? "\\" + aSeparator : "" + aSeparator;
        String theRegexDoubleSeparator = theRegexSeparator + theRegexSeparator;
        String theDoubleSeparator = aSeparator + "" + aSeparator;
        String theSeparator = aSeparator + "";
        if (aText == null || aText.length() == 0) {
            return aText;
        }
        StringBuffer theBuffer = new StringBuffer();
        while (aText.length() > 0 && !Character.isAlphabetic(aText.charAt(0)) && !Character.isDigit(aText.charAt(0))) {
            aText = aText.substring(1);
        }
        while (aText.length() > 0 && !Character.isAlphabetic(aText.charAt(aText.length() - 1)) && !Character.isDigit(aText.charAt(aText.length() - 1))) {
            aText = aText.substring(0, aText.length() - 1);
        }
        if (aText == null || aText.length() == 0) {
            return null;
        }
        theBuffer.append(aText.charAt(0));
        for (int i = 1; i < aText.length(); ++i) {
            if (Character.isLowerCase(aText.charAt(i - 1)) && Character.isUpperCase(aText.charAt(i))) {
                theBuffer.append(aSeparator);
            }
            if (!Character.isAlphabetic(aText.charAt(i))) {
                theBuffer.append(aSeparator);
                continue;
            }
            theBuffer.append(aText.charAt(i));
        }
        String theNormalited = theBuffer.toString();
        while (theNormalited.indexOf(theDoubleSeparator) != -1) {
            theNormalited = theNormalited.replaceAll(theRegexDoubleSeparator, theSeparator);
        }
        return theNormalited.toLowerCase();
    }
}

