/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.refcodes.structure.Attribute;
import org.refcodes.structure.AttributeImpl;

public final class ReflectionUtility {
    public static final String ALIAS_SET = "set";
    public static final String ALIAS_GET = "get";
    public static final String ALIAS_HAS = "has";
    public static final String ALIAS_IS = "is";
    public static final String ALIAS_TOSTRING = "toString";
    public static final NonExistingValueClass NON_EXISTING_VALUE = new NonExistingValueClass();

    private ReflectionUtility() {
    }

    public static Attribute[] toBeanAttributes(Object anObject) {
        ArrayList<AttributeImpl> theAttributeValueStructList = new ArrayList<AttributeImpl>();
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            for (int i = 0; i < theMethodArray.length; ++i) {
                if (theMethodArray[i].getParameterTypes().length != 0 || theMethodArray[i].getReturnType().equals(Void.TYPE)) continue;
                boolean isBeanMethod = false;
                Object eInvokeReturn = NON_EXISTING_VALUE;
                String eMethodName = theMethodArray[i].getName();
                if (theMethodArray[i].getModifiers() != 1 && theMethodArray[i].getModifiers() != 9) continue;
                if (eMethodName.indexOf(ALIAS_GET) == 0 && Character.isUpperCase(eMethodName.charAt(ALIAS_GET.length()))) {
                    isBeanMethod = true;
                    eMethodName = eMethodName.substring(ALIAS_GET.length(), eMethodName.length());
                } else if (eMethodName.indexOf(ALIAS_HAS) == 0 && Character.isUpperCase(eMethodName.charAt(ALIAS_HAS.length()))) {
                    isBeanMethod = true;
                    eMethodName = eMethodName.substring(ALIAS_HAS.length(), eMethodName.length());
                } else if (eMethodName.indexOf(ALIAS_IS) == 0 && Character.isUpperCase(eMethodName.charAt(ALIAS_IS.length()))) {
                    isBeanMethod = true;
                    eMethodName = eMethodName.substring(ALIAS_IS.length(), eMethodName.length());
                } else if (eMethodName.equals(ALIAS_TOSTRING)) {
                    isBeanMethod = true;
                }
                if (!isBeanMethod) continue;
                try {
                    eInvokeReturn = theMethodArray[i].invoke(anObject, new Object[0]);
                }
                catch (Exception e) {
                    System.err.println("ReflectionUtility.setAttribute(): Caught an exception of type <" + e.getClass().getName() + "> while invoking the method <" + eMethodName + "> with message = " + e.getMessage() + ".");
                    e.printStackTrace();
                }
                theAttributeValueStructList.add(new AttributeImpl(eMethodName, eInvokeReturn));
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of type <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        return theAttributeValueStructList.toArray(new AttributeImpl[theAttributeValueStructList.size()]);
    }

    public static void setAttribute(Object anObject, String anAttributeName, Object anAttributeValue) throws NoSuchMethodException {
        boolean isCalled = false;
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            for (int i = 0; i < theMethodArray.length; ++i) {
                if (theMethodArray[i].getParameterTypes().length != 1 || !theMethodArray[i].getParameterTypes()[0].isAssignableFrom(anAttributeValue.getClass()) || !theMethodArray[i].getReturnType().equals(Void.TYPE)) continue;
                String theMethodName = theMethodArray[i].getName();
                if (theMethodArray[i].getModifiers() != 1 && theMethodArray[i].getModifiers() != 9 || theMethodName.indexOf(ALIAS_SET) != 0 || !Character.isUpperCase(theMethodName.charAt(ALIAS_SET.length())) || !anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_SET.length(), theMethodName.length()))) continue;
                try {
                    theMethodArray[i].invoke(anObject, anAttributeValue);
                    isCalled = true;
                }
                catch (Exception e) {
                    System.err.println("ReflectionUtility.setAttribute(): Caught an exception of type <" + e.getClass().getName() + "> while invoking the method <" + theMethodName + "> with message = " + e.getMessage() + ".");
                    e.printStackTrace();
                }
                break;
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of type <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        if (!isCalled) {
            throw new NoSuchMethodException("ReflectionUtility.setAttribute(): The method for the attribute <" + anAttributeName + "> for the class <" + anObject.getClass().getName() + "> cannot be found.");
        }
    }

    public static void setAttribute(Object anObject, Attribute anAttributeValueStruct) throws NoSuchMethodException {
        ReflectionUtility.setAttribute(anObject, (String)anAttributeValueStruct.getKey(), anAttributeValueStruct.getValue());
    }

    public static boolean hasSetterAttribute(Object anObject, String anAttributeName, Class<?> anAttributeType) {
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            for (int i = 0; i < theMethodArray.length; ++i) {
                if (theMethodArray[i].getParameterTypes().length != 1 || !theMethodArray[i].getParameterTypes()[0].isAssignableFrom(anAttributeType) || !theMethodArray[i].getReturnType().equals(Void.TYPE)) continue;
                String theMethodName = theMethodArray[i].getName();
                if (theMethodArray[i].getModifiers() != 1 && theMethodArray[i].getModifiers() != 9 || theMethodName.indexOf(ALIAS_SET) != 0 || !Character.isUpperCase(theMethodName.charAt(ALIAS_SET.length())) || !anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_SET.length(), theMethodName.length()))) continue;
                return true;
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of type <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        return false;
    }

    public static boolean hasGetterAttribute(Object anObject, String anAttributeName, Class<?> aReturnType) {
        Method[] theMethodArray = anObject.getClass().getMethods();
        try {
            for (int i = 0; i < theMethodArray.length; ++i) {
                if (theMethodArray[i].getParameterTypes().length != 0 || !theMethodArray[i].getReturnType().equals(aReturnType)) continue;
                String theMethodName = theMethodArray[i].getName();
                if (theMethodArray[i].getModifiers() != 1 && theMethodArray[i].getModifiers() != 9 || !(theMethodName.indexOf(ALIAS_GET) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_GET.length())) ? anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_GET.length(), theMethodName.length())) : (theMethodName.indexOf(ALIAS_HAS) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_HAS.length())) ? anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_HAS.length(), theMethodName.length())) : (theMethodName.indexOf(ALIAS_IS) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_IS.length())) ? anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_IS.length(), theMethodName.length())) : theMethodName.indexOf(ALIAS_TOSTRING) == 0 && Character.isUpperCase(theMethodName.charAt(ALIAS_TOSTRING.length())) && anAttributeName.equalsIgnoreCase(theMethodName = theMethodName.substring(ALIAS_TOSTRING.length(), theMethodName.length())))))) continue;
                return true;
            }
        }
        catch (Exception exc) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of type <" + exc.getClass().getName() + "> with message = " + exc.getMessage() + ".");
            exc.printStackTrace();
        }
        return false;
    }

    public static class NonExistingValueClass {
    }
}

