/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Folder;
import org.refcodes.data.Folders;
import org.refcodes.data.Protocol;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.runtime.OperatingSystem;

public final class RuntimeUtility {
    private static String[] MAIN_METHODS = new String[]{"main", "start", "<clinit>", "<init>"};
    private static String[] MAIN_METHOD_PREFIXES = new String[]{"test"};
    private static String[] FRAMEWORK_LAUNCHERS = new String[]{"JarLauncher", "TestRunner", "ForkedBooter"};
    private static Protocol[] JAR_PROTOCOLS = new Protocol[]{Protocol.JAR, Protocol.ZIP, Protocol.SH};

    private RuntimeUtility() {
    }

    public static String toStackTrace() {
        StringWriter theStringWriter = new StringWriter();
        new Throwable("").printStackTrace(new PrintWriter(theStringWriter));
        return theStringWriter.toString();
    }

    public static StackTraceElement getCallerStackTraceElement() {
        StackTraceElement[] theStackTraceElements;
        for (StackTraceElement eStackTraceElement : theStackTraceElements = Thread.currentThread().getStackTrace()) {
            if (RuntimeUtility.isSkipStackTraceElement(eStackTraceElement)) continue;
            return eStackTraceElement;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(Class<?> aCallee) {
        StackTraceElement[] theStackTraceElements = Thread.currentThread().getStackTrace();
        String theCalleeClassName = aCallee.getName();
        boolean hasCalleeElement = false;
        for (StackTraceElement eStackTraceElement : theStackTraceElements) {
            if (hasCalleeElement && !eStackTraceElement.getClassName().equals(theCalleeClassName)) {
                return eStackTraceElement;
            }
            if (!eStackTraceElement.getClassName().equals(theCalleeClassName)) continue;
            hasCalleeElement = true;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(Class<?> ... aCallees) {
        StackTraceElement eCaller = null;
        for (Class<?> eClallee : aCallees) {
            eCaller = RuntimeUtility.getCallerStackTraceElement(eClallee);
            if (eCaller == null) continue;
            return eCaller;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(String aCalleeClassName) {
        StackTraceElement[] theStackTraceElements = Thread.currentThread().getStackTrace();
        boolean hasCalleeElement = false;
        for (StackTraceElement eStackTraceElement : theStackTraceElements) {
            if (hasCalleeElement && !eStackTraceElement.getClassName().startsWith(aCalleeClassName)) {
                return eStackTraceElement;
            }
            if (!eStackTraceElement.getClassName().startsWith(aCalleeClassName)) continue;
            hasCalleeElement = true;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(String ... aCalleeClassNames) {
        StackTraceElement eCaller = null;
        for (String eClallee : aCalleeClassNames) {
            eCaller = RuntimeUtility.getCallerStackTraceElement(eClallee);
            if (eCaller == null) continue;
            return eCaller;
        }
        return null;
    }

    public static Class<?> getCallerType() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(Class<?> aCallee) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallee);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> getCallerType(Class<?> ... aCallees) {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(aCallees);
        return RuntimeUtility.toClass(theStackTraceElement);
    }

    public static Class<?> toClass(StackTraceElement aStackTraceElement) {
        try {
            return Class.forName(aStackTraceElement.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new HiddenException(e);
        }
    }

    public static String toMethodName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getMethodName();
    }

    public static String toClassName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return RuntimeUtility.toClassName(aStackTraceElement.getClassName());
    }

    public static String toFullyQualifiedClassName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getClassName();
    }

    public static String toFullyQualifiedMethodName(StackTraceElement aStackTraceElement) {
        if (aStackTraceElement == null) {
            return null;
        }
        return aStackTraceElement.getClassName() + Delimiter.METHOD_NAME.getChar() + aStackTraceElement.getMethodName();
    }

    public static String toFullyQualifiedClassName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return theStackTraceElement.getClassName();
    }

    public static String toFullyQualifiedMethodName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return theStackTraceElement.getClassName() + Delimiter.METHOD_NAME.getChar() + theStackTraceElement.getMethodName();
    }

    public static String toMethodName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return theStackTraceElement.getMethodName();
    }

    public static String toClassName() {
        return RuntimeUtility.toClassName(RuntimeUtility.toFullyQualifiedClassName());
    }

    public static String toFullyQualifiedPackageName() {
        return RuntimeUtility.toFullyQualifiedPackageName(RuntimeUtility.toFullyQualifiedClassName());
    }

    public static String toFullyQualifiedPackageName(StackTraceElement aStackTraceElement) {
        return RuntimeUtility.toFullyQualifiedPackageName(RuntimeUtility.toFullyQualifiedClassName(aStackTraceElement));
    }

    public static String toClassName(String aFullyQualifiedClassName) {
        int theClassIndex = aFullyQualifiedClassName.lastIndexOf(46);
        String theClassName = theClassIndex != -1 ? aFullyQualifiedClassName.substring(theClassIndex + 1) : aFullyQualifiedClassName;
        int theInnerClassIndex = theClassName.indexOf(36);
        if (theInnerClassIndex != -1) {
            theClassName = theClassName.substring(theInnerClassIndex + 1);
        }
        return theClassName;
    }

    public static String toFullyQualifiedPackageName(String aFullyQualifiedClassName) {
        int theIndex = aFullyQualifiedClassName.lastIndexOf(46);
        if (theIndex != -1) {
            return aFullyQualifiedClassName.substring(0, theIndex);
        }
        return "";
    }

    public static <T> T toClone(T aObj) throws CloneNotSupportedException {
        if (aObj instanceof Cloneable) {
            try {
                return (T)aObj.getClass().getMethod("clone", new Class[0]).invoke(aObj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new CloneNotSupportedException(ExceptionUtility.toMessage(e));
            }
        }
        throw new CloneNotSupportedException("The type \"" + aObj.getClass().getName() + "}\" does not implement the \"" + Cloneable.class.getName() + "\" interface.");
    }

    public static String toString(String aToString, String aSuperToString) {
        return aToString + " (" + aSuperToString + ")";
    }

    public static Long getPid() {
        Long thePid;
        block4: {
            thePid = null;
            try {
                thePid = Long.parseLong(SystemProperty.PROCESS_ID.getValue());
            }
            catch (NumberFormatException e1) {
                String theJvmName = ManagementFactory.getRuntimeMXBean().getName();
                if (theJvmName.indexOf(64) == -1) break block4;
                try {
                    thePid = Long.parseLong(theJvmName.substring(0, theJvmName.indexOf(64)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return thePid;
    }

    public static Process killProcess(Long aPid) throws IOException {
        Process theProcess = null;
        switch (OperatingSystem.toOperatingSystem()) {
            case WINDOWS: {
                String theCmd = "taskkill /F /PID " + aPid;
                theProcess = Runtime.getRuntime().exec(theCmd);
                break;
            }
            case UNIX: {
                String theCmd = "kill -9 " + aPid;
                theProcess = Runtime.getRuntime().exec(theCmd);
                break;
            }
        }
        return theProcess;
    }

    public static boolean kill(Long aPid) throws IOException, InterruptedException {
        Process theProcess = RuntimeUtility.killProcess(aPid);
        if (theProcess != null) {
            theProcess.waitFor();
            return theProcess.exitValue() == 0;
        }
        return false;
    }

    public static File toLauncherDir() {
        Protocol eProtocol;
        String truncate;
        String basePath;
        Class<RuntimeUtility> baseClass = RuntimeUtility.getMainClass();
        if (baseClass == null) {
            baseClass = RuntimeUtility.class;
        }
        if ((basePath = baseClass.getProtectionDomain().getCodeSource().getLocation().getPath()).startsWith(Protocol.FILE.toPrefix())) {
            basePath = basePath.substring(Protocol.FILE.toPrefix().length());
        }
        try {
            String theCanonicalName = baseClass.getCanonicalName();
            truncate = theCanonicalName.replace('.', '/');
        }
        catch (Exception e) {
            return null;
        }
        truncate = truncate.substring(0, truncate.indexOf(baseClass.getSimpleName()));
        int endIndex = basePath.indexOf(truncate);
        if (endIndex > 0) {
            basePath = basePath.substring(0, endIndex);
        }
        if (basePath.endsWith("" + Delimiter.PATH.getChar())) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        if (basePath.endsWith(Folder.CLASSES.getName())) {
            basePath = basePath.substring(0, basePath.indexOf(Folder.CLASSES.getName()));
        }
        int index = -1;
        Protocol[] protocolArray = JAR_PROTOCOLS;
        int n = protocolArray.length;
        for (int i = 0; i < n && (index = (eProtocol = protocolArray[i]).firstResourceLocatorIndex(basePath.toLowerCase())) == -1; ++i) {
        }
        if (index != -1 && (index = (basePath = basePath.substring(0, index)).lastIndexOf(Delimiter.PATH.getChar())) != -1) {
            basePath = basePath.substring(0, index);
        }
        if (!basePath.endsWith("" + Delimiter.PATH.getChar())) {
            basePath = basePath + Delimiter.PATH.getChar();
        }
        File baseFile = new File(basePath);
        if (basePath.endsWith(Folder.TARGET.getName() + Delimiter.PATH.getChar())) {
            return baseFile;
        }
        File parentFile = baseFile.getParentFile();
        return parentFile;
    }

    public static Class getMainClass() {
        Class<?> mainClass;
        StackTraceElement eElement;
        int i;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        ArrayList<StackTraceElement> theCandidates = new ArrayList<StackTraceElement>();
        block4: for (i = stack.length - 1; i > 0; --i) {
            eElement = stack[i];
            for (String eMain : MAIN_METHODS) {
                if (!eElement.getMethodName().equals(eMain)) continue;
                theCandidates.add(eElement);
                continue block4;
            }
        }
        block6: for (i = stack.length - 1; i > 0; --i) {
            eElement = stack[i];
            for (String ePrefix : MAIN_METHOD_PREFIXES) {
                if (!eElement.getMethodName().startsWith(ePrefix)) continue;
                theCandidates.add(eElement);
                continue block6;
            }
        }
        block8: for (StackTraceElement eCandidate : theCandidates) {
            for (String eLauncer : FRAMEWORK_LAUNCHERS) {
                if (eCandidate.getClassName().toLowerCase().contains(eLauncer.toLowerCase())) continue block8;
            }
            try {
                mainClass = Class.forName(eCandidate.getClassName());
                if (mainClass.getProtectionDomain().getCodeSource() == null) continue;
                return mainClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        for (StackTraceElement eCandidate : theCandidates) {
            try {
                mainClass = Class.forName(eCandidate.getClassName());
                if (mainClass.getProtectionDomain().getCodeSource() == null) continue;
                return mainClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public static List<File> toConfigDirs(File ... aBaseDirectories) throws IOException {
        File theSystemDir;
        ArrayList<File> theDirs = new ArrayList<File>();
        ArrayList<File> theBaseDirs = new ArrayList<File>();
        if (aBaseDirectories == null) {
            aBaseDirectories = new File[]{new File(".")};
        }
        if ((theSystemDir = RuntimeUtility.toDirectory(SystemProperty.CONFIG_DIR.getValue())) != null) {
            theDirs.add(theSystemDir);
        }
        for (File eBaseDir : aBaseDirectories) {
            File eConfigDir;
            File theParentFile;
            if (eBaseDir == null) continue;
            if (!(eBaseDir.exists() && eBaseDir.isDirectory() || (theParentFile = eBaseDir.getAbsoluteFile().getParentFile()) == null)) {
                eBaseDir = theParentFile;
            }
            if (eBaseDir != null && eBaseDir.exists() && eBaseDir.isDirectory() && eBaseDir.canRead()) {
                for (String eDirName : Folders.CONFIG_DIRS.getNames()) {
                    eConfigDir = new File(eBaseDir, eDirName);
                    if (eConfigDir == null || !eConfigDir.exists() || !eConfigDir.isDirectory() || !eConfigDir.canRead() || RuntimeUtility.containsDir(eConfigDir, theDirs, theBaseDirs)) continue;
                    theDirs.add(eConfigDir);
                }
                if (!RuntimeUtility.containsDir(eBaseDir, theDirs, theBaseDirs)) {
                    if (eBaseDir.getAbsolutePath().endsWith(Folder.TARGET.getName())) {
                        theBaseDirs.add(0, eBaseDir);
                    } else {
                        theBaseDirs.add(eBaseDir);
                    }
                }
                for (String eDirName : Folders.CONFIG_DIRS.getNames()) {
                    eConfigDir = new File(eBaseDir.getParentFile(), eDirName);
                    if (eConfigDir == null || !eConfigDir.exists() || !eConfigDir.isDirectory() || !eConfigDir.canRead() || RuntimeUtility.containsDir(eConfigDir, theDirs, theBaseDirs)) continue;
                    theDirs.add(eConfigDir);
                }
            }
            if (eBaseDir.getAbsolutePath().endsWith(Folder.TARGET.getName())) {
                eConfigDir = new File(eBaseDir, Folder.CLASSES.getName());
                if (eConfigDir != null && eConfigDir.exists() && eConfigDir.isDirectory() && eConfigDir.canRead() && !RuntimeUtility.containsDir(eConfigDir, theDirs, theBaseDirs)) {
                    theDirs.add(eConfigDir);
                }
                if ((eConfigDir = new File(eBaseDir, Folder.TEST_CLASSES.getName())) == null || !eConfigDir.exists() || !eConfigDir.isDirectory() || !eConfigDir.canRead() || RuntimeUtility.containsDir(eConfigDir, theDirs, theBaseDirs)) continue;
                theDirs.add(eConfigDir);
                continue;
            }
            eConfigDir = new File(new File(eBaseDir, Folder.TARGET.getName()), Folder.CLASSES.getName());
            if (eConfigDir != null && eConfigDir.exists() && eConfigDir.isDirectory() && eConfigDir.canRead() && !RuntimeUtility.containsDir(eConfigDir, theDirs, theBaseDirs)) {
                theDirs.add(eConfigDir);
            }
            if ((eConfigDir = new File(new File(eBaseDir, Folder.TARGET.getName()), Folder.TEST_CLASSES.getName())) == null || !eConfigDir.exists() || !eConfigDir.isDirectory() || !eConfigDir.canRead() || RuntimeUtility.containsDir(eConfigDir, theDirs, theBaseDirs)) continue;
            theDirs.add(eConfigDir);
        }
        theDirs.addAll(theBaseDirs);
        return theDirs;
    }

    public static List<File> toConfigDirs() throws IOException {
        return RuntimeUtility.toConfigDirs(new File[]{RuntimeUtility.toLauncherDir()});
    }

    public static List<File> toConfigDirs(File aBaseDirectory) throws IOException {
        return RuntimeUtility.toConfigDirs(aBaseDirectory, RuntimeUtility.toLauncherDir());
    }

    @SafeVarargs
    protected static boolean containsDir(File aDir, List<File> ... aDirs) {
        for (List<File> eDirs : aDirs) {
            if (!eDirs.contains(aDir)) continue;
            return true;
        }
        return false;
    }

    private static File toDirectory(String aDirPath) {
        File theDir;
        if (aDirPath != null && (theDir = new File(aDirPath)).exists() && theDir.isDirectory()) {
            return theDir;
        }
        return null;
    }

    private static boolean isSkipStackTraceElement(StackTraceElement aStackTraceElement) {
        return aStackTraceElement.getClassName().equals(Thread.class.getName()) || aStackTraceElement.getClassName().equals(RuntimeUtility.class.getName()) || aStackTraceElement.getLineNumber() <= 1;
    }
}

