/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.structure;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.refcodes.data.Delimiter;
import org.refcodes.mixin.DelimiterAccessor;
import org.refcodes.mixin.Dumpable;
import org.refcodes.mixin.TypeAccessor;
import org.refcodes.structure.Dictionary;
import org.refcodes.structure.PathMapImpl;
import org.refcodes.structure.Relation;

public interface PathMap<T>
extends Dictionary<String, T>,
DelimiterAccessor,
TypeAccessor<T>,
Dumpable {
    default public boolean isArray() {
        return this.isArray(this.toRootPath());
    }

    default public boolean isArray(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        PathMap<T> theMap = this.retrieveFrom(aPath);
        for (String eEntry : theMap.entries()) {
            try {
                if (!theMap.isRecord(eEntry)) {
                    return false;
                }
                int index = Integer.valueOf(eEntry);
                if (index >= 0) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return !theMap.isEmpty();
    }

    default public T[] getArray() {
        return this.getArray("");
    }

    default public T[] getArray(String aPath) {
        int index;
        aPath = this.toNormalizedPath(aPath);
        int theMax = -1;
        PathMap<T> theMap = this.retrieveFrom(aPath);
        for (String eEntry : theMap.entries()) {
            try {
                if (!theMap.isRecord(eEntry)) {
                    throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the records below the given path can be retireved as array.");
                }
                index = Integer.valueOf(eEntry);
                if (index < 0) {
                    throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the records below the given path can be retireved as array.");
                }
                if (index <= theMax) continue;
                theMax = index;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the records below the given path can be retireved as array.");
            }
        }
        Object[] theArray = (Object[])Array.newInstance(this.getType(), theMax + 1);
        for (String eEntry : theMap.entries()) {
            try {
                if (!theMap.isRecord(eEntry)) {
                    throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the records below the given path can be retireved as array.");
                }
                index = Integer.valueOf(eEntry);
                theArray[index] = theMap.get(eEntry);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The provided path \"" + aPath + "\" does not point to an array structure. Use \"isArray( String )\" to test if the records below the given path can be retireved as array.");
            }
        }
        return theArray;
    }

    default public Set<String> keySet(String aPath) {
        String thePath = aPath = this.toNormalizedPath(aPath) + this.getDelimiter();
        HashSet<String> theKeySet = new HashSet<String>();
        this.keySet().forEach(eKey -> {
            if (eKey.length() > thePath.length() && eKey.startsWith(thePath)) {
                String ePath = eKey.substring(thePath.length());
                theKeySet.add(ePath);
            }
        });
        return theKeySet;
    }

    default public Set<String> paths() {
        return this.keySet();
    }

    default public Set<String> paths(String aPath) {
        return this.keySet(aPath);
    }

    default public boolean isEntry(String aPath) {
        return this.isEntry(aPath) || this.isDirectory(aPath);
    }

    default public Set<String> entries() {
        return this.entries(this.toRootPath());
    }

    default public Set<String> entries(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        HashSet<String> theElements = new HashSet<String>();
        this.keySet(aPath).forEach(eKey -> {
            if (eKey.length() > 0) {
                int i = eKey.indexOf(this.getDelimiter(), 0);
                if (i == -1) {
                    theElements.add((String)eKey);
                } else if ((eKey = eKey.substring(0, i)).length() > 0) {
                    theElements.add((String)eKey);
                }
            }
        });
        return theElements;
    }

    default public boolean isDirectory(String aPath) {
        return !this.containsKey(aPath = this.toNormalizedPath(aPath)) && !this.entries(aPath).isEmpty();
    }

    default public Set<String> directories() {
        return this.directories(this.toRootPath());
    }

    default public Set<String> directories(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        HashSet<String> theDirs = new HashSet<String>();
        this.keySet(aPath).forEach(eKey -> {
            int i = eKey.indexOf(this.getDelimiter(), 0);
            if (i != -1 && (eKey = eKey.substring(0, i)).length() > 0) {
                theDirs.add((String)eKey);
            }
        });
        return theDirs;
    }

    default public boolean isRecord(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        return this.containsKey(aPath);
    }

    default public Set<String> records() {
        return this.records(this.toRootPath());
    }

    default public Set<String> records(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        HashSet<String> theRecords = new HashSet<String>();
        this.keySet(aPath).forEach(eKey -> {
            if (eKey.length() > 0 && eKey.indexOf(this.getDelimiter(), 0) == -1) {
                theRecords.add((String)eKey);
            }
        });
        return theRecords;
    }

    public PathMap<T> retrieveFrom(String var1);

    public PathMap<T> retrieveTo(String var1);

    default public PathMap<T> retrieve(String aFromPath, String aToPath) {
        PathMap<T> thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    default public Map<String, ?> toMap() throws IllegalStateException {
        return this.toMap(this.toRootPath());
    }

    default public Map<String, ?> toMap(String aFromPath) throws IllegalStateException {
        aFromPath = this.toNormalizedPath(aFromPath);
        HashMap theMap = new HashMap();
        Set theKeySet = this.keySet();
        ArrayList theKeys = new ArrayList(theKeySet);
        Collections.sort(theKeys);
        for (String ePath : theKeys) {
            String eTail;
            String[] ePathArray;
            if (!ePath.startsWith(aFromPath) || ePath.length() <= aFromPath.length() || (ePathArray = (eTail = ePath.substring(aFromPath.length() + 1)).split(this.toRootPath())).length <= 0) continue;
            Map<String, Object[]> eMap = theMap;
            int ePathDepth = 0;
            Iterator<String> e = Arrays.asList(ePathArray).iterator();
            while (e.hasNext()) {
                List<Object> toList;
                Object toObj;
                String ePathElement = e.next();
                ++ePathDepth;
                if (e.hasNext()) {
                    try {
                        Map toMap;
                        toObj = eMap.get(ePathElement);
                        if (toObj != null) {
                            toMap = null;
                            if (toObj instanceof Map) {
                                eMap = (Map)toObj;
                                continue;
                            }
                            if (toObj.getClass().isArray()) {
                                Object[] toArray;
                                for (Object eElement : toArray = (Object[])toObj) {
                                    if (!(eElement instanceof Map)) continue;
                                    toMap = (Map)eElement;
                                    break;
                                }
                                if (toMap == null) {
                                    toList = Arrays.asList(toArray);
                                    toMap = new HashMap();
                                    toList.add(toMap);
                                    eMap.put(ePathElement, toList.toArray());
                                    eMap = toMap;
                                    continue;
                                }
                                eMap = toMap;
                                continue;
                            }
                            ArrayList<Object> toList2 = new ArrayList<Object>();
                            toList2.add(toObj);
                            toMap = new HashMap();
                            toList2.add(toMap);
                            eMap.put(ePathElement, toList2.toArray());
                            eMap = toMap;
                            continue;
                        }
                        toMap = new HashMap();
                        eMap.put(ePathElement, (Object[])toMap);
                        eMap = toMap;
                        continue;
                    }
                    catch (ClassCastException ex) {
                        throw new IllegalStateException("There is already a value for path element <" + ePathElement + "> (at a path depth of <" + ePathDepth + ">) in the path <" + ePath + ">, unable to create an according nested Map in that position for succeeding path elements!");
                    }
                }
                toObj = eMap.get(ePathElement);
                Object fromValue = this.get(ePath);
                if (toObj != null) {
                    Object toMap = null;
                    if (toObj.getClass().isArray()) {
                        Object[] toArray = (Object[])toObj;
                        List<Object> toList3 = Arrays.asList(toArray);
                        toList3.add(fromValue);
                        eMap.put(ePathElement, toList3.toArray());
                        eMap = toMap;
                        continue;
                    }
                    toList = new ArrayList();
                    toList.add(toObj);
                    toList.add(fromValue);
                    eMap.put(ePathElement, toList.toArray());
                    continue;
                }
                eMap.put(ePathElement, (Object[])fromValue);
            }
        }
        return theMap;
    }

    default public Object toDataStructure() {
        return this.toDataStructure(this.toRootPath());
    }

    public Object toDataStructure(String var1);

    default public String toNormalizedPath(String aPath) {
        if (aPath != null) {
            if (!aPath.startsWith(this.toRootPath())) {
                aPath = this.getDelimiter() + aPath;
            }
            while (aPath.endsWith(this.toRootPath())) {
                aPath = aPath.substring(0, aPath.length() - 1);
            }
            return aPath;
        }
        return "";
    }

    default public String fromExternalKey(String aKey, char ... aDelimiters) {
        if (aDelimiters != null && aDelimiters.length > 0) {
            for (char eDelimiter : aDelimiters) {
                if (eDelimiter == this.getDelimiter()) continue;
                aKey = aKey.replace(eDelimiter, this.getDelimiter());
            }
        }
        return aKey;
    }

    default public String toExternalKey(String aKey, char aDelimiter) {
        if (aKey.startsWith("" + Delimiter.PATH.getChar()) || aKey.startsWith("" + Delimiter.DOS_PATH.getChar())) {
            aKey = aKey.substring(1);
        }
        if (aDelimiter != this.getDelimiter()) {
            aKey = aKey.replace(this.getDelimiter(), aDelimiter);
        }
        return aKey;
    }

    default public String toRootPath() {
        return this.getDelimiter() + "";
    }

    default public boolean isRootPath(String aPath) {
        aPath = this.toNormalizedPath(aPath);
        String theRootPath = this.toNormalizedPath(this.toRootPath());
        return theRootPath.equals(aPath);
    }

    default public String toNormalizedPath(String aParentPath, String aChildPath) {
        return this.toNormalizedPath(aParentPath) + this.toNormalizedPath(aChildPath);
    }

    default public boolean hasParentPath(String aPath) {
        int index = (aPath = this.toNormalizedPath(aPath)).lastIndexOf(this.getDelimiter());
        return index > 0;
    }

    default public String toParentPath(String aPath) {
        int index = (aPath = this.toNormalizedPath(aPath)).lastIndexOf(this.getDelimiter());
        if (index <= 0) {
            throw new IllegalArgumentException("The path \"" + aPath + "\" does not have a parent path!");
        }
        return aPath.substring(0, index);
    }

    public static interface PathMapBuilder<T>
    extends MutablePathMap<T>,
    Dictionary.MutableDictionary.DictionaryBuilder<String, T, PathMapBuilder<T>> {
        @Override
        default public PathMapBuilder<T> withPut(String aKey, T aValue) {
            this.put(aKey, aValue);
            return this;
        }

        @Override
        default public PathMapBuilder<T> withPut(Relation<String, T> aRelation) {
            this.put(aRelation);
            return this;
        }

        default public PathMapBuilder<T> withRemoveFrom(String aPath) {
            this.removeAll(aPath);
            return this;
        }

        default public PathMapBuilder<T> withInsert(Object aObj) {
            this.insert(aObj);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(Object aFrom, String aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(String aToPath, Object aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        default public PathMapBuilder<T> withInsert(String aToPath, Object aFrom, String aFromPath) {
            this.insert(aToPath, aFrom, aFromPath);
            return this;
        }

        default public PathMapBuilder<T> withInsert(PathMap<T> aFrom) {
            return this.withInsert((Object)aFrom);
        }

        default public PathMapBuilder<T> withInsertFrom(PathMap<T> aFrom, String aFromPath) {
            return this.withInsertFrom((Object)aFrom, aFromPath);
        }

        default public PathMapBuilder<T> withInsertTo(String aToPath, PathMap<T> aFrom) {
            return this.withInsertTo(aToPath, (Object)aFrom);
        }

        default public PathMapBuilder<T> withInsert(String aToPath, PathMap<T> aFrom, String aFromPath) {
            return this.withInsert(aToPath, (Object)aFrom, aFromPath);
        }
    }

    public static interface MutablePathMap<T>
    extends PathMap<T>,
    Dictionary.MutableDictionary<String, T>,
    Map<String, T> {
        @Override
        default public T put(Relation<String, T> aRelation) {
            return (T)this.put(aRelation.getKey(), aRelation.getValue());
        }

        default public T[] putArray(T[] aValues) {
            return this.putArray("", aValues);
        }

        default public T[] putArray(String aPath, T[] aValues) {
            aPath = this.toNormalizedPath(aPath);
            T[] theResult = this.getArray(aPath);
            this.removeAll(aPath);
            for (int i = 0; i < aValues.length; ++i) {
                this.put(aPath + this.getDelimiter() + i + this.getDelimiter(), aValues[i]);
            }
            return theResult;
        }

        @Override
        default public T delete(String aKey) {
            return (T)this.remove(aKey);
        }

        default public void removeAll(String aPath) {
            aPath = this.toNormalizedPath(aPath) + this.getDelimiter();
            Iterator<String> e = this.paths().iterator();
            while (e.hasNext()) {
                if (!e.next().startsWith(aPath)) continue;
                e.remove();
            }
        }

        default public T put(String aParentPath, String aChildPath, T aValue) {
            return this.put(this.toNormalizedPath(aParentPath, aChildPath), aValue);
        }

        default public void insert(Object aFrom) {
            PathMapImpl thePathMap = new PathMapImpl(aFrom, this.getDelimiter(), this.getType());
            for (String ePath : thePathMap.paths()) {
                this.put(ePath, thePathMap.get(ePath));
            }
        }

        default public void insertFrom(Object aFrom, String aFromPath) {
            PathMap thePathMap = new PathMapImpl(aFrom, this.getDelimiter(), this.getType());
            thePathMap = thePathMap.retrieveFrom(aFromPath);
            for (String ePath : thePathMap.paths()) {
                this.put(ePath, thePathMap.get(ePath));
            }
        }

        default public void insertTo(String aToPath, Object aFrom) {
            aToPath = this.toNormalizedPath(aToPath);
            PathMapImpl thePathMap = new PathMapImpl(aFrom, this.getDelimiter(), this.getType());
            for (String ePath : thePathMap.paths()) {
                this.put(aToPath + ePath, thePathMap.get(ePath));
            }
        }

        default public void insert(String aToPath, Object aFrom, String aFromPath) {
            PathMapImpl thePathMap = new PathMapImpl(aFrom, this.getDelimiter(), this.getType());
            this.insertTo(aToPath, thePathMap.retrieveFrom(aFromPath));
        }

        default public void insert(PathMap<T> aFrom) {
            this.insert((Object)aFrom);
        }

        default public void insertFrom(PathMap<T> aFrom, String aFromPath) {
            this.insertFrom((Object)aFrom, aFromPath);
        }

        default public void insertTo(String aToPath, PathMap<T> aFrom) {
            this.insertTo(aToPath, (Object)aFrom);
        }

        default public void insert(String aToPath, PathMap<T> aFrom, String aFromPath) {
            this.insert(aToPath, (Object)aFrom, aFromPath);
        }
    }
}

