/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Base64;
import org.refcodes.exception.HiddenException;
import org.refcodes.tabular.AbstractColumn;

public class ColumnImpl<T>
extends AbstractColumn<T>
implements Cloneable {
    public ColumnImpl(String aKey, Class<T> aType) {
        super(aKey, aType);
    }

    @Override
    public String[] toStorageStrings(T aValue) {
        if (aValue == null) {
            return null;
        }
        if (this.getType().isArray()) {
            Object[] theValues = (Object[])aValue;
            String[] theStrings = new String[theValues.length];
            for (int i = 0; i < theValues.length; ++i) {
                theStrings[i] = this.toString(theValues[i]);
            }
            return theStrings;
        }
        return new String[]{this.toString(aValue)};
    }

    @Override
    public T fromStorageStrings(String[] aStringValues) throws ParseException {
        if (aStringValues == null || aStringValues.length == 0) {
            return null;
        }
        if (this.getType().isArray()) {
            Object[] theValues = (Object[])Array.newInstance(this.getType().getComponentType(), aStringValues.length);
            for (int i = 0; i < aStringValues.length; ++i) {
                theValues[i] = this.fromString(aStringValues[i]);
            }
            return (T)theValues;
        }
        if (aStringValues.length == 1) {
            return this.fromString(aStringValues[0]);
        }
        throw new IllegalArgumentException("The type <" + this.getType().getName() + "> is not an array type though the number of elements in the provided string array is <" + aStringValues.length + "> whereas only one element is being expected.");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private String toString(Object aValue) {
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream theOutput = null;
        try {
            theOutput = new ObjectOutputStream(theOutputStream);
            theOutput.writeObject(aValue);
            byte[] theBytes = theOutputStream.toByteArray();
            String string = Base64.getEncoder().encodeToString(theBytes);
            return string;
        }
        catch (IOException aException) {
            throw new HiddenException(aException);
        }
        finally {
            try {
                if (theOutput != null) {
                    theOutput.close();
                }
            }
            catch (IOException iOException) {}
            try {
                theOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private T fromString(String aStringValue) {
        Object object;
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(Base64.getDecoder().decode(aStringValue));
        ObjectInputStream theInput = null;
        try {
            theInput = new ObjectInputStream(theInputStream);
            object = theInput.readObject();
        }
        catch (IOException | ClassNotFoundException aException) {
            throw new HiddenException(aException);
        }
        finally {
            try {
                theInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                if (theInput != null) {
                    theInput.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (T)object;
    }
}

