/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Text;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnFactory;
import org.refcodes.tabular.FieldImpl;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.InputStreamRecords;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.RecordImpl;
import org.refcodes.tabular.TabularUtility;
import org.refcodes.textual.CsvBuilderImpl;
import org.refcodes.textual.CsvEscapeMode;

public class CsvInputStreamRecordsImpl<T>
implements InputStreamRecords<T> {
    private Header<T> _header = null;
    private BufferedReader _reader;
    private String _nextLine;
    private char _csvDelimiter;
    private int _line = -1;
    private boolean _isStrict;
    private long _erroneousRecordCount = 0L;

    public CsvInputStreamRecordsImpl(Header<T> aHeader, InputStream aCsvInputStream) throws IOException {
        this(aHeader, null, aCsvInputStream, Delimiter.CSV.getChar(), true);
    }

    public CsvInputStreamRecordsImpl(Header<T> aHeader, InputStream aCsvInputStream, boolean isStrict) throws IOException {
        this(aHeader, null, aCsvInputStream, Delimiter.CSV.getChar(), isStrict);
    }

    public CsvInputStreamRecordsImpl(Header<T> aHeader, InputStream aCsvInputStream, char aCsvDelimiter) throws IOException {
        this(aHeader, null, aCsvInputStream, aCsvDelimiter, true);
    }

    public CsvInputStreamRecordsImpl(Header<T> aHeader, InputStream aCsvInputStream, char aCsvDelimiter, boolean isStrict) throws IOException {
        this(aHeader, null, aCsvInputStream, aCsvDelimiter, isStrict);
    }

    public CsvInputStreamRecordsImpl(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, Delimiter.CSV.getChar(), true);
    }

    public CsvInputStreamRecordsImpl(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, boolean isStrict) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, Delimiter.CSV.getChar(), isStrict);
    }

    public CsvInputStreamRecordsImpl(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, char aCsvDelimiter) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, aCsvDelimiter, true);
    }

    public CsvInputStreamRecordsImpl(ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, char aCsvDelimiter, boolean isStrict) throws IOException {
        this(null, aColumnFactory, aCsvInputStream, aCsvDelimiter, isStrict);
    }

    protected CsvInputStreamRecordsImpl(Header<T> aHeader, ColumnFactory<T> aColumnFactory, InputStream aCsvInputStream, char aCsvDelimiter, boolean isStrict) throws IOException {
        this._isStrict = isStrict;
        this._reader = new BufferedReader(new InputStreamReader(aCsvInputStream));
        if (aHeader == null) {
            String theHeaderLine = this._reader.readLine();
            ++this._line;
            if (theHeaderLine != null) {
                List<String> theHeaderKeys = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withRecord(theHeaderLine).withDelimiterChar(aCsvDelimiter).toFields();
                this._header = TabularUtility.toHeader(theHeaderKeys, aColumnFactory);
            }
        } else {
            this._header = aHeader;
        }
        this._nextLine = this._reader.readLine();
        ++this._line;
        this._csvDelimiter = aCsvDelimiter;
    }

    @Override
    public boolean hasNext() {
        if (this._header == null) {
            return false;
        }
        return this._nextLine != null;
    }

    @Override
    public Record<T> next() {
        if (this._nextLine == null || this._header == null) {
            throw new NoSuchElementException("There is no more element beyond line <" + this._line + "> in this iterator.");
        }
        ArrayList theItems = new ArrayList();
        List<String> theValues = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withRecord(this._nextLine).withDelimiterChar(this._csvDelimiter).toFields();
        Object eValue = null;
        int theSize = this._header.size() <= theValues.size() ? this._header.size() : theValues.size();
        for (int i = 0; i < theSize; ++i) {
            Column eColumn;
            block19: {
                eValue = null;
                String eString = theValues.get(i);
                eColumn = (Column)this._header.get(i);
                try {
                    if (eColumn.getType().isArray()) {
                        List<String> eStringList = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withRecord(eString).withDelimiterChar(Delimiter.ARRAY.getChar()).toFields();
                        String[] eStringValues = eStringList.toArray(new String[eStringList.size()]);
                        eValue = eColumn.fromStorageStrings(eStringValues);
                    } else {
                        String eStringValue = eString;
                        eValue = eColumn.fromStorageString(eStringValue);
                    }
                }
                catch (ParseException e) {
                    ++this._erroneousRecordCount;
                    if (this._isStrict) {
                        throw new NoSuchElementException("A parse exception at line <" + this._line + "> occurred while parsing the value \"" + eString + "\" for key \"" + (String)eColumn.getKey() + "\" (type = " + eColumn.getType().getName() + ")\", the line is \"" + this._nextLine + "\": " + ExceptionUtility.toMessage(e));
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    ++this._erroneousRecordCount;
                    if (this._isStrict) {
                        throw new NoSuchElementException("An index out of bounds exception at line <" + this._line + "> occurred while parsing the value for key \"" + (String)eColumn.getKey() + "\" (type = " + eColumn.getType().getName() + "), the line is \"" + this._nextLine + "\": " + ExceptionUtility.toMessage(e));
                    }
                }
                catch (UnsupportedOperationException e) {
                    ++this._erroneousRecordCount;
                    if (this._isStrict) {
                        throw new NoSuchElementException("An unsupported operation exception at line <" + this._line + "> occurred while parsing the value for key \"" + (String)eColumn.getKey() + "\" (type = " + eColumn.getType().getName() + "), the line is \"" + this._nextLine + "\": " + ExceptionUtility.toMessage(e));
                    }
                }
                catch (NumberFormatException e) {
                    ++this._erroneousRecordCount;
                    if (this._isStrict) {
                        throw new NoSuchElementException("A number format exception exception at line <" + this._line + "> occurred while parsing the value for key \"" + (String)eColumn.getKey() + "\" (type = " + eColumn.getType().getName() + "), the line is \"" + this._nextLine + "\": " + ExceptionUtility.toMessage(e));
                    }
                }
                catch (Exception e) {
                    ++this._erroneousRecordCount;
                    if (!this._isStrict) break block19;
                    throw new NoSuchElementException("An exception of type \"" + e.getClass().getName() + "\" at line <" + this._line + "> occurred while parsing the value for key \"" + (String)eColumn.getKey() + "\" (type = " + eColumn.getType().getName() + "), the line is \"" + this._nextLine + "\": " + ExceptionUtility.toMessage(e));
                }
            }
            theItems.add(new FieldImpl<Object>((String)eColumn.getKey(), eValue));
        }
        RecordImpl theRecord = new RecordImpl(theItems);
        try {
            this._nextLine = this._reader.readLine();
            ++this._line;
        }
        catch (IOException e) {
            this._nextLine = null;
        }
        if (!this.hasNext()) {
            try {
                this._reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return theRecord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    @Override
    public Header<T> getHeader() {
        return this._header;
    }

    @Override
    public long getErroneousRecordCount() {
        return this._erroneousRecordCount;
    }
}

