/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.refcodes.data.Delimiter;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnFactory;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderImpl;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.RecordImpl;
import org.refcodes.tabular.Row;
import org.refcodes.time.DateFormats;

public final class TabularUtility {
    private TabularUtility() {
    }

    public static <T> Header<T> toHeader(String[] aColumnKeys, ColumnFactory<T> aColumnFactory) {
        return TabularUtility.toHeader(Arrays.asList(aColumnKeys), aColumnFactory);
    }

    public static <T> Header<T> toHeader(Collection<String> aColumnKeys, ColumnFactory<T> aColumnFactory) {
        Column[] theColumns = new Column[aColumnKeys.size()];
        Iterator<String> e = aColumnKeys.iterator();
        int i = 0;
        while (e.hasNext()) {
            theColumns[i] = aColumnFactory.createInstance(e.next());
            ++i;
        }
        return new HeaderImpl(theColumns);
    }

    public static Record<?> toPurged(Record<?> aRecord) {
        RecordImpl theRecord = new RecordImpl();
        for (String eKey : aRecord.keySet()) {
            Object eValue = aRecord.get(eKey);
            if (eValue == null) continue;
            if (eValue instanceof String) {
                if (((String)eValue).length() <= 0) continue;
                theRecord.put(eKey, eValue);
                continue;
            }
            theRecord.put(eKey, eValue);
        }
        return theRecord;
    }

    public static boolean isSubsetOf(Record<?> aRecord, Header<?> aSupersetOf) {
        if (aSupersetOf != null) {
            if (aSupersetOf.size() < aRecord.size()) {
                return false;
            }
            Column eColumn = null;
            Object eValue = null;
            for (String eKey : aRecord.keySet()) {
                if (!aSupersetOf.containsKey(eKey)) {
                    return false;
                }
                eColumn = (Column)aSupersetOf.get(eKey);
                eValue = aRecord.get(eKey);
                if (eColumn.getType().isAssignableFrom(eValue.getClass())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEqualWith(Record<?> aRecord, Header<?> aEquivalsWith) {
        if (aEquivalsWith != null) {
            if (aEquivalsWith.size() != aRecord.size()) {
                return false;
            }
            Column eColumn = null;
            Object eValue = null;
            for (String eKey : aRecord.keySet()) {
                if (!aEquivalsWith.containsKey(eKey)) {
                    return false;
                }
                eColumn = (Column)aEquivalsWith.get(eKey);
                eValue = aRecord.get(eKey);
                if (eColumn.getType().isAssignableFrom(eValue.getClass())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSupersetOf(Record<?> aRecord, Header<?> aSubsetOf) {
        if (aSubsetOf != null) {
            if (aSubsetOf.size() > aRecord.size()) {
                return false;
            }
            Object eValue = null;
            Column eColumn = null;
            for (String eKey : aSubsetOf.keySet()) {
                if (!aRecord.containsKey(eKey)) {
                    return false;
                }
                eColumn = (Column)aSubsetOf.get(eKey);
                eValue = aRecord.get(eKey);
                if (eColumn.getType().isAssignableFrom(eValue.getClass())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSubsetOf(Row<?> aRow, Header<?> aSupersetOf) {
        if (aSupersetOf != null) {
            if (aSupersetOf.size() < aRow.size()) {
                return false;
            }
            int theIndex = 0;
            Column eColumn = null;
            for (Object eValue : aRow) {
                eColumn = (Column)aSupersetOf.get(theIndex);
                if (!eColumn.getType().isAssignableFrom(eValue.getClass())) {
                    return false;
                }
                ++theIndex;
            }
        }
        return true;
    }

    public static boolean isEqualWith(Row<?> aRow, Header<?> aEquivalsWith) {
        if (aEquivalsWith.size() != aRow.size()) {
            return false;
        }
        int theIndex = 0;
        for (Object eValue : aRow) {
            Column eColumn = (Column)aEquivalsWith.get(theIndex);
            if (!eColumn.getType().isAssignableFrom(eValue.getClass())) {
                return false;
            }
            ++theIndex;
        }
        return true;
    }

    public static boolean isSupersetOf(Row<?> aRow, Header<?> aSubsetOf) {
        if (aSubsetOf != null) {
            if (aSubsetOf.size() > aRow.size()) {
                return false;
            }
            int theIndex = 0;
            Object eValue = null;
            for (Column column : aSubsetOf) {
                eValue = aRow.get(theIndex);
                if (!column.getType().isAssignableFrom(eValue.getClass())) {
                    return false;
                }
                ++theIndex;
            }
        }
        return true;
    }

    public static <T> Record<T> toIntersection(Record<T> aRecord, Header<?> aHeader) throws ColumnMismatchException {
        RecordImpl theRecord = new RecordImpl();
        for (Column column : aHeader) {
            if (!column.contains(aRecord)) continue;
            Object eValue = column.get(aRecord);
            theRecord.put(column.getKey(), eValue);
        }
        return theRecord;
    }

    public static <T> Record<T> toSubset(Record<T> aRecord, Header<?> aHeader) throws ColumnMismatchException {
        RecordImpl theRecord = new RecordImpl();
        for (Column column : aHeader) {
            Object eValue = null;
            if (column.contains(aRecord)) {
                eValue = column.get(aRecord);
            }
            theRecord.put(column.getKey(), eValue);
        }
        return theRecord;
    }

    public static String toString(Record<?> aRecord) {
        return TabularUtility.toString(aRecord, Delimiter.CSV.getChar(), DateFormats.DEFAULT_DATE_FORMATS.getDateFormats());
    }

    public static String toString(Record<?> aRecord, char aSeparator, DateTimeFormatter[] aDateFormats) {
        StringBuffer theBuffer = new StringBuffer();
        Iterator e = aRecord.keySet().iterator();
        while (e.hasNext()) {
            String eKey = (String)e.next();
            theBuffer.append(eKey);
            theBuffer.append('=');
            Object eValue = aRecord.get(eKey);
            if (eValue instanceof Date) {
                Instant theInstant = Instant.ofEpochMilli(((Date)eValue).getTime());
                theBuffer.append(aDateFormats[0].format(theInstant));
            } else if (eValue != null) {
                theBuffer.append(TabularUtility.toString(eValue));
            }
            if (!e.hasNext()) continue;
            theBuffer.append(aSeparator);
        }
        return theBuffer.toString();
    }

    public static String toSeparatedValues(Record<?> aRecord) {
        return TabularUtility.toSeparatedValues(aRecord, Delimiter.CSV.getChar());
    }

    public static String toSeparatedValues(Record<?> aRecord, char aDelimiter) {
        StringBuffer theBuffer = new StringBuffer();
        Iterator e = aRecord.keySet().iterator();
        while (e.hasNext()) {
            String eKey = (String)e.next();
            theBuffer.append(eKey);
            theBuffer.append('=');
            Object eValue = aRecord.get(eKey);
            if (eValue != null) {
                theBuffer.append(TabularUtility.toString(eValue));
            }
            if (!e.hasNext()) continue;
            theBuffer.append(aDelimiter);
        }
        return theBuffer.toString();
    }

    private static Object toString(Object aValue) {
        if (aValue instanceof Object[]) {
            Object[] theValues = (Object[])aValue;
            String[] theResult = new String[theValues.length];
            for (int i = 0; i < theValues.length; ++i) {
                theResult[i] = theValues[i].toString();
            }
            return theResult;
        }
        return aValue.toString();
    }
}

