/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.ArrayUtils;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.graphical.GraphicalUtility;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapImpl;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.AsciiArtBuilder;
import org.refcodes.textual.AsciiArtMode;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontImpl;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.FontType;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextBuilderImpl;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.PixmapRatioMode;
import org.refcodes.textual.TextLineBuilder;
import org.refcodes.textual.TextLineBuilderImpl;

public class AsciiArtBuilderImpl
extends AbstractText<AsciiArtBuilder>
implements AsciiArtBuilder {
    private Font _font = new FontImpl(FontType.SANS_SERIF, FontStyle.PLAIN, 16);
    private RgbPixmap _pixmap = null;
    private AsciiArtMode _asciiArtMode = AsciiArtMode.NORMAL;
    private PixmapRatioMode _pixmapRatioMode = PixmapRatioMode.NONE;
    private AsciiColorPalette _asciiColorPalette = AsciiColorPalette.HALFTONE_GRAY;
    private char[] _asciiColors = null;
    private int _columnWidth = -1;

    @Override
    public PixmapRatioMode getPixmapRatioMode() {
        return this._pixmapRatioMode;
    }

    @Override
    public void setPixmapRatioMode(PixmapRatioMode aPixmapRatioMode) {
        this._pixmapRatioMode = aPixmapRatioMode;
    }

    @Override
    public RgbPixmap getRgbPixmap() {
        return this._pixmap;
    }

    @Override
    public AsciiArtBuilder withColumnWidth(int aColumnWidth) {
        this.setColumnWidth(aColumnWidth);
        return this;
    }

    @Override
    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    @Override
    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    @Override
    public void setFont(Font aFont) {
        this._font = aFont;
    }

    @Override
    public AsciiArtBuilder withFont(Font aFont) {
        this.setFont(aFont);
        return this;
    }

    @Override
    public AsciiArtMode getAsciiArtMode() {
        return this._asciiArtMode;
    }

    @Override
    public void setAsciiArtMode(AsciiArtMode aAsciiArtMode) {
        this._asciiArtMode = aAsciiArtMode;
    }

    @Override
    public char[] getAsciiColors() {
        return this._asciiColors != null ? this._asciiColors : (char[])(this._asciiColorPalette != null ? this._asciiColorPalette.getPalette() : null);
    }

    @Override
    public void setAsciiColors(char ... aAsciiColors) {
        this._asciiColors = aAsciiColors;
        this._asciiColorPalette = null;
    }

    @Override
    public AsciiColorPalette getAsciiColorPalette() {
        return this._asciiColorPalette;
    }

    @Override
    public void setAsciiColorPalette(AsciiColorPalette aAsciiColorPalette) {
        this._asciiColorPalette = aAsciiColorPalette;
        this._asciiColors = null;
    }

    @Override
    public FontType getFontType() {
        return this._font != null ? this._font.getFontType() : null;
    }

    @Override
    public void setFontType(FontType aFontName) {
        if (this._font == null) {
            this._font = new FontImpl();
        }
        this._font.setFontType(aFontName);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontType(FontType aFontName) {
        this.setFontType(aFontName);
        return this;
    }

    @Override
    public FontStyle getFontStyle() {
        return this._font != null ? this._font.getFontStyle() : null;
    }

    @Override
    public void setFontStyle(FontStyle aFontStyle) {
        if (this._font == null) {
            this._font = new FontImpl();
        }
        this._font.setFontStyle(aFontStyle);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontStyle(FontStyle aFontStyle) {
        this.setFontStyle(aFontStyle);
        return this;
    }

    @Override
    public int getFontSize() {
        return this._font != null ? Integer.valueOf(this._font.getFontSize()) : null;
    }

    @Override
    public void setFontSize(int aFontSize) {
        if (this._font == null) {
            this._font = new FontImpl();
        }
        this._font.setFontSize(aFontSize);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontSize(int aFontSize) {
        this.setFontSize(aFontSize);
        return this;
    }

    @Override
    public String getFontName() {
        return this._font != null ? this._font.getFontName() : null;
    }

    @Override
    public void setFontName(String aFontName) {
        if (this._font == null) {
            this._font = new FontImpl();
        }
        this._font.setFontName(aFontName);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontName(String aFontName) {
        this.setFontName(aFontName);
        return this;
    }

    @Override
    public void setRgbPixmap(RgbPixmap aPixmap) {
        this._pixmap = aPixmap;
    }

    @Override
    public String[] toStrings() {
        if (this._pixmap != null) {
            return AsciiArtBuilderImpl.toAsciiArt(this._pixmap, this.getColumnWidth(), this.getAsciiColors(), this.getAsciiArtMode(), this.getPixmapRatioMode());
        }
        if (this.getText() != null) {
            return AsciiArtBuilderImpl.toAsciiArt(this.getText(), this._columnWidth, new java.awt.Font(this._font.getFontName(), this._font.getFontStyle().getFontStyleCode(), this._font.getFontSize()), this.getAsciiColors(), this._asciiArtMode);
        }
        throw new IllegalStateException("Cannot invoke the ASCII art generation as there is neither a text nor a pixmap being set.");
    }

    @Override
    public String[] toStrings(String ... aText) {
        return AsciiArtBuilderImpl.toAsciiArt(aText, this._columnWidth, new java.awt.Font(this._font.getFontName(), this._font.getFontStyle().getFontStyleCode(), this._font.getFontSize()), this.getAsciiColors(), this._asciiArtMode);
    }

    @Override
    public String toString(RgbPixmap aPixmap) {
        String theResult = "";
        String[] theStrings = this.toStrings(aPixmap);
        for (int i = 0; i < theStrings.length; ++i) {
            theResult = theResult + theStrings[i];
            if (i >= theStrings.length - 1) continue;
            theResult = theResult + SystemUtility.getLineBreak();
        }
        return theResult;
    }

    @Override
    public String[] toStrings(RgbPixmap aPixmap) {
        return AsciiArtBuilderImpl.toAsciiArt(aPixmap, this.getColumnWidth(), this.getAsciiColors(), this.getAsciiArtMode(), this.getPixmapRatioMode());
    }

    protected static String[] toAsciiArt(String[] aLines, int aWidth, String aFontName, int aFontStyle, int aFontSize, char[] aPalette, AsciiArtMode aAsciiArtMode) {
        ArrayList<String> theText = new ArrayList<String>();
        for (int i = 0; i < aLines.length; ++i) {
            String eLine = aLines[i];
            Collections.addAll(theText, AsciiArtBuilderImpl.toAsciiArt(eLine, aWidth, aFontName, aFontStyle, aFontSize, aPalette, aAsciiArtMode));
            if (i >= aLines.length - 1) continue;
            theText.add(((TextLineBuilder)new TextLineBuilderImpl().withLineChar(' ').withColumnWidth(((String)theText.get(0)).length())).toString());
        }
        return theText.toArray(new String[theText.size()]);
    }

    protected static String[] toAsciiArt(String[] aLines, int aWidth, java.awt.Font aFont, char[] aPalette, AsciiArtMode aAsciiArtMode) {
        ArrayList<String> theText = new ArrayList<String>();
        for (int i = 0; i < aLines.length; ++i) {
            String eLine = aLines[i];
            Collections.addAll(theText, AsciiArtBuilderImpl.toAsciiArt(eLine, aWidth, aFont, aPalette, aAsciiArtMode));
            if (i >= aLines.length - 1) continue;
            theText.add(((TextLineBuilder)new TextLineBuilderImpl().withLineChar(' ').withColumnWidth(((String)theText.get(0)).length())).toString());
        }
        return theText.toArray(new String[theText.size()]);
    }

    protected static String[] toAsciiArt(String aText, int aWidth, String aFontName, int aFontStyle, int aFontSize, char[] aPalette, AsciiArtMode aAsciiArtMode) {
        switch (aAsciiArtMode) {
            case NORMAL: {
                if (aWidth != -1) {
                    return AsciiArtBuilderImpl.toAsciiArt(aText, aWidth, aFontName, aFontStyle, aPalette);
                }
                if (aWidth == -1 && aFontSize == -1) {
                    return AsciiArtBuilderImpl.toAsciiArt(aText, SystemUtility.toConsoleWidth(), aFontName, aFontStyle, aPalette);
                }
                return AsciiArtBuilderImpl.toAsciiArt(aText, new java.awt.Font(aFontName, aFontStyle, aFontSize), aPalette);
            }
            case INVERSE: {
                if (aWidth != -1) {
                    return AsciiArtBuilderImpl.toInverseAsciiArt(aText, aWidth, aFontName, aFontStyle, aPalette);
                }
                if (aWidth == -1 && aFontSize == -1) {
                    return AsciiArtBuilderImpl.toInverseAsciiArt(aText, SystemUtility.toConsoleWidth(), aFontName, aFontStyle, aPalette);
                }
                return AsciiArtBuilderImpl.toInverseAsciiArt(aText, new java.awt.Font(aFontName, aFontStyle, aFontSize), aPalette);
            }
        }
        throw new IllegalArgumentException("You must pass a valid ASCII art mode, though you actually passed <" + (Object)((Object)aAsciiArtMode) + ">!");
    }

    protected static String[] toAsciiArt(String aText, int aWidth, java.awt.Font aFont, char[] aPalette, AsciiArtMode aAsciiArtMode) {
        switch (aAsciiArtMode) {
            case NORMAL: {
                if (aWidth != -1) {
                    return AsciiArtBuilderImpl.toAsciiArt(aText, aWidth, aFont, aPalette);
                }
                if (aWidth == -1 && aFont.getSize() == -1) {
                    return AsciiArtBuilderImpl.toAsciiArt(aText, SystemUtility.toConsoleWidth(), aFont, aPalette);
                }
                return AsciiArtBuilderImpl.toAsciiArt(aText, aFont, aPalette);
            }
            case INVERSE: {
                if (aWidth != -1) {
                    return AsciiArtBuilderImpl.toInverseAsciiArt(aText, aWidth, aFont, aPalette);
                }
                if (aWidth == -1 && aFont.getSize() == -1) {
                    return AsciiArtBuilderImpl.toInverseAsciiArt(aText, SystemUtility.toConsoleWidth(), aFont, aPalette);
                }
                return AsciiArtBuilderImpl.toInverseAsciiArt(aText, aFont, aPalette);
            }
        }
        throw new IllegalArgumentException("You must pass a valid ASCII art mode, though you actually passed <" + (Object)((Object)aAsciiArtMode) + ">!");
    }

    protected static String[] toAsciiArt(RgbPixmap aPixmap, int aColumnWidth, char[] aPalette, AsciiArtMode aAsciiArtMode, PixmapRatioMode aPixmapRatioMode) {
        int theWidth;
        RgbPixmap thePixmap = aPixmap;
        int n = theWidth = aColumnWidth == -1 ? aPixmap.getPixmapWidth() : aColumnWidth;
        if (theWidth != aPixmap.getPixmapWidth() || aPixmapRatioMode != PixmapRatioMode.NONE) {
            BufferedImage theBufferedImage = new BufferedImage(aPixmap.getPixmapWidth(), aPixmap.getPixmapHeight(), 6);
            for (int x = 0; x < aPixmap.getPixmapWidth(); ++x) {
                for (int y = 0; y < aPixmap.getPixmapHeight(); ++y) {
                    theBufferedImage.setRGB(x, y, ((RgbPixel)aPixmap.getPixelAt(x, y)).toRgbValue());
                }
            }
            int theHeight = aPixmap.getPixmapHeight();
            if (aPixmapRatioMode != PixmapRatioMode.NONE) {
                theHeight = Math.round((float)theWidth / (float)aPixmap.getPixmapWidth() * (float)aPixmap.getPixmapHeight() * aPixmapRatioMode.getRatio());
            }
            Image theScaledImage = theBufferedImage.getScaledInstance(theWidth, theHeight, 4);
            theBufferedImage = new BufferedImage(theWidth, theHeight, 6);
            theBufferedImage.getGraphics().drawImage(theScaledImage, 0, 0, new Color(0, 0, 0), null);
            RgbPixmapImpl.RgbPixmapPropertyBuilderImpl theScaledPixmap = new RgbPixmapImpl.RgbPixmapPropertyBuilderImpl(theWidth, theHeight);
            for (int x = 0; x < theScaledPixmap.getPixmapWidth(); ++x) {
                for (int y = 0; y < theScaledPixmap.getPixmapHeight(); ++y) {
                    theScaledPixmap.setPixelAt(theBufferedImage.getRGB(x, y), x, y);
                }
            }
            thePixmap = theScaledPixmap;
        }
        switch (aAsciiArtMode) {
            case NORMAL: {
                return AsciiArtBuilderImpl.toAsciiArt(thePixmap, aPalette);
            }
            case INVERSE: {
                return AsciiArtBuilderImpl.toInverseAsciiArt(thePixmap, aPalette);
            }
        }
        throw new IllegalArgumentException("You must pass a valid ASCII art mode, though you actually passed <" + (Object)((Object)aAsciiArtMode) + ">!");
    }

    protected static String[] toAsciiArt(RgbPixmap aPixmap, char[] aPalette) {
        String[] theAsciiArt = new String[aPixmap.getPixmapHeight()];
        for (int y = 0; y < aPixmap.getPixmapHeight(); ++y) {
            theAsciiArt[y] = "";
            for (int x = 0; x < aPixmap.getPixmapWidth(); ++x) {
                int n = y;
                theAsciiArt[n] = theAsciiArt[n] + AsciiArtBuilderImpl.toAscii(((RgbPixel)aPixmap.getPixelAt(x, y)).toRgbValue(), aPalette);
            }
        }
        return theAsciiArt;
    }

    protected static String[] toInverseAsciiArt(RgbPixmap aPixmap, char[] aPalette) {
        char[] thePalette = ArrayUtils.clone(aPalette);
        ArrayUtils.reverse(thePalette);
        return AsciiArtBuilderImpl.toAsciiArt(aPixmap, thePalette);
    }

    protected static String[] toAsciiArt(String aText, int aWidth, String aFontName, int aFontStyle, char[] aPalette) {
        String[] theLines = AsciiArtBuilderImpl.toAsciiArt(aText, GraphicalUtility.getFont(aText, aWidth, aFontName, aFontStyle), aPalette);
        for (int i = 0; i < theLines.length; ++i) {
            if (theLines[i].length() == aWidth) continue;
            theLines[i] = ((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(new String[]{theLines[i]})).withColumnWidth(aWidth)).withFillChar(aPalette[0]).toString();
        }
        return theLines;
    }

    protected static String[] toAsciiArt(String aText, int aWidth, java.awt.Font aFont, char[] aPalette) {
        String[] theLines = AsciiArtBuilderImpl.toAsciiArt(aText, aWidth, aFont.getFontName(), aFont.getStyle(), aPalette);
        for (int i = 0; i < theLines.length; ++i) {
            if (theLines[i].length() == aWidth) continue;
            theLines[i] = ((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(new String[]{theLines[i]})).withColumnWidth(aWidth)).withFillChar(aPalette[0]).toString();
        }
        return theLines;
    }

    protected static String[] toInverseAsciiArt(String aText, int aWidth, String aFontName, int aFontStyle, char[] aPalette) {
        char[] thePalette = ArrayUtils.clone(aPalette);
        ArrayUtils.reverse(thePalette);
        return AsciiArtBuilderImpl.toAsciiArt(aText, aWidth, aFontName, aFontStyle, thePalette);
    }

    protected static String[] toInverseAsciiArt(String aText, int aWidth, java.awt.Font aFont, char[] aPalette) {
        char[] thePalette = ArrayUtils.clone(aPalette);
        ArrayUtils.reverse(thePalette);
        return AsciiArtBuilderImpl.toAsciiArt(aText, aWidth, aFont, thePalette);
    }

    protected static String[] toAsciiArt(String aText, int aWidth, String aFontName, int aFontStyle) {
        return AsciiArtBuilderImpl.toAsciiArt(aText, aWidth, aFontName, aFontStyle, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
    }

    protected static String[] toInverseAsciiArt(String aText, int aWidth, String aFontName, int aFontStyle) {
        char[] thePalette = ArrayUtils.clone(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        ArrayUtils.reverse(thePalette);
        return AsciiArtBuilderImpl.toAsciiArt(aText, aWidth, aFontName, aFontStyle, thePalette);
    }

    protected static String[] toAsciiArt(String aText, java.awt.Font aFont) {
        return AsciiArtBuilderImpl.toAsciiArt(aText, aFont, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
    }

    protected static String[] toInverseAsciiArt(String aText, java.awt.Font aFont) {
        char[] thePalette = ArrayUtils.clone(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
        ArrayUtils.reverse(thePalette);
        return AsciiArtBuilderImpl.toAsciiArt(aText, aFont, thePalette);
    }

    protected static String[] toAsciiArt(String aText, java.awt.Font aFont, char[] aPalette) {
        int theImageType = 10;
        BufferedImage theImage = new BufferedImage(1, 1, theImageType);
        Graphics theGraphics = theImage.getGraphics();
        theGraphics.setFont(aFont);
        FontMetrics theFontMetrics = theGraphics.getFontMetrics();
        int theWidth = theFontMetrics.stringWidth(aText);
        int theHeight = theFontMetrics.getAscent() + theFontMetrics.getHeight() + theFontMetrics.getDescent();
        theImage = new BufferedImage(theWidth, theHeight, theImageType);
        theGraphics = theImage.getGraphics();
        theGraphics.setFont(aFont);
        Graphics2D theGraphics2d = (Graphics2D)theGraphics;
        theGraphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        theGraphics2d.drawString(aText, 0, theHeight - theFontMetrics.getDescent());
        ArrayList<String> theLines = new ArrayList<String>();
        int theTrimBegin = theWidth;
        int theTrimEnd = 0;
        block0: for (int y = 0; y < theHeight; ++y) {
            int i;
            StringBuilder theBuffer = new StringBuilder();
            for (int x = 0; x < theWidth; ++x) {
                char eAsciiChar = AsciiArtBuilderImpl.toAscii(theImage.getRGB(x, y), aPalette);
                theBuffer.append(eAsciiChar);
            }
            String eLine = theBuffer.toString();
            if (eLine.trim().isEmpty() || AsciiArtBuilderImpl.isObsolete(eLine)) continue;
            theLines.add(eLine);
            for (i = 0; i < eLine.length(); ++i) {
                if (eLine.charAt(i) == ' ' || i >= theTrimBegin) continue;
                theTrimBegin = i;
                break;
            }
            for (i = eLine.length() - 1; i >= 0; --i) {
                if (eLine.charAt(i) == ' ' || i <= theTrimEnd) continue;
                theTrimEnd = i;
                continue block0;
            }
        }
        if (theTrimBegin == 0 && theTrimEnd == theWidth - 1) {
            return theLines.toArray(new String[theLines.size()]);
        }
        String[] theResult = new String[theLines.size()];
        for (int i = 0; i < theLines.size(); ++i) {
            theResult[i] = ((String)theLines.get(i)).substring(theTrimBegin, theTrimEnd + 1);
        }
        return theResult;
    }

    static boolean isObsolete(String aLine) {
        if (aLine == null || aLine.length() == 0) {
            return true;
        }
        char theChar = aLine.charAt(0);
        for (int i = 1; i < aLine.length(); ++i) {
            if (aLine.charAt(i) == theChar) continue;
            return false;
        }
        return true;
    }

    protected static String[] toInverseAsciiArt(String aText, java.awt.Font aFont, char[] aPalette) {
        char[] thePalette = ArrayUtils.clone(aPalette);
        ArrayUtils.reverse(thePalette);
        return AsciiArtBuilderImpl.toAsciiArt(aText, aFont, thePalette);
    }

    protected static char toAscii(int aRgbValue, char[] aPalette) {
        float theFactor = 256.0f / (float)aPalette.length;
        float theIndex = (float)GraphicalUtility.toGray(aRgbValue) / theFactor;
        int eGrayIndex = (int)theIndex;
        char theAsciiChar = aPalette[eGrayIndex];
        return theAsciiChar;
    }

    protected static char toAscii(int aRgbValue) {
        return AsciiArtBuilderImpl.toAscii(aRgbValue, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
    }
}

