/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.refcodes.data.Delimiter;
import org.refcodes.textual.CsvBuilder;
import org.refcodes.textual.CsvEscapeMode;

public class CsvBuilderImpl
implements CsvBuilder {
    private String _record = null;
    private Collection<Object> _fields = null;
    private char _delimiterChar = Delimiter.CSV.getChar();
    private CsvEscapeMode _csvEscapeMode = CsvEscapeMode.ESCAPED;

    @Override
    public CsvEscapeMode getCsvEscapeMode() {
        return this._csvEscapeMode;
    }

    @Override
    public void setCsvEscapeMode(CsvEscapeMode aCsvEscapeMode) {
        this._csvEscapeMode = aCsvEscapeMode;
    }

    @Override
    public void setRecord(String aRecord) {
        this._record = aRecord;
    }

    @Override
    public String getRecord() {
        return this._record;
    }

    @Override
    public void setFields(Object ... aFields) {
        this._fields = CsvBuilderImpl.toCollection(aFields);
    }

    @Override
    public Collection<Object> getFields() {
        return this._fields;
    }

    @Override
    public void setFields(Collection<Object> aFields) {
        this._fields = aFields;
    }

    @Override
    public char getDelimiterChar() {
        return this._delimiterChar;
    }

    @Override
    public void setDelimiterChar(char aDelimiterChar) {
        this._delimiterChar = aDelimiterChar;
    }

    @Override
    public List<String> toFields() throws IllegalStateException {
        return CsvBuilderImpl.fromSeparatedValues(this._record, this._delimiterChar, this._csvEscapeMode);
    }

    @Override
    public String toRecord() throws IllegalStateException {
        return CsvBuilderImpl.toSeparatedValues(this._fields, this._delimiterChar, this._csvEscapeMode);
    }

    @Override
    public String toRecord(Object ... aFields) {
        return CsvBuilderImpl.toSeparatedValues(CsvBuilderImpl.toCollection(aFields), this._delimiterChar, this._csvEscapeMode);
    }

    @Override
    public String toRecord(Collection<Object> aFields) {
        return CsvBuilderImpl.toSeparatedValues(aFields, this._delimiterChar, this._csvEscapeMode);
    }

    @Override
    public String[] toStrings() throws IllegalStateException {
        List<String> theCsvElements = this.toFields();
        return theCsvElements.toArray(new String[theCsvElements.size()]);
    }

    @Override
    public String toRecord(String ... aFields) throws IllegalStateException {
        return CsvBuilderImpl.toSeparatedValues(CsvBuilderImpl.toCollection(aFields), this._delimiterChar, this._csvEscapeMode);
    }

    @Override
    public String[] toStrings(String aRecord) {
        List<String> theCsvElements = CsvBuilderImpl.fromSeparatedValues(aRecord, this._delimiterChar, this._csvEscapeMode);
        return theCsvElements.toArray(new String[theCsvElements.size()]);
    }

    @Override
    public String toString() throws IllegalStateException {
        return this.toRecord();
    }

    protected static List<String> fromSeparatedValues(String aRecord, char aDelimiter, CsvEscapeMode aCsvEscapeMode) {
        switch (aCsvEscapeMode) {
            case ESCAPED: {
                return CsvBuilderImpl.fromSeparatedValues(aRecord, aDelimiter);
            }
            case NONE: {
                return CsvBuilderImpl.fromSplitValues(aRecord, aDelimiter);
            }
        }
        throw new IllegalArgumentException("You must pass a valid text overwrite mode, though you actually passed <" + (Object)((Object)aCsvEscapeMode) + ">!");
    }

    protected static String toSeparatedValues(Collection<Object> aFields, char aDelimiter, CsvEscapeMode aCsvEscapeMode) {
        switch (aCsvEscapeMode) {
            case ESCAPED: {
                return CsvBuilderImpl.toSeparatedValues(aFields, aDelimiter);
            }
            case NONE: {
                return CsvBuilderImpl.toSplitValues(aFields, aDelimiter);
            }
        }
        throw new IllegalArgumentException("You must pass a valid text overwrite mode, though you actually passed <" + (Object)((Object)aCsvEscapeMode) + ">!");
    }

    protected static String toSeparatedValues(Collection<?> aCollection) {
        return CsvBuilderImpl.toSeparatedValues(aCollection, Delimiter.CSV.getChar());
    }

    protected static String toSeparatedValues(Collection<?> aCollection, char aDelimiter) {
        StringBuffer theBuffer = new StringBuffer();
        String eItemString = null;
        Object eItem = null;
        Iterator<?> e = aCollection.iterator();
        while (e.hasNext()) {
            eItem = e.next();
            if (eItem != null) {
                eItemString = CsvBuilderImpl.toSeparatedValue(eItem, aDelimiter);
                theBuffer.append(eItemString);
            }
            if (!e.hasNext()) continue;
            theBuffer.append(aDelimiter);
        }
        return theBuffer.toString();
    }

    protected static String toSeparatedValue(Object aValue) {
        return CsvBuilderImpl.toSeparatedValue(aValue, Delimiter.CSV.getChar());
    }

    protected static String toSeparatedValue(Object aValue, char aDelimiter) {
        char aInnerDelimeter = aDelimiter != Delimiter.ARRAY.getChar() ? Delimiter.ARRAY.getChar() : Delimiter.LIST.getChar();
        if (aValue instanceof String[]) {
            aValue = CsvBuilderImpl.toSeparatedValues((String[])aValue, aInnerDelimeter);
        } else if (aValue instanceof Object[]) {
            Object[] eItems = (Object[])aValue;
            Object[] eStringItems = new String[eItems.length];
            for (int i = 0; i < eItems.length; ++i) {
                eStringItems[i] = eItems[i] != null ? eItems[i].toString() : null;
            }
            aValue = CsvBuilderImpl.toSeparatedValues(eStringItems, aInnerDelimeter);
        }
        String eItemString = aValue.toString();
        if (eItemString.indexOf(aDelimiter) != -1 || eItemString.indexOf("\"") != -1) {
            eItemString = eItemString.replaceAll("\"", "\"\"");
            eItemString = "\"" + eItemString + "\"";
        }
        return eItemString;
    }

    protected static List<String> fromSeparatedValues(String aSeparatedValues) {
        return CsvBuilderImpl.fromSeparatedValues(aSeparatedValues, Delimiter.CSV.getChar());
    }

    protected static List<String> fromSeparatedValues(String aSeparatedValues, char aDelimiter) {
        ArrayList<String> theInputList = new ArrayList<String>();
        String[] theItems = aSeparatedValues.split(CsvBuilderImpl.toEscapedRegexp(aDelimiter));
        ArrayList<String> theTokens = new ArrayList<String>();
        while (aSeparatedValues.startsWith("" + aDelimiter)) {
            theTokens.add("");
            aSeparatedValues = aSeparatedValues.substring(1);
        }
        for (int i = 0; i < theItems.length; ++i) {
            if (theItems[i].equals("\"\"")) {
                theTokens.add("");
                continue;
            }
            theTokens.add(theItems[i].replaceAll("\"\"", "\""));
        }
        while (aSeparatedValues.endsWith("" + aDelimiter)) {
            theTokens.add("");
            aSeparatedValues = aSeparatedValues.substring(0, aSeparatedValues.length() - 1);
        }
        String ePreviousItem = null;
        for (String eToken : theTokens) {
            if (!theInputList.isEmpty()) {
                ePreviousItem = (String)theInputList.get(theInputList.size() - 1);
                if (ePreviousItem.startsWith("\"") && !ePreviousItem.endsWith("\"")) {
                    theInputList.remove(theInputList.size() - 1);
                    theInputList.add(ePreviousItem + aDelimiter + eToken);
                    continue;
                }
                theInputList.add(eToken);
                continue;
            }
            theInputList.add(eToken);
        }
        ArrayList<String> theOutputList = new ArrayList<String>();
        for (String eItem : theInputList) {
            if (eItem.length() > 1 && eItem.startsWith("\"") && eItem.endsWith("\"")) {
                eItem = eItem.substring(1, eItem.length() - 1);
            }
            eItem.replaceAll("\"\"", "\"");
            theOutputList.add(eItem.length() == 0 ? null : eItem);
        }
        return theOutputList;
    }

    protected static String toSplitValues(Object[] aArray) {
        return CsvBuilderImpl.toSplitValues(aArray, Delimiter.CSV.getChar());
    }

    protected static String toSplitValues(Object[] aArray, char aDelimiter) {
        ArrayList theList = new ArrayList();
        Collections.addAll(theList, aArray);
        return CsvBuilderImpl.toSplitValues(theList, aDelimiter);
    }

    protected static String toSplitValues(Collection<?> aCollection) {
        return CsvBuilderImpl.toSplitValues(aCollection, Delimiter.CSV.getChar());
    }

    protected static String toSplitValues(Collection<?> aCollection, char aDelimiter) {
        StringBuffer theBuffer = new StringBuffer();
        String eItemString = null;
        Object eItem = null;
        Iterator<?> e = aCollection.iterator();
        while (e.hasNext()) {
            eItem = e.next();
            if (eItem != null) {
                eItemString = CsvBuilderImpl.toSplitValue(eItem, aDelimiter);
                theBuffer.append(eItemString);
            }
            if (!e.hasNext()) continue;
            theBuffer.append(aDelimiter);
        }
        return theBuffer.toString();
    }

    protected static String toSplitValue(Object aValue, char aDelimiter) {
        char aInnerDelimeter = aDelimiter != Delimiter.ARRAY.getChar() ? Delimiter.ARRAY.getChar() : Delimiter.LIST.getChar();
        if (aValue instanceof String[]) {
            aValue = CsvBuilderImpl.toSplitValues((String[])aValue, aInnerDelimeter);
        } else if (aValue instanceof Object[]) {
            Object[] eItems = (Object[])aValue;
            Object[] eStringItems = new String[eItems.length];
            for (int i = 0; i < eItems.length; ++i) {
                eStringItems[i] = eItems[i] != null ? eItems[i].toString() : null;
            }
            aValue = CsvBuilderImpl.toSplitValues(eStringItems, aInnerDelimeter);
        }
        return aValue.toString();
    }

    protected static List<String> fromSplitValues(String aSplitValues) {
        return CsvBuilderImpl.fromSplitValues(aSplitValues, Delimiter.CSV.getChar());
    }

    protected static List<String> fromSplitValues(String aSplitValues, char aDelimiter) {
        return Arrays.asList(aSplitValues.split(CsvBuilderImpl.toEscapedRegexp(aDelimiter)));
    }

    protected static List<String> fromSplitValues(String aValues, String aDelimiters) {
        StringTokenizer theStringTokenizer = new StringTokenizer(aValues, aDelimiters);
        ArrayList<String> theList = new ArrayList<String>();
        while (theStringTokenizer.hasMoreTokens()) {
            theList.add(theStringTokenizer.nextToken());
        }
        return theList;
    }

    protected static String toSeparatedValues(Object[] aArray) {
        return CsvBuilderImpl.toSeparatedValues(aArray, Delimiter.CSV.getChar());
    }

    protected static String toSeparatedValues(Object[] aArray, char aDelimiter) {
        ArrayList theList = new ArrayList();
        Collections.addAll(theList, aArray);
        return CsvBuilderImpl.toSeparatedValues(theList, aDelimiter);
    }

    private static Collection<Object> toCollection(Object[] aFields) {
        if (aFields.length == 1 && aFields[0] instanceof Collection) {
            return (Collection)aFields[0];
        }
        return Arrays.asList(aFields);
    }

    protected static String toEscapedRegexp(char aDelimiter) {
        return ("" + aDelimiter).replaceAll("\\.", "\\\\.").replaceAll("\\|", "\\\\|");
    }
}

