/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.Literal;
import org.refcodes.data.Truncate;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.MoreTextBuilder;
import org.refcodes.textual.MoreTextMode;

public class MoreTextBuilderImpl
extends AbstractText<MoreTextBuilder>
implements MoreTextBuilder {
    private int _columnWidth = SystemUtility.toConsoleWidth();
    private MoreTextMode _moreTextMode = MoreTextMode.RIGHT;
    private String _moreText = "" + Truncate.MORE_TEXT_BEFORE.getChar();

    @Override
    public String getMoreText() {
        return this._moreText;
    }

    @Override
    public void setMoreText(String aMoreText) {
        this._moreText = aMoreText;
    }

    @Override
    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    @Override
    public MoreTextBuilder withColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
        return this;
    }

    @Override
    public MoreTextMode getMoreTextMode() {
        return this._moreTextMode;
    }

    @Override
    public void setMoreTextMode(MoreTextMode aMoreTextMode) {
        this._moreTextMode = aMoreTextMode;
    }

    @Override
    public String[] toStrings() {
        return MoreTextBuilderImpl.toMore(this.getText(), this._columnWidth, this._moreText, this._moreTextMode);
    }

    @Override
    public String[] toStrings(String ... aText) {
        return MoreTextBuilderImpl.toMore(aText, this._columnWidth, this._moreText, this._moreTextMode);
    }

    protected static String[] toMore(String[] aText, int aLength, String aMore, MoreTextMode aMoreTextMode) {
        String[] theResult = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theResult[i] = MoreTextBuilderImpl.toMore(aText[i], aLength, aMore, aMoreTextMode);
        }
        return theResult;
    }

    protected static String toMore(String aText, int aLength, String aMore, MoreTextMode aMoreTextMode) {
        switch (aMoreTextMode) {
            case LEFT: {
                return MoreTextBuilderImpl.toMoreLeft(aText, aLength, aMore);
            }
            case CENTER: {
                return MoreTextBuilderImpl.toMoreCenter(aText, aLength, aMore);
            }
            case RIGHT: {
                return MoreTextBuilderImpl.toMoreRight(aText, aLength, aMore);
            }
        }
        return aText;
    }

    protected static String toMoreLeft(String aText, int aLength, String aMore) {
        if (aText == null) {
            aText = Literal.NULL.getName();
        }
        if (aMore.length() > aLength && aText.length() > aLength) {
            return aMore.substring(0, aLength);
        }
        if (aText.length() <= aLength) {
            return aText;
        }
        aText = aText.substring(aText.length() - aLength + aMore.length());
        return aMore + aText;
    }

    protected static String toMoreRight(String aText, int aLength, String aMore) {
        if (aMore.length() > aLength && aText.length() > aLength) {
            return aMore.substring(0, aLength);
        }
        if (aText.length() <= aLength) {
            return aText;
        }
        aText = aText.substring(0, aLength - aMore.length());
        return aText + aMore;
    }

    protected static String toMoreCenter(String aText, int aLength, String aMore) {
        if (aMore.length() > aLength && aText.length() > aLength) {
            return aMore.substring(0, aLength);
        }
        if (aText.length() <= aLength) {
            return aText;
        }
        if ((aText = aText.substring(0, aText.length() - aMore.length())).length() - aMore.length() == aLength) {
            return aText + aMore;
        }
        while (aText.length() + aMore.length() * 2 > aLength) {
            if ((aText = aText.substring(aMore.length())).length() + aMore.length() * 2 == aLength) {
                return aMore + aText + aMore;
            }
            if ((aText = aText.substring(0, aText.length() - aMore.length())).length() + aMore.length() * 2 != aLength) continue;
            return aMore + aText + aMore;
        }
        return aMore + aText + aMore;
    }
}

