/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.refcodes.data.Text;
import org.refcodes.textual.VerboseTextBuilder;

public class VerboseTextBuilderImpl
implements VerboseTextBuilder {
    private Collection<Object> _collection = null;
    private Map<Object, Object> _map = null;

    @Override
    public Object[] getElements() {
        return this._collection.toArray();
    }

    @Override
    public void setElements(Object[] aElements) {
        this._collection = new ArrayList<Object>();
        this._map = null;
        for (Object eElement : aElements) {
            this._collection.add(eElement);
        }
    }

    @Override
    public void setElements(Collection<?> aElements) {
        this._collection = aElements;
    }

    @Override
    public void setElements(Map<?, ?> aElements) {
        this._collection = null;
        this._map = aElements;
    }

    @Override
    public String toString() {
        if (this._collection != null) {
            return VerboseTextBuilderImpl.toVerboseString(this._collection);
        }
        if (this._map != null) {
            return VerboseTextBuilderImpl.toVerboseString(this._map);
        }
        return Text.NULL_VALUE.getText();
    }

    @Override
    public String toString(Boolean[] aElements) {
        return VerboseTextBuilderImpl.toVerboseString(Arrays.asList(aElements));
    }

    @Override
    public String toString(Byte[] aElements) {
        return VerboseTextBuilderImpl.toVerboseString(Arrays.asList(aElements));
    }

    @Override
    public String toString(Short[] aElements) {
        return VerboseTextBuilderImpl.toVerboseString(Arrays.asList(aElements));
    }

    @Override
    public String toString(Integer[] aElements) {
        return VerboseTextBuilderImpl.toVerboseString(Arrays.asList(aElements));
    }

    @Override
    public String toString(Long[] aElements) {
        return VerboseTextBuilderImpl.toVerboseString(Arrays.asList(aElements));
    }

    @Override
    public String toString(Float[] aElements) {
        return VerboseTextBuilderImpl.toVerboseString(Arrays.asList(aElements));
    }

    @Override
    public String toString(Double[] aElements) {
        return VerboseTextBuilderImpl.toVerboseString(Arrays.asList(aElements));
    }

    @Override
    public String toString(Character[] aElements) {
        return VerboseTextBuilderImpl.toVerboseString(Arrays.asList(aElements));
    }

    @Override
    public String toString(String[] aElements) {
        return VerboseTextBuilderImpl.toVerboseString(Arrays.asList(aElements));
    }

    @Override
    public String toString(Object[] aElements) {
        return VerboseTextBuilderImpl.toVerboseString(Arrays.asList(aElements));
    }

    @Override
    public String toString(Collection<?> aElements) {
        return VerboseTextBuilderImpl.toVerboseString(aElements);
    }

    @Override
    public String toString(Map<?, ?> aElements) {
        return VerboseTextBuilderImpl.toVerboseString(aElements);
    }

    @Override
    public String toString(Object aElements) {
        if (aElements.getClass().isArray()) {
            return this.toString((Object[])aElements);
        }
        if (aElements instanceof Collection) {
            return this.toString((Collection)aElements);
        }
        if (aElements instanceof Map) {
            return this.toString((Map)aElements);
        }
        return this.toString(new Object[]{aElements});
    }

    protected static String toVerboseString(Collection<?> aCollection) {
        if (aCollection.size() == 0) {
            return "{}";
        }
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append("{ ");
        Iterator<?> e = aCollection.iterator();
        while (e.hasNext()) {
            Object eValue = e.next();
            if (eValue instanceof String) {
                theBuffer.append("\"" + eValue + "\"");
            } else {
                theBuffer.append(eValue);
            }
            if (!e.hasNext()) continue;
            theBuffer.append(", ");
        }
        theBuffer.append(" }");
        return theBuffer.toString();
    }

    protected static String toVerboseString(Map<?, ?> aMap) {
        if (aMap.size() == 0) {
            return "{}";
        }
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append("{\n");
        Iterator<?> e = aMap.keySet().iterator();
        while (e.hasNext()) {
            Object eKey = e.next();
            Object eValue = aMap.get(eKey);
            if (eValue != null && eValue.getClass().isArray()) {
                eValue = eValue instanceof byte[] ? new VerboseTextBuilderImpl().withElements((byte[])eValue).toString() : (eValue instanceof short[] ? new VerboseTextBuilderImpl().withElements((short[])eValue).toString() : (eValue instanceof int[] ? new VerboseTextBuilderImpl().withElements((int[])eValue).toString() : (eValue instanceof long[] ? new VerboseTextBuilderImpl().withElements((long[])eValue).toString() : (eValue instanceof float[] ? new VerboseTextBuilderImpl().withElements((float[])eValue).toString() : (eValue instanceof double[] ? new VerboseTextBuilderImpl().withElements((double[])eValue).toString() : (eValue instanceof boolean[] ? new VerboseTextBuilderImpl().withElements((boolean[])eValue).toString() : (eValue instanceof char[] ? new VerboseTextBuilderImpl().withElements((char[])eValue).toString() : new VerboseTextBuilderImpl().withElements((Object[])eValue).toString())))))));
                theBuffer.append("  " + eKey + " = " + eValue);
            } else if (eValue instanceof String) {
                theBuffer.append("  " + eKey + " = \"" + eValue + "\"");
            } else {
                theBuffer.append("  " + eKey + " = " + eValue);
            }
            if (e.hasNext()) {
                theBuffer.append(',');
            }
            theBuffer.append('\n');
        }
        theBuffer.append("}");
        return theBuffer.toString();
    }
}

