// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.command;

import org.refcodes.command.CommandRuntimeException.CommandCommandRuntimeException;

/**
 * The Class NoResultAvailableRuntimeException.
 */
public class NoResultAvailableRuntimeException extends CommandCommandRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new no result available runtime exception.
	 *
	 * @param aCommand the command
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public NoResultAvailableRuntimeException( Undoable<?, ?, ?> aCommand, String aMessage, String aErrorCode ) {
		super( aCommand, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new no result available runtime exception.
	 *
	 * @param aCommand the command
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public NoResultAvailableRuntimeException( Undoable<?, ?, ?> aCommand, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aCommand, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new no result available runtime exception.
	 *
	 * @param aCommand the command
	 * @param message the message
	 * @param cause the cause
	 */
	public NoResultAvailableRuntimeException( Undoable<?, ?, ?> aCommand, String message, Throwable cause ) {
		super( aCommand, message, cause );
	}

	/**
	 * Instantiates a new no result available runtime exception.
	 *
	 * @param aCommand the command
	 * @param message the message
	 */
	public NoResultAvailableRuntimeException( Undoable<?, ?, ?> aCommand, String message ) {
		super( aCommand, message );
	}

	/**
	 * Instantiates a new no result available runtime exception.
	 *
	 * @param aCommand the command
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public NoResultAvailableRuntimeException( Undoable<?, ?, ?> aCommand, Throwable aCause, String aErrorCode ) {
		super( aCommand, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new no result available runtime exception.
	 *
	 * @param aCommand the command
	 * @param cause the cause
	 */
	public NoResultAvailableRuntimeException( Undoable<?, ?, ?> aCommand, Throwable cause ) {
		super( aCommand, cause );
	}
}