/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.component.ConnectionAutomatonImpl;
import org.refcodes.component.ConnectionComponent;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;
import org.refcodes.data.Text;

public class ConnectionAutomatonTest
implements ConnectionComponent<String>,
ConnectionComponent.ConnectionAutomaton<String> {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String ACCEPTED = "ACCEPTED";
    private static final String REJECTED = "REJECTED";

    @Test
    public void testSunnyDayConnection() throws OpenException {
        ConnectionAutomatonImpl theConnectionAutomaton = new ConnectionAutomatonImpl((ConnectionComponent)this);
        Assertions.assertTrue((boolean)theConnectionAutomaton.isOpenable((Object)ACCEPTED));
        Assertions.assertFalse((boolean)theConnectionAutomaton.isOpened());
        Assertions.assertFalse((boolean)theConnectionAutomaton.isClosable());
        Assertions.assertFalse((boolean)theConnectionAutomaton.isClosed());
        theConnectionAutomaton.open((Object)ACCEPTED);
        Assertions.assertFalse((boolean)theConnectionAutomaton.isOpenable((Object)ACCEPTED));
        Assertions.assertTrue((boolean)theConnectionAutomaton.isOpened());
        Assertions.assertTrue((boolean)theConnectionAutomaton.isClosable());
        Assertions.assertFalse((boolean)theConnectionAutomaton.isClosed());
        theConnectionAutomaton.close();
        Assertions.assertTrue((boolean)theConnectionAutomaton.isOpenable((Object)ACCEPTED));
        Assertions.assertFalse((boolean)theConnectionAutomaton.isOpened());
        Assertions.assertFalse((boolean)theConnectionAutomaton.isClosable());
        Assertions.assertTrue((boolean)theConnectionAutomaton.isClosed());
        theConnectionAutomaton.open((Object)ACCEPTED);
        Assertions.assertFalse((boolean)theConnectionAutomaton.isOpenable((Object)ACCEPTED));
        Assertions.assertTrue((boolean)theConnectionAutomaton.isOpened());
        Assertions.assertTrue((boolean)theConnectionAutomaton.isClosable());
        Assertions.assertFalse((boolean)theConnectionAutomaton.isClosed());
    }

    @Test
    public void testRainyDayConnection() throws OpenException {
        ConnectionAutomatonImpl theConnectionAutomaton = new ConnectionAutomatonImpl((ConnectionComponent)this);
        Assertions.assertTrue((boolean)theConnectionAutomaton.isOpenable((Object)ACCEPTED));
        Assertions.assertFalse((boolean)theConnectionAutomaton.isOpened());
        Assertions.assertFalse((boolean)theConnectionAutomaton.isClosable());
        Assertions.assertFalse((boolean)theConnectionAutomaton.isClosed());
        theConnectionAutomaton.open((Object)ACCEPTED);
        try {
            theConnectionAutomaton.open((Object)ACCEPTED);
            Assertions.fail((String)"Component must not be openable.");
        }
        catch (OpenException openException) {
            // empty catch block
        }
        theConnectionAutomaton.close();
        theConnectionAutomaton.close();
    }

    @Test
    public void tesBadConnection() throws OpenException {
        ConnectionAutomatonImpl theConnectionAutomaton = new ConnectionAutomatonImpl((ConnectionComponent)this);
        Assertions.assertFalse((boolean)theConnectionAutomaton.isOpenable((Object)REJECTED));
        Assertions.assertFalse((boolean)theConnectionAutomaton.isOpened());
        Assertions.assertFalse((boolean)theConnectionAutomaton.isClosable());
        Assertions.assertFalse((boolean)theConnectionAutomaton.isClosed());
        try {
            theConnectionAutomaton.open((Object)REJECTED);
            Assertions.fail((String)"Component must not be openable.");
        }
        catch (OpenException openException) {
            // empty catch block
        }
        theConnectionAutomaton.close();
        theConnectionAutomaton.close();
    }

    public void open(String aConnection) throws OpenException {
        if (IS_LOG_TESTS) {
            System.out.println("open");
        }
        if (!this.isOpenable(aConnection)) {
            // empty if block
        }
    }

    public void close() {
        if (IS_LOG_TESTS) {
            System.out.println("close");
        }
    }

    public boolean isOpenable(String aConnection) {
        if (IS_LOG_TESTS) {
            System.out.println("isOpenable");
        }
        return aConnection.equals(ACCEPTED);
    }

    public boolean isOpened() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    public boolean isClosable() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    public boolean isClosed() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    public ConnectionStatus getConnectionStatus() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }
}

