/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.AndConditionImpl;
import org.refcodes.console.ArgsParserImpl;
import org.refcodes.console.Condition;
import org.refcodes.console.OptionalConditionImpl;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.StringOperandImpl;
import org.refcodes.console.StringOptionImpl;
import org.refcodes.console.SuperfluousArgsException;
import org.refcodes.console.SwitchImpl;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.Syntaxable;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public class StackOverflowTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

    @Test
    public void testParserStackOverflow1() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        StringOptionImpl r = new StringOptionImpl("-r", null, "opt1", "Your description for option r with argument opt1");
        StringOptionImpl s = new StringOptionImpl("-S", null, "opt2", "Your description for option S with argument opt2");
        StringOperandImpl arg1 = new StringOperandImpl("arg1", "Your description for arg1");
        StringOperandImpl arg2 = new StringOperandImpl("arg2", "Your description for arg2");
        StringOperandImpl arg3 = new StringOperandImpl("arg3", "Your description for arg3");
        StringOperandImpl arg4 = new StringOperandImpl("arg4", "Your description for arg4");
        SwitchImpl test = new SwitchImpl(null, "--test", "Your description for test");
        StringOptionImpl a = new StringOptionImpl("-A", null, "opt3", "Your description for option A with argument opt3");
        AndConditionImpl theRoot = new AndConditionImpl(new Syntaxable[]{r, s, a, arg1, arg2, arg3, arg4, test});
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theRoot);
        theArgsParser.withName("MyProgramm");
        theArgsParser.withSyntaxNotation(SyntaxNotation.GNU_POSIX);
        theArgsParser.printUsage();
        theArgsParser.printSeparatorLn();
        theArgsParser.printOptions();
        theArgsParser.evalArgs(new String[]{"-r", "RRRRR", "-S", "SSSSS", "11111", "22222", "33333", "44444", "--test", "-A", "AAAAA"});
        LOGGER.info("r    :=" + (String)r.getValue());
        LOGGER.info("S    :=" + (String)s.getValue());
        LOGGER.info("arg1 :=" + (String)arg1.getValue());
        LOGGER.info("arg2 :=" + (String)arg2.getValue());
        LOGGER.info("arg3 :=" + (String)arg3.getValue());
        LOGGER.info("arg4 :=" + (String)arg4.getValue());
        LOGGER.info("test :=" + test.getValue() + "");
        LOGGER.info("A    :=" + (String)a.getValue());
        Assertions.assertEquals((Object)r.getValue(), (Object)"RRRRR");
        Assertions.assertEquals((Object)s.getValue(), (Object)"SSSSS");
        Assertions.assertEquals((Object)arg1.getValue(), (Object)"11111");
        Assertions.assertEquals((Object)arg2.getValue(), (Object)"22222");
        Assertions.assertEquals((Object)arg3.getValue(), (Object)"33333");
        Assertions.assertEquals((Object)arg4.getValue(), (Object)"44444");
        Assertions.assertEquals((Object)test.getValue(), (Object)true);
        Assertions.assertEquals((Object)a.getValue(), (Object)"AAAAA");
    }

    @Test
    public void testParserStackOverflow2() throws UnknownArgsException, AmbiguousArgsException, SuperfluousArgsException, ParseArgsException {
        StringOptionImpl r = new StringOptionImpl("-r", null, "opt1", "Your description for option r with argument opt1");
        StringOptionImpl s = new StringOptionImpl("-S", null, "opt2", "Your description for option S with argument opt2");
        StringOperandImpl arg1 = new StringOperandImpl("arg1", "Your description for arg1");
        StringOperandImpl arg2 = new StringOperandImpl("arg2", "Your description for arg2");
        StringOperandImpl arg3 = new StringOperandImpl("arg3", "Your description for arg3");
        StringOperandImpl arg4 = new StringOperandImpl("arg4", "Your description for arg4");
        SwitchImpl test = new SwitchImpl(null, "--test", "Your description for test");
        StringOptionImpl a = new StringOptionImpl("-A", null, "opt3", "Your description for option A with argument opt3");
        AndConditionImpl theRoot = new AndConditionImpl(new Syntaxable[]{r, s, a, arg1, arg2, arg3, arg4, new OptionalConditionImpl(new Syntaxable[]{test})});
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theRoot);
        theArgsParser.withName("MyProgramm");
        theArgsParser.withSyntaxNotation(SyntaxNotation.GNU_POSIX);
        theArgsParser.printUsage();
        theArgsParser.printSeparatorLn();
        theArgsParser.printOptions();
        theArgsParser.evalArgs(new String[]{"-r", "RRRRR", "-S", "SSSSS", "11111", "22222", "33333", "44444", "-A", "AAAAA"});
        LOGGER.info("r    :=" + (String)r.getValue());
        LOGGER.info("S    :=" + (String)s.getValue());
        LOGGER.info("arg1 :=" + (String)arg1.getValue());
        LOGGER.info("arg2 :=" + (String)arg2.getValue());
        LOGGER.info("arg3 :=" + (String)arg3.getValue());
        LOGGER.info("arg4 :=" + (String)arg4.getValue());
        LOGGER.info("test :=" + test.getValue() + "");
        LOGGER.info("A    :=" + (String)a.getValue());
        Assertions.assertEquals((Object)r.getValue(), (Object)"RRRRR");
        Assertions.assertEquals((Object)s.getValue(), (Object)"SSSSS");
        Assertions.assertEquals((Object)arg1.getValue(), (Object)"11111");
        Assertions.assertEquals((Object)arg2.getValue(), (Object)"22222");
        Assertions.assertEquals((Object)arg3.getValue(), (Object)"33333");
        Assertions.assertEquals((Object)arg4.getValue(), (Object)"44444");
        Assertions.assertEquals((Object)test.getValue(), (Object)false);
        Assertions.assertEquals((Object)a.getValue(), (Object)"AAAAA");
    }
}

