/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.console;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.console.AmbiguousArgsException;
import org.refcodes.console.AndConditionImpl;
import org.refcodes.console.ArgsParser;
import org.refcodes.console.ArgsParserImpl;
import org.refcodes.console.Condition;
import org.refcodes.console.Operand;
import org.refcodes.console.OptionalConditionImpl;
import org.refcodes.console.OrConditionImpl;
import org.refcodes.console.ParseArgsException;
import org.refcodes.console.StringOperandImpl;
import org.refcodes.console.StringOptionImpl;
import org.refcodes.console.SuperfluousArgsException;
import org.refcodes.console.SwitchImpl;
import org.refcodes.console.SyntaxNotation;
import org.refcodes.console.Syntaxable;
import org.refcodes.console.UnknownArgsException;
import org.refcodes.console.XorConditionImpl;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class SyntaxableTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

    @Test
    public void testParser1() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFile = new StringOptionImpl("-f", "--file", "file", "The file to be processed");
        SwitchImpl theAdd = new SwitchImpl("-a", null, "Add the specified file");
        SwitchImpl theDelete = new SwitchImpl("-d", null, "Delete the specified file");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFile});
        String[] args = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser2() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFile = new StringOptionImpl("-f", "--file", "file", "The file to be processed");
        SwitchImpl theAdd = new SwitchImpl("-a", null, "Add the specified file");
        SwitchImpl theDelete = new SwitchImpl("-d", null, "Delete the specified file");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        OptionalConditionImpl theOptional = new OptionalConditionImpl(new Syntaxable[]{theXor});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theOptional, theFile});
        String[] args = new String[]{"-f", "someFile", "-d"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        theArgsParser.printUsage();
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertFalse((boolean)((Boolean)theAdd.getValue()));
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser3() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFile = new StringOptionImpl("-f", "--file", "file", "The file to be processed");
        SwitchImpl theAdd = new SwitchImpl("-a", null, "Add the specified file");
        SwitchImpl theDelete = new SwitchImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser4() throws AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFile = new StringOptionImpl("-f", "--file", "file", "The file to be processed");
        SwitchImpl theAdd = new SwitchImpl("-a", null, "Add the specified file");
        SwitchImpl theDelete = new SwitchImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expecting an exeption");
        }
        catch (UnknownArgsException unknownArgsException) {
            // empty catch block
        }
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser5() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException {
        StringOptionImpl theFile = new StringOptionImpl("-f", "--file", "file", "The file to be processed");
        SwitchImpl theAdd = new SwitchImpl("-a", null, "Add the specified file");
        SwitchImpl theDelete = new SwitchImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFile, theOperand});
        String[] args = new String[]{"-f", "someFile", "-a", "anOperand", "isSuperfluous"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        try {
            theArgsParser.evalArgs(args);
            Assertions.fail((String)"Expecting an exeption");
        }
        catch (SuperfluousArgsException e) {
            Assertions.assertEquals((int)1, (int)e.getArgs().length);
            Assertions.assertEquals((Object)"isSuperfluous", (Object)e.getArgs()[0]);
        }
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser6() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFromFile = new StringOptionImpl("-f", "--from", "from_file", "The source file to be processed");
        StringOptionImpl theToFile = new StringOptionImpl("-t", "--to", "to_file", "The destination file to be processed");
        SwitchImpl theAdd = new SwitchImpl("-a", null, "Add the specified file");
        SwitchImpl theDelete = new SwitchImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser7() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFromFile = new StringOptionImpl("-f", "--from", "from_file", "The source file to be processed");
        StringOptionImpl theToFile = new StringOptionImpl("-t", "--to", "to_file", "The destination file to be processed");
        SwitchImpl theAdd = new SwitchImpl("-a", null, "Add the specified file");
        SwitchImpl theDelete = new SwitchImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theAdd, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-t", "toFile", "anOperand", "-f", "fromFile", "-a"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    @Test
    public void testParser8() {
        StringOptionImpl theFromFile = new StringOptionImpl("-f", "--from", "from_file", "The source file to be processed");
        StringOptionImpl theToFile = new StringOptionImpl("-t", "--to", "to_file", "The destination file to be processed");
        SwitchImpl theAdd = new SwitchImpl("-a", null, "Add the specified file");
        SwitchImpl theDelete = new SwitchImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theDelete, theAdd});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theOperand, theXor, theFromFile, theToFile});
        List theList = theAnd.toOperands();
        Collections.sort(theList);
        this.doLogOperands(theList);
    }

    @Test
    public void testParser9() throws UnknownArgsException, AmbiguousArgsException, ParseArgsException, SuperfluousArgsException {
        StringOptionImpl theFromFile = new StringOptionImpl("-f", "--from", "from_file", "The source file to be processed, please provide a relative path as absolute paths are not permitted because absolute pahts may prevent path jail brakeing.");
        StringOptionImpl theToFile = new StringOptionImpl("-t", "--to", "to_file", "The destination file to be processed");
        SwitchImpl theAdd = new SwitchImpl("-a", null, "Add the specified file");
        SwitchImpl theCreate = new SwitchImpl("-c", null, "Creates the specified file");
        OrConditionImpl theOrCondition = new OrConditionImpl(new Syntaxable[]{theAdd, theCreate});
        SwitchImpl theDelete = new SwitchImpl("-d", null, "Delete the specified file");
        StringOperandImpl theOperand = new StringOperandImpl("operand", "The operand to be processed, it can be a complex artihmetic expression or a plain placeholder representing an environment variable.");
        XorConditionImpl theXor = new XorConditionImpl(new Syntaxable[]{theOrCondition, theDelete});
        AndConditionImpl theAnd = new AndConditionImpl(new Syntaxable[]{theXor, theFromFile, theToFile, theOperand});
        String[] args = new String[]{"-f", "fromFile", "-t", "toFile", "-a", "anOperand"};
        ArgsParserImpl theArgsParser = new ArgsParserImpl((Condition)theAnd);
        List theResult = theArgsParser.evalArgs(args);
        Assertions.assertTrue((boolean)((Boolean)theAdd.getValue()));
        Assertions.assertEquals((Object)"anOperand", (Object)theOperand.getValue());
        this.doLogArgs((ArgsParser)theArgsParser, args);
    }

    private void doLogArgs(ArgsParser aArgsParser, String[] aArgs) {
        Condition theCondition = aArgsParser.getRootCondition();
        LOGGER.info(RuntimeUtility.getCallerStackTraceElement(SyntaxableTest.class).getMethodName());
        aArgsParser.withSyntaxNotation(SyntaxNotation.GNU_POSIX).printHelp();
        LOGGER.info("[" + SyntaxNotation.REFCODES + " SYNTAX NOTATION]  " + theCondition.parseSyntax(SyntaxNotation.REFCODES));
        LOGGER.info("[" + SyntaxNotation.GNU_POSIX + " SYNTAX NOTATION] " + theCondition.parseSyntax(SyntaxNotation.GNU_POSIX));
        LOGGER.info("[COMMAND LINE ARGS]         " + new VerboseTextBuilderImpl().withElements((Object[])aArgs).toString());
        LOGGER.info("[INTERNAL STATUS]           " + theCondition.toString());
        LOGGER.info("---");
    }

    private void doLogOperands(List<? extends Operand<?>> aOperands) {
        LOGGER.info(RuntimeUtility.getCallerStackTraceElement(SyntaxableTest.class).getMethodName());
        for (Operand<?> eOperand : aOperands) {
            LOGGER.info("[OPERAND] " + eOperand.toSyntax(SyntaxNotation.REFCODES));
        }
        LOGGER.info("---");
    }
}

