/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.factory.impls;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.refcodes.collection.Clearable;
import org.refcodes.component.Configurable;
import org.refcodes.component.ConfigureException;
import org.refcodes.component.Resetable;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.factory.TypedRecyclingFactory;

public abstract class AbstractTypedRecyclingFactory<T>
implements TypedRecyclingFactory<T> {
    private Set<T> _recycledInstances = Collections.newSetFromMap(new WeakHashMap());
    private int _maxRecycledInstanceNumber = -1;

    public AbstractTypedRecyclingFactory() {
    }

    public AbstractTypedRecyclingFactory(int aMaxRecycledInstanceNumber) {
    }

    @Override
    public synchronized T createInstance() {
        if (!this._recycledInstances.isEmpty()) {
            try {
                Iterator<T> e = this._recycledInstances.iterator();
                T theNext = e.next();
                e.remove();
                return theNext;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return this.newInstance();
    }

    @Override
    public synchronized T createInstance(Properties aProperties) {
        if (!this._recycledInstances.isEmpty()) {
            Iterator<T> e = this._recycledInstances.iterator();
            T theInstance = e.next();
            if (theInstance instanceof Configurable) {
                Configurable theConfigurable = (Configurable)theInstance;
                try {
                    theConfigurable.initialize((Object)aProperties);
                    e.remove();
                    return theInstance;
                }
                catch (ClassCastException | ConfigureException exc) {
                    throw new UnsupportedOperationException("This operation is not supported; cannot configure recycled instance: \"" + ExceptionUtility.toMessage((Throwable)exc) + "\"");
                }
            }
            throw new UnsupportedOperationException("This operation is not supported; cannot configure recycled instance (it must implement the \"" + Configurable.class.getName() + "\" interface).");
        }
        return this.newInstance(aProperties);
    }

    @Override
    public synchronized void recycleInstance(T aInstance) {
        if (aInstance instanceof Resetable) {
            ((Resetable)aInstance).reset();
        }
        if (aInstance instanceof Clearable) {
            ((Clearable)aInstance).clear();
        }
        if (this._maxRecycledInstanceNumber == -1 || this._recycledInstances.size() < this._maxRecycledInstanceNumber) {
            this._recycledInstances.add(aInstance);
        }
    }

    public synchronized void clear() {
        this._recycledInstances.clear();
    }

    public int getInstanceCount() {
        return this._recycledInstances.size();
    }

    protected abstract T newInstance();

    protected abstract T newInstance(Properties var1);
}

