/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy.impls;

import org.refcodes.controlflow.impls.RetryCounterImpl;
import org.refcodes.exception.utils.ExceptionUtility;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.EncryptionServer;
import org.refcodes.forwardsecrecy.EncryptionService;
import org.refcodes.forwardsecrecy.generators.CipherVersionGenerator;
import org.refcodes.forwardsecrecy.traps.CipherUidAlreadyInUseException;
import org.refcodes.forwardsecrecy.traps.UnexpectedForwardSecrecyRuntimeException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.factories.impls.RuntimeLoggerFactorySingleton;

public abstract class AbstractEncryptionService
implements EncryptionService {
    private static RuntimeLogger LOGGER = (RuntimeLogger)RuntimeLoggerFactorySingleton.getInstance().createInstance();
    private CipherVersionGenerator<CipherVersion> _cipherVersionGenerator;
    private String _namespace;
    private EncryptionServer _encryptionServer;

    public AbstractEncryptionService(String aNamespace, EncryptionServer aEncryptionServer, CipherVersionGenerator<CipherVersion> aCipherVersionGenerator) {
        this._cipherVersionGenerator = aCipherVersionGenerator;
        this._encryptionServer = aEncryptionServer;
        this._namespace = aNamespace;
    }

    @Override
    public CipherVersion next() {
        Object eCipherVersion = null;
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(5, 100L);
        while (theRetryCounter.nextRetry()) {
            try {
                eCipherVersion = this._cipherVersionGenerator.next();
                this._encryptionServer.addCipherVersion(this._namespace, (CipherVersion)this.toEncryptedCipherVersion(eCipherVersion));
                return eCipherVersion;
            }
            catch (CipherUidAlreadyInUseException e) {
                if (theRetryCounter.hasNextRetry()) continue;
                LOGGER.warn("Failed to add a cipher UID \"" + eCipherVersion.getUniversalId() + "\", retry count is <" + theRetryCounter.getRetryCount() + "> of <" + theRetryCounter.getRetryNumber() + "> (waiting for <" + theRetryCounter.getNextRetryDelayInMs() / 1000L + "> seconds before next retry): \"" + ExceptionUtility.toMessage((Throwable)((Object)e)) + "\"");
            }
        }
        throw new UnexpectedForwardSecrecyRuntimeException("Unable to generate a Chipher-Version within <" + theRetryCounter.getRetryNumber() + "> tries, aborting as else we might loop infinte time!");
    }

    public boolean hasNext() {
        return true;
    }

    public void remove() {
        throw new UnsupportedOperationException("*** OPERATION NOT SUPPORTED ***");
    }

    protected abstract <CV extends CipherVersion> CV toEncryptedCipherVersion(CV var1);
}

